/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.reusable.MyBatchletImpl;
import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentUserData;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;

public class StepExecutionTests
extends ServiceEETest {
    private static final Logger logger = Logger.getLogger(StepExecutionTests.class.getName());
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public static void cleanup() throws EETest.Fault {
    }

    private void begin(String str) {
        TestUtil.logMsg((String)("Begin test method: " + str + ""));
    }

    public void testOneStepExecutionStatus() throws EETest.Fault {
        String METHOD = "testOneStepExecutionStatus";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_1step.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
                TestUtil.logMsg((String)("Step status = " + step.getBatchStatus() + ""));
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, step.getBatchStatus());
            }
            TestUtil.logMsg((String)("Job execution status = " + jobExec.getBatchStatus() + ""));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public void testFourStepExecutionStatus() throws EETest.Fault {
        String METHOD = "testFourStepExecutionStatus";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_4steps.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_4steps");
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(4, steps.size());
            HashSet<Long> stepExecutionsSeen = new HashSet<Long>();
            for (StepExecution step : steps) {
                this.showStepState(step);
                TestUtil.logMsg((String)("Step status = " + step.getBatchStatus() + ""));
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, step.getBatchStatus());
                AssertionUtils.assertWithMessage("New StepExecution id", !stepExecutionsSeen.contains(step.getStepExecutionId()));
                stepExecutionsSeen.add(step.getStepExecutionId());
            }
            TestUtil.logMsg((String)("Job execution status = " + jobExec.getBatchStatus() + ""));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public void testFailedStepExecutionStatus() throws EETest.Fault {
        String METHOD = "testFailedStepExecutionStatus";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_failElement.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_failElement");
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
            }
            TestUtil.logMsg((String)("Job execution getExitStatus()=" + jobExec.getExitStatus()));
            TestUtil.logMsg((String)("Job execution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals("TEST_FAIL", jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public void testStoppedStepExecutionStatus() throws EETest.Fault {
        String METHOD = "testStoppedStepExecutionStatus";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_stopElement.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_stopElement");
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
            }
            TestUtil.logMsg((String)("Job execution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public void testPersistedStepData() throws EETest.Fault {
        String METHOD = "testPersistedStepData";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_persistedData.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"force.failure=true");
            jobParameters.setProperty("force.failure", "true");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_persistedData", jobParameters);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            StepExecution stepExec = steps.get(0);
            AssertionUtils.assertObjEquals(1, steps.size());
            TestUtil.logMsg((String)("execution #1 StepExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, stepExec.getBatchStatus());
            AssertionUtils.assertObjEquals(4, ((MyPersistentUserData)stepExec.getPersistentUserData()).getData());
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with execution id: " + jobExec.getExecutionId() + ""));
            TCKJobExecutionWrapper restartedJobExec = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), jobParameters);
            steps = jobOp.getStepExecutions(restartedJobExec.getExecutionId());
            stepExec = steps.get(0);
            TestUtil.logMsg((String)("execution #1 StepExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, stepExec.getBatchStatus());
            AssertionUtils.assertObjEquals(5, ((MyPersistentUserData)stepExec.getPersistentUserData()).getData());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public void testStepExecutionExitStatus() throws EETest.Fault {
        String METHOD = "testStepExecutionExitStatus";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_failElement.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_failElement");
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, steps.size());
            StepExecution step = steps.get(0);
            this.showStepState(step);
            AssertionUtils.assertWithMessage("Check step exit status", MyBatchletImpl.GOOD_EXIT_STATUS, step.getExitStatus());
            AssertionUtils.assertWithMessage("Check step batch status", BatchStatus.COMPLETED, step.getBatchStatus());
            TestUtil.logMsg((String)("Job batch status =" + jobExec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("Job exit status =" + jobExec.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Check job batch status", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Check job exit status", "TEST_FAIL", jobExec.getExitStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public void testStepInFlowStepExecution() throws EETest.Fault {
        String METHOD = "testStepInFlowStepExecution";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_failElement.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("flow_transition_to_step");
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(4, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
                AssertionUtils.assertWithMessage("Check step exit status", MyBatchletImpl.GOOD_EXIT_STATUS, step.getExitStatus());
                AssertionUtils.assertWithMessage("Check step batch status", BatchStatus.COMPLETED, step.getBatchStatus());
            }
            TestUtil.logMsg((String)("Job batch status =" + jobExec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("Job exit status =" + jobExec.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Check job batch status", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Check job exit status", "flow1step1, flow1step2, flow1step3, step1", jobExec.getExitStatus());
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    public void testStepInFlowInSplitStepExecution() throws EETest.Fault {
        String METHOD = "testStepInFlowInSplitStepExecution";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: split_batchlet_4steps.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("split_batchlet_4steps");
            AssertionUtils.assertWithMessage("Check job batch status", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Check job exit status", "COMPLETED", jobExec.getExitStatus());
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(4, steps.size());
            for (StepExecution step : steps) {
                this.showStepState(step);
                AssertionUtils.assertWithMessage("Check step exit status", MyBatchletImpl.GOOD_EXIT_STATUS, step.getExitStatus());
                AssertionUtils.assertWithMessage("Check step batch status", BatchStatus.COMPLETED, step.getBatchStatus());
            }
            TestUtil.logMsg((String)("Job batch status =" + jobExec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("Job exit status =" + jobExec.getExitStatus() + ""));
        }
        catch (Exception e) {
            StepExecutionTests.handleException(METHOD, e);
        }
    }

    private void showStepState(StepExecution step) {
        TestUtil.logMsg((String)"---------------------------");
        TestUtil.logMsg((String)("getStepName(): " + step.getStepName() + " - "));
        TestUtil.logMsg((String)("getStepExecutionId(): " + step.getStepExecutionId() + " - "));
        Metric[] metrics = step.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            TestUtil.logMsg((String)(metrics[i].getType() + ": " + metrics[i].getValue() + " - "));
        }
        TestUtil.logMsg((String)("getStartTime(): " + step.getStartTime() + " - "));
        TestUtil.logMsg((String)("getEndTime(): " + step.getEndTime() + " - "));
        TestUtil.logMsg((String)("getBatchStatus(): " + step.getBatchStatus() + " - "));
        TestUtil.logMsg((String)("getExitStatus(): " + step.getExitStatus()));
        TestUtil.logMsg((String)"---------------------------");
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

