/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.internetMimeMultipart;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import com.sun.ts.tests.javamail.ee.internetMimeMultipart.MyMimeMultipart;
import com.sun.ts.tests.javamail.ee.internetMimeMultipart.NullOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.Properties;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class internetMimeMultipart_Test
extends ServiceEETest {
    private int errors = 0;
    private MailTestUtil mailTestUtil;
    private Folder folder;
    private Message[] msgs;
    private Store store;
    private Status status;
    private int msgcount = -1;
    static Session session;
    private String workDir;
    private String ioFile;

    public static void main(String[] args) {
        internetMimeMultipart_Test theTests = new internetMimeMultipart_Test();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            String host = TestUtil.getProperty((String)"javamail.server");
            String user = TestUtil.getProperty((String)"javamail.username");
            String password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            this.workDir = TestUtil.getProperty((String)"work.dir");
            this.ioFile = TestUtil.getProperty((String)"iofile");
            String smtpPortStr = TestUtil.getProperty((String)"smtp.port");
            int smtpPort = Integer.parseInt(smtpPortStr);
            TestUtil.logTrace((String)("SMTP Port = " + smtpPort));
            String imapPortStr = TestUtil.getProperty((String)"imap.port");
            int imapPort = Integer.parseInt(imapPortStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            this.mailTestUtil = new MailTestUtil();
            this.store = this.mailTestUtil.connect2host(protocol, host, imapPort, user, password);
            session = this.mailTestUtil.getSession();
            Folder root = this.mailTestUtil.getRootFolder(this.store);
            this.folder = root.getFolder(mailbox);
            if (this.folder == null) {
                throw new EETest.Fault("Invalid folder object!");
            }
            this.folder.open(1);
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void test1() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"\nTesting class MimeMultipart: initializeProperties method\n");
            internetMimeMultipart_Test.clearAll();
            TestUtil.logMsg((String)"UNIT TEST 1:  initializeProperties()");
            MyMimeMultipart mp = new MyMimeMultipart();
            if (mp.checkDefault()) {
                TestUtil.logMsg((String)"UNIT TEST 1:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 1:  FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 2:  initializeProperties()");
            System.setProperty("mail.mime.multipart.ignoreexistingboundaryparameter", "true");
            System.setProperty("mail.mime.multipart.ignoremissingboundaryparameter", "false");
            System.setProperty("mail.mime.multipart.ignoremissingendboundary", "false");
            System.setProperty("mail.mime.multipart.allowempty", "true");
            mp = new MyMimeMultipart();
            if (mp.checkNonDefault()) {
                TestUtil.logMsg((String)"UNIT TEST 2:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 2:  FAILED\n");
                ++this.errors;
            }
            this.checkStatus();
            if (this.errors > 0) {
                throw new EETest.Fault("test1 Failed: No of unit test failed = " + this.errors);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test1 Failed");
        }
    }

    public void properties_Test() throws EETest.Fault {
        TestUtil.logMsg((String)"\nTesting class MimeMultipart: effect of system property settings\n");
        Properties properties = this.mailTestUtil.getProperties();
        try {
            TestUtil.logMsg((String)"UNIT TEST 1:  test for parse(InputStream) with no System properties set");
            internetMimeMultipart_Test.clearAll();
            MimeMessage m = internetMimeMultipart_Test.createMessage("x", "x", true);
            MimeMultipart mp = (MimeMultipart)m.getContent();
            if (mp.getCount() == 2) {
                TestUtil.logMsg((String)"UNIT TEST 1:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 1:  FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 2:  test for parse(InputStream) with mail.mime.multipart.ignoreexistingboundaryparameter=true");
            internetMimeMultipart_Test.clearAll();
            System.setProperty("mail.mime.multipart.ignoreexistingboundaryparameter", "true");
            m = internetMimeMultipart_Test.createMessage("x", "-", true);
            mp = (MimeMultipart)m.getContent();
            if (mp.getCount() == 2) {
                TestUtil.logMsg((String)"UNIT TEST 2:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 2:  FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 3:  test for parse(InputStream) with no boundary parameter");
            internetMimeMultipart_Test.clearAll();
            m = internetMimeMultipart_Test.createMessage(null, "x", true);
            mp = (MimeMultipart)m.getContent();
            if (mp.getCount() == 2) {
                TestUtil.logMsg((String)"UNIT TEST 3:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 3:  FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 4:  test for parse(InputStream) with no boundary parameter and mail.mime.multipart.ignoremissingboundaryparameter=false");
            internetMimeMultipart_Test.clearAll();
            System.setProperty("mail.mime.multipart.ignoremissingboundaryparameter", "false");
            try {
                m = internetMimeMultipart_Test.createMessage(null, "x", true);
                mp = (MimeMultipart)m.getContent();
                mp.getCount();
                TestUtil.logMsg((String)"UNIT TEST 4:  FAILED\n");
                ++this.errors;
            }
            catch (MessagingException mex) {
                TestUtil.logMsg((String)"UNIT TEST 4:  passed\n");
            }
            TestUtil.logMsg((String)"UNIT TEST 5:  test for parse(InputStream) with no end boundary");
            internetMimeMultipart_Test.clearAll();
            m = internetMimeMultipart_Test.createMessage("x", "x", false);
            mp = (MimeMultipart)m.getContent();
            if (mp.getCount() == 2) {
                TestUtil.logMsg((String)"UNIT TEST 5:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 5:  FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 6:  test for parse(InputStream) with no end boundarymail.mime.multipart.ignoremissingendboundary=false");
            internetMimeMultipart_Test.clearAll();
            try {
                System.setProperty("mail.mime.multipart.ignoremissingendboundary", "false");
                m = internetMimeMultipart_Test.createMessage("x", "x", false);
                mp = (MimeMultipart)m.getContent();
                mp.getCount();
                TestUtil.logMsg((String)"UNIT TEST 6:  FAILED\n");
                ++this.errors;
            }
            catch (MessagingException mex) {
                TestUtil.logMsg((String)"UNIT TEST 6:  passed\n");
            }
            TestUtil.logMsg((String)"UNIT TEST 7:  test for parse(InputStream) with mail.mime.multipart.allowempty=true");
            internetMimeMultipart_Test.clearAll();
            System.setProperty("mail.mime.multipart.allowempty", "true");
            m = internetMimeMultipart_Test.createEmptyMessage();
            mp = (MimeMultipart)m.getContent();
            if (mp.getCount() == 0) {
                TestUtil.logMsg((String)"UNIT TEST 7:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 7:  FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 8:  test for parse(InputStream) with mail.mime.multipart.allowempty default");
            internetMimeMultipart_Test.clearAll();
            try {
                m = internetMimeMultipart_Test.createEmptyMessage();
                mp = (MimeMultipart)m.getContent();
                mp.getCount();
                TestUtil.logMsg((String)"UNIT TEST 8:  FAILED\n");
                ++this.errors;
            }
            catch (MessagingException mex) {
                TestUtil.logMsg((String)"UNIT TEST 8:  passed\n");
            }
            TestUtil.logMsg((String)"UNIT TEST 9:  test for writeTo(OutputStream) with mail.mime.multipart.allowempty=true");
            internetMimeMultipart_Test.clearAll();
            System.setProperty("mail.mime.multipart.allowempty", "true");
            m = new MimeMessage(session);
            mp = new MimeMultipart();
            m.setContent((Multipart)mp);
            m.writeTo((OutputStream)new NullOutputStream());
            if (mp.getCount() == 0) {
                TestUtil.logMsg((String)"UNIT TEST 9:  passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 9:  FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 10:  test for writeTo(OutputStream) with mail.mime.multipart.allowempty default");
            internetMimeMultipart_Test.clearAll();
            try {
                m = new MimeMessage(session);
                mp = new MimeMultipart();
                m.setContent((Multipart)mp);
                m.writeTo((OutputStream)new NullOutputStream());
                TestUtil.logMsg((String)"UNIT TEST 10:  FAILED\n");
                ++this.errors;
            }
            catch (IOException ioex) {
                TestUtil.logMsg((String)"UNIT TEST 10:  passed\n");
            }
            this.checkStatus();
            if (this.errors > 0) {
                throw new EETest.Fault("test1 Failed: No of unit test failed = " + this.errors);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test1 Failed");
        }
    }

    public void mimeMultipartTest() throws EETest.Fault {
        TestUtil.logMsg((String)"\nTesting class MimeMultipart: MimeMultipart(void | DataSource)\n");
        try {
            TestUtil.logMsg((String)"UNIT TEST 1:  MimeMultipart()");
            MimeMultipart mp = new MimeMultipart();
            if (mp != null && mp instanceof MimeMultipart) {
                TestUtil.logMsg((String)"UNIT TEST 1: passed");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 1: FAILED");
                ++this.errors;
            }
            FileDataSource ds = new FileDataSource(this.workDir + this.ioFile);
            if (ds == null) {
                throw new EETest.Fault("WARNING: null FileDataSource object");
            }
            TestUtil.logMsg((String)"UNIT TEST 2:  MimeMultipart(DataSource)");
            MimeMultipart mmp = new MimeMultipart((DataSource)ds);
            if (mmp != null && mmp instanceof MimeMultipart) {
                TestUtil.logMsg((String)"UNIT TEST 2: passed");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 2: FAILED");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 3:  MimeMultipart(String, BodyParts...)");
            MimeBodyPart mbp1 = new MimeBodyPart();
            String cont1 = "part1";
            mbp1.setText(cont1);
            MimeBodyPart mbp2 = new MimeBodyPart();
            String cont2 = "part2";
            mbp2.setText(cont2);
            MimeMultipart mpp = new MimeMultipart("mixed", new BodyPart[]{mbp1, mbp2});
            if (mpp.getCount() == 2 && mpp.getBodyPart(0).getContent().equals(cont1) && mpp.getBodyPart(1).getContent().equals(cont2)) {
                TestUtil.logMsg((String)"UNIT TEST 3: passed");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 3: FAILED");
                ++this.errors;
            }
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test1 Failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("Cleanup ;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }

    public void checkStatus() {
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
    }

    private static void clearAll() {
        System.clearProperty("mail.mime.multipart.ignoreexistingboundaryparameter");
        System.clearProperty("mail.mime.multipart.ignoremissingboundaryparameter");
        System.clearProperty("mail.mime.multipart.ignoremissingendboundary");
        System.clearProperty("mail.mime.multipart.allowempty");
    }

    private static MimeMessage createMessage(String param, String actual, boolean end) throws MessagingException {
        String content = "Mime-Version: 1.0\nSubject: Example\nContent-Type: multipart/mixed; " + (param != null ? "boundary=\"" + param + "\"" : "") + "\n\npreamble\n--" + actual + "\n\nfirst part\n\n--" + actual + "\n\nsecond part\n\n" + (end ? "--" + actual + "--\n" : "");
        return new MimeMessage(session, (InputStream)new StringBufferInputStream(content));
    }

    private static MimeMessage createEmptyMessage() throws MessagingException {
        String content = "Mime-Version: 1.0\nSubject: Example\nContent-Type: multipart/mixed; boundary=\"x\"\n\n";
        return new MimeMessage(session, (InputStream)new StringBufferInputStream(content));
    }
}

