/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Stream;
import jdk.incubator.http.internal.common.ExceptionallyCloseable;

public class Queue<T>
implements ExceptionallyCloseable {
    private final LinkedList<T> q = new LinkedList();
    private volatile boolean closed = false;
    private volatile Throwable exception = null;
    private Runnable callback;
    private boolean callbackDisabled = false;
    private int waiters;

    public synchronized int size() {
        return this.q.size();
    }

    public synchronized boolean tryPut(T t) throws IOException {
        if (this.closed) {
            return false;
        }
        this.put(t);
        return true;
    }

    public synchronized void put(T t) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.q.add(t);
        if (this.waiters > 0) {
            this.notifyAll();
        }
        if (this.callbackDisabled) {
            return;
        }
        if (this.q.size() > 0 && this.callback != null) {
            this.callback.run();
        }
    }

    public synchronized void disableCallback() {
        this.callbackDisabled = true;
    }

    public synchronized void enableCallback() {
        this.callbackDisabled = false;
        while (this.q.size() > 0) {
            this.callback.run();
        }
    }

    public synchronized void registerPutCallback(Runnable runnable) {
        Objects.requireNonNull(runnable);
        this.callback = runnable;
        if (this.q.size() > 0) {
            runnable.run();
        }
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    @Override
    public synchronized void closeExceptionally(Throwable throwable) {
        if (this.exception == null) {
            this.exception = throwable;
        } else if (throwable != null && throwable != this.exception && !Stream.of(this.exception.getSuppressed()).filter(throwable2 -> throwable2 == throwable).findFirst().isPresent()) {
            this.exception.addSuppressed(throwable);
        }
        this.close();
    }

    public synchronized T take() throws IOException {
        if (this.closed) {
            throw this.newIOException("stream closed");
        }
        try {
            while (this.q.size() == 0) {
                ++this.waiters;
                this.wait();
                if (this.closed) {
                    throw this.newIOException("Queue closed");
                }
                --this.waiters;
            }
            return this.q.removeFirst();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public synchronized T poll() throws IOException {
        if (this.closed) {
            throw this.newIOException("stream closed");
        }
        if (this.q.isEmpty()) {
            return null;
        }
        T t = this.q.removeFirst();
        return t;
    }

    public synchronized T[] pollAll(T[] TArray) throws IOException {
        T[] TArray2 = this.q.toArray(TArray);
        this.q.clear();
        return TArray2;
    }

    public synchronized void pushback(T t) {
        this.q.addFirst(t);
    }

    public synchronized void pushbackAll(T[] TArray) {
        for (int i = TArray.length - 1; i >= 0; --i) {
            this.q.addFirst(TArray[i]);
        }
    }

    private IOException newIOException(String string) {
        if (this.exception == null) {
            return new IOException(string);
        }
        return new IOException(string, this.exception);
    }
}

