/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.spec.ManagedScheduledExecutorService.tx;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.spec.ManagedScheduledExecutorService.tx.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.annotation.Resource;
import javax.sql.DataSource;

public class Client
extends EETest {
    private String host = null;
    private int port;
    private Properties props = null;
    private String appendedURL = "";
    private String username;
    private String password;
    @Resource(lookup="jdbc/DB1")
    private static DataSource ds;
    private Connection conn;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"setup");
        try {
            this.port = Integer.parseInt(p.getProperty("webServerPort"));
            this.host = p.getProperty("webServerHost");
            if (this.port < 1) {
                throw new Exception("'port' in ts.jte must be > 0");
            }
            if (this.host == null) {
                throw new Exception("'host' in ts.jte must not be null ");
            }
            this.props = new Properties(p);
            this.appendedURL = this.appendedURL(p);
            this.username = p.getProperty("user1");
            this.password = p.getProperty("password1");
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void testCommitTransactionWithManagedScheduledExecutorService() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(Util.getUrl("/tx", this.host, this.port) + this.appendedURL + "&" + "isCommit" + "=true");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!"Successfull!".equals(resp)) {
            throw new EETest.Fault("testTransactionWithManagedScheduledExecutorService fail to get successful result.");
        }
    }

    public void testRollbackTransactionWithManagedScheduledExecutorService() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(Util.getUrl("/tx", this.host, this.port) + this.appendedURL + "&" + "isCommit" + "=false");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!"Successfull!".equals(resp)) {
            throw new EETest.Fault("testRollbackTransactionWithManagedScheduledExecutorService fail to get successful result.");
        }
    }

    public void testCancelTransactionWithManagedScheduledExecutorService() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(Util.getUrl("/tx", this.host, this.port) + this.appendedURL + "&" + "isCommit" + "=" + "cancel");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!"Successfull!".equals(resp)) {
            throw new EETest.Fault("testCancelTransactionWithManagedScheduledExecutorService fail to get successful result.");
        }
    }

    private String appendedURL(Properties p) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("?");
        sb.append("user1=" + p.get("user1"));
        sb.append("&");
        sb.append("password1=" + p.get("password1"));
        sb.append("&");
        sb.append("concurrencetable=concurrencetable");
        sb.append("&");
        sb.append("Dbschema_Concur_Insert=" + URLEncoder.encode(p.get("Dbschema_Concur_Insert").toString(), "utf8"));
        return sb.toString();
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.removeTestData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EETest.Fault("cleanup failed.", e);
        }
        TestUtil.logTrace((String)"test cleanup ok");
    }

    private void removeTestData() throws RemoteException {
        TestUtil.logTrace((String)"removeTestData");
        this.conn = Util.getConnection(ds, this.username, this.password, true);
        String removeString = this.props.getProperty("Dbschema_Concur_Delete", "");
        try {
            Statement stmt = this.conn.createStatement();
            stmt.executeUpdate(removeString);
            stmt.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        finally {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

