/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.ExtensibleObject;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Slot;

public class JAXRClient
extends JAXRCommonClient {
    String streetNumber = "47";
    String street = "Amsden";
    String city = "Arlington";
    String stateOrProvince = "MA";
    String country = "USA";
    String postalCode = "02146";
    String type = "home";

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void extensibleObject_addGetSlotTest() throws EETest.Fault {
        String testName = "extensibleObject_addGetSlotTest";
        boolean pass = true;
        String slotName = "sortCode";
        String value = "2472974";
        String slotType = "slotType";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            Slot s = this.blm.createSlot(slotName, values, slotType);
            PostalAddress pa = this.blm.createPostalAddress(this.streetNumber, this.street, this.city, this.stateOrProvince, this.country, this.postalCode, this.type);
            pa.addSlot(s);
            Slot slot = pa.getSlot(slotName);
            this.debug.add("\n");
            this.debug.add("getName should return:" + slotName + "\n");
            this.debug.add("getName returned:" + slot.getName() + "\n");
            if (!slot.getName().equals(slotName)) {
                pass = false;
            }
            this.debug.add("getSlotType should return:" + slotType + "\n");
            this.debug.add("getSlotType returned:" + slot.getSlotType() + "\n");
            if (!slot.getSlotType().equals(slotType)) {
                pass = false;
            }
            Collection c = slot.getValues();
            Object[] slotValues = c.toArray();
            this.debug.add("value should return: " + value + "\n");
            for (int i = 0; i < c.size(); ++i) {
                this.debug.add("value returned " + (String)slotValues[i] + "\n");
            }
            if (!c.containsAll(values)) {
                pass = false;
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void extensibleObject_addGetSlotsTest() throws EETest.Fault {
        String testName = "extensibleObject_addGetSlotsTest";
        String value = "2472974";
        String slotType = null;
        String value2 = "2323233";
        String[] slotName = new String[]{"sortCode", "addressLines"};
        int found = 0;
        try {
            Slot s1 = this.blm.createSlot(slotName[0], value, slotType);
            Slot s2 = this.blm.createSlot(slotName[1], value2, slotType);
            ArrayList<Slot> slots = new ArrayList<Slot>();
            slots.add(s1);
            slots.add(s2);
            PostalAddress pa = this.blm.createPostalAddress(this.streetNumber, this.street, this.city, this.stateOrProvince, this.country, this.postalCode, this.type);
            pa.addSlots(slots);
            this.debug.add("Add and verify 2 slots\n");
            Collection retSlots = pa.getSlots();
            if (!retSlots.containsAll(slots)) {
                throw new EETest.Fault(testName + "failed to verify slots were added, test did not complete! ");
            }
            for (Slot slot : retSlots) {
                if (!slot.getName().equals(slotName[0]) && !slot.getName().equals(slotName[1])) continue;
                ++found;
            }
            if (found != slotName.length) {
                throw new EETest.Fault(testName + "fail - did not find expected number of slots");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "fail - unexpected error!");
        }
    }

    public void extensibleObject_removeSlotTest() throws EETest.Fault {
        String testName = "extensibleObject_removeSlotTest";
        String slotName = "sortCode";
        String value = "2472974";
        String slotType = "slotType";
        try {
            Slot s = this.blm.createSlot(slotName, value, slotType);
            PostalAddress pa = this.blm.createPostalAddress(this.streetNumber, this.street, this.city, this.stateOrProvince, this.country, this.postalCode, this.type);
            pa.addSlot(s);
            this.debug.add("Created and added a slot to PostalAddress \n");
            Slot slot = pa.getSlot(slotName);
            this.debug.add("Verify that the slot was added \n");
            this.debug.add("getName should return:" + slotName + "\n");
            this.debug.add("getName returned:" + slot.getName() + "\n");
            if (!slot.getName().equals(slotName)) {
                throw new EETest.Fault(testName + "failed  test did not complete");
            }
            this.debug.add("Remove the slot and verify it removal \n");
            pa.removeSlot(slotName);
            Slot noSlot = pa.getSlot(slotName);
            this.debug.add("returned slot should return null  \n");
            if (noSlot != null) {
                throw new EETest.Fault(testName + "failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed - unexpected exception! ");
        }
    }

    public void extensibleObject_removeSlotsTest() throws EETest.Fault {
        String testName = "extensibleObject_removeSlotsTest";
        String slotName = "sortCode";
        String value = "2472974";
        String slotType = null;
        String slotName2 = "addressLines";
        String value2 = "2323233";
        try {
            Slot s1 = this.blm.createSlot(slotName, value, slotType);
            Slot s2 = this.blm.createSlot(slotName2, value2, slotType);
            ArrayList<Slot> slots = new ArrayList<Slot>();
            slots.add(s1);
            slots.add(s2);
            PostalAddress pa = this.blm.createPostalAddress(this.streetNumber, this.street, this.city, this.stateOrProvince, this.country, this.postalCode, this.type);
            pa.addSlot(s1);
            pa.addSlot(s2);
            this.debug.add("Add and verify 2 slots\n");
            Collection retSlots = pa.getSlots();
            if (!retSlots.containsAll(slots)) {
                throw new EETest.Fault(testName + "failed to verify slots were added, test did not complete! ");
            }
            this.debug.add("Slot addition verified ok - now remove the slots with removeSlots method \n");
            ArrayList<String> slotNames = new ArrayList<String>();
            slotNames.add(slotName);
            slotNames.add(slotName2);
            pa.removeSlots(slotNames);
            Collection noSlots = pa.getSlots();
            this.debug.add("Returned " + noSlots.size() + " slots \n");
            if (noSlots.size() != 0) {
                throw new EETest.Fault(testName + "failed to return an empty collection \n");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "fail - unexpected error!");
        }
    }
}

