/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.common;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ListenerEvent;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ManagedTaskListenerImpl;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Util {
    private static final String MANAGED_EXECUTOR_SVC_JNDI_NAME = "java:comp/DefaultManagedExecutorService";
    public static final String SCHEDULED_MANAGED_EXECUTOR_SVC_JNDI_NAME = "java:comp/DefaultManagedScheduledExecutorService";
    public static final String MANAGED_THREAD_FACTORY_SVC_JNDI_NAME = "java:comp/DefaultManagedThreadFactory";
    public static final long COMMON_CHECK_INTERVAL = 5000L;
    public static final long COMMON_TASK_TIMEOUT = 30000L;
    public static final int COMMON_CHECK_INTERVAL_IN_SECOND = 5;
    public static final int COMMON_TASK_TIMEOUT_IN_SECOND = 30;
    public static final String SERVLET_RETURN_SUCCESS = "success";
    public static final String SERVLET_RETURN_FAIL = "fail";

    private Util() {
    }

    public static <T> T waitForTaskComplete(Future<T> future, int maxTaskWaitTime) throws EETest.Fault {
        T result = null;
        try {
            result = future.get(maxTaskWaitTime, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new EETest.Fault("failed to finish task", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new EETest.Fault("failed to finish task", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new EETest.Fault("failed to finish task in " + maxTaskWaitTime + " seconds.", (Throwable)e);
        }
        catch (Exception e) {
            throw new EETest.Fault("failed to finish task ", (Throwable)e);
        }
        return result;
    }

    public static void waitForListenerComplete(ManagedTaskListenerImpl managedTaskListener, long maxListenerWaitTime, int poolInterval) {
        long stopTime = System.currentTimeMillis() + maxListenerWaitTime;
        while (!managedTaskListener.eventCalled(ListenerEvent.DONE) && System.currentTimeMillis() < stopTime) {
            TestUtil.sleep((int)poolInterval);
        }
    }

    public static ManagedExecutorService getManagedExecutorService() {
        InitialContext ctx = null;
        ManagedExecutorService managedExecutorSvc = null;
        try {
            ctx = new InitialContext();
            managedExecutorSvc = (ManagedExecutorService)ctx.lookup(MANAGED_EXECUTOR_SVC_JNDI_NAME);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                TestUtil.logErr((String)"Exception: ", (Throwable)e);
            }
        }
        return managedExecutorSvc;
    }

    public static void waitTillFutureIsDone(Future future) {
        long start = System.currentTimeMillis();
        while (!future.isDone()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 30000L) continue;
            throw new RuntimeException("wait task timeout");
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        String msg = "expected " + expected + " but you got " + actual;
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            throw new RuntimeException(msg);
        }
        if (!expected.equals(actual)) {
            throw new RuntimeException(msg);
        }
    }

    public static void assertInRange(Object[] range, Object actual) {
        String expected = "";
        for (Object each : range) {
            expected = expected + each.toString();
            expected = expected + ",";
        }
        expected = expected.substring(0, expected.length() - 1);
        String msg = "expected in " + expected + " but you got " + actual;
        for (Object each : range) {
            if (!each.equals(actual)) continue;
            return;
        }
        throw new RuntimeException(msg);
    }

    public static void asserIntInRange(int low, int high, int actual) {
        String msg = "expected in range " + low + " , " + high;
        msg = msg + " but you got " + actual;
        if (actual < low || actual > high) {
            throw new RuntimeException(msg);
        }
    }

    public static void waitTillThreadFinish(Thread thread) {
        long start = System.currentTimeMillis();
        while (thread.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 30000L) continue;
            throw new RuntimeException("wait task timeout");
        }
    }
}

