/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.sessiontests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.sessiontests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool toolT = null;
    private transient JmsTool toolT2 = null;
    private transient JmsTool toolQ = null;
    private transient ConnectionFactory cf = null;
    private transient Topic topic = null;
    private transient Queue queue = null;
    private transient Destination destination = null;
    private transient Connection connection = null;
    private transient Session session = null;
    private transient MessageProducer producer = null;
    private transient MessageConsumer consumer = null;
    private transient MessageConsumer consumer2 = null;
    private transient TopicSubscriber subscriber = null;
    private transient TopicSubscriber subscriber2 = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    String vehicle = null;
    private static final String lookupDurableTopicFactory = "DURABLE_SUB_CONNECTION_FACTORY";
    private static final String lookupNormalTopicFactory = "MyTopicConnectionFactory";
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList connections = null;
    boolean queueTest = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setupGlobalVarsQ() throws Exception {
        this.cf = this.toolQ.getConnectionFactory();
        this.destination = this.toolQ.getDefaultDestination();
        this.session = this.toolQ.getDefaultSession();
        this.connection = this.toolQ.getDefaultConnection();
        this.producer = this.toolQ.getDefaultProducer();
        this.consumer = this.toolQ.getDefaultConsumer();
        this.queue = (Queue)this.destination;
        this.connection.start();
        this.queueTest = true;
    }

    public void setupGlobalVarsT() throws Exception {
        this.cf = this.toolT.getConnectionFactory();
        this.destination = this.toolT.getDefaultDestination();
        this.session = this.toolT.getDefaultSession();
        this.connection = this.toolT.getDefaultConnection();
        this.producer = this.toolT.getDefaultProducer();
        this.consumer = this.toolT.getDefaultConsumer();
        this.topic = (Topic)this.destination;
        this.connection.start();
        this.queueTest = false;
    }

    public void setupGlobalVarsT2() throws Exception {
        this.cf = this.toolT2.getConnectionFactory();
        this.destination = this.toolT2.getDefaultDestination();
        this.session = this.toolT2.getDefaultSession();
        this.connection = this.toolT2.getDefaultConnection();
        this.producer = this.toolT2.getDefaultProducer();
        this.consumer = this.toolT2.getDefaultConsumer();
        this.topic = (Topic)this.destination;
        this.connection.start();
        this.queueTest = false;
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.vehicle = p.getProperty("vehicle");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.connections = new ArrayList(5);
            this.toolT = new JmsTool(14, this.user, this.password, lookupNormalTopicFactory, this.mode);
            this.toolQ = new JmsTool(13, this.user, this.password, this.mode);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Closing default Connection");
            this.toolQ.getDefaultConnection().close();
            this.toolT.getDefaultConnection().close();
            if (this.toolT2 != null) {
                this.toolT2.getDefaultConnection().close();
            }
            if (this.queueTest) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                this.toolQ.flushDestination();
            }
            this.toolQ.closeAllResources();
            this.toolT.closeAllResources();
            if (this.toolT2 != null) {
                this.toolT2.closeAllResources();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
    }

    private void cleanupSubscription(MessageConsumer consumer, Session session, String subName) {
        if (consumer != null) {
            try {
                TestUtil.logTrace((String)("Closing durable consumer: " + consumer));
                consumer.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                TestUtil.logTrace((String)("Unsubscribing \"" + subName + "\""));
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    private void cleanupSubscription(TopicSubscriber tSub, Session session, String subName) {
        if (tSub != null) {
            try {
                TestUtil.logTrace((String)("Closing durable subscriber: " + tSub));
                tSub.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                TestUtil.logTrace((String)("Unsubscribing \"" + subName + "\""));
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    public void sendRecvMsgsOfEachMsgTypeTopicTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.setupGlobalVarsT();
            TestUtil.logMsg((String)"Send Message");
            Message msg = this.session.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(msg);
            TestUtil.logMsg((String)"Receive Message");
            Message msgRecv = this.consumer.receive(this.timeout);
            if (msgRecv == null) {
                throw new EETest.Fault("Did not receive Message");
            }
            TestUtil.logMsg((String)"Check the values in Message");
            if (msgRecv.getBooleanProperty("booleanProperty")) {
                TestUtil.logMsg((String)"booleanproperty is correct");
            } else {
                TestUtil.logMsg((String)"booleanproperty is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send BytesMessage");
            BytesMessage bMsg = this.session.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            this.producer.send((Message)bMsg);
            TestUtil.logMsg((String)"Receive BytesMessage");
            BytesMessage bMsgRecv = (BytesMessage)this.consumer.receive(this.timeout);
            if (bMsgRecv == null) {
                throw new EETest.Fault("Did not receive BytesMessage");
            }
            TestUtil.logMsg((String)"Check the values in BytesMessage");
            if (bMsgRecv.readByte() == 1) {
                TestUtil.logMsg((String)"bytevalue is correct");
            } else {
                TestUtil.logMsg((String)"bytevalue is incorrect");
                pass = false;
            }
            if (bMsgRecv.readInt() == 22) {
                TestUtil.logMsg((String)"intvalue is correct");
            } else {
                TestUtil.logMsg((String)"intvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send MapMessage");
            MapMessage mMsg = this.session.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send((Message)mMsg);
            TestUtil.logMsg((String)"Receive MapMessage");
            MapMessage mMsgRecv = (MapMessage)this.consumer.receive(this.timeout);
            if (mMsgRecv == null) {
                throw new EETest.Fault("Did not receive MapMessage");
            }
            TestUtil.logMsg((String)"Check the values in MapMessage");
            Enumeration list = mMsgRecv.getMapNames();
            String name = null;
            while (list.hasMoreElements()) {
                name = (String)list.nextElement();
                if (name.equals("booleanvalue")) {
                    if (mMsgRecv.getBoolean(name)) {
                        TestUtil.logMsg((String)"booleanvalue is correct");
                        continue;
                    }
                    TestUtil.logErr((String)"booleanvalue is incorrect");
                    pass = false;
                    continue;
                }
                if (name.equals("intvalue")) {
                    if (mMsgRecv.getInt(name) == 10) {
                        TestUtil.logMsg((String)"intvalue is correct");
                        continue;
                    }
                    TestUtil.logErr((String)"intvalue is incorrect");
                    pass = false;
                    continue;
                }
                TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                pass = false;
            }
            TestUtil.logMsg((String)"Send ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage oMsg = this.session.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            this.producer.send((Message)oMsg);
            TestUtil.logMsg((String)"Receive ObjectMessage");
            ObjectMessage oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new EETest.Fault("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Check the value in ObjectMessage");
            StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                TestUtil.logMsg((String)"objectvalue is correct");
            } else {
                TestUtil.logErr((String)"objectvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send ObjectMessage passing object as param");
            sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage passing object as param");
            oMsg = this.session.createObjectMessage((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            this.producer.send((Message)oMsg);
            TestUtil.logMsg((String)"Receive ObjectMessage");
            oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new EETest.Fault("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Check the value in ObjectMessage");
            sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                TestUtil.logMsg((String)"objectvalue is correct");
            } else {
                TestUtil.logErr((String)"objectvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send StreamMessage");
            StreamMessage sMsg = this.session.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send((Message)sMsg);
            TestUtil.logMsg((String)"Receive StreamMessage");
            StreamMessage sMsgRecv = (StreamMessage)this.consumer.receive(this.timeout);
            if (sMsgRecv == null) {
                throw new EETest.Fault("Did not receive StreamMessage");
            }
            TestUtil.logMsg((String)"Check the values in StreamMessage");
            if (sMsgRecv.readBoolean()) {
                TestUtil.logMsg((String)"booleanvalue is correct");
            } else {
                TestUtil.logMsg((String)"booleanvalue is incorrect");
                pass = false;
            }
            if (sMsgRecv.readInt() == 22) {
                TestUtil.logMsg((String)"intvalue is correct");
            } else {
                TestUtil.logMsg((String)"intvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send TextMessage");
            TextMessage tMsg = this.session.createTextMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            tMsg.setText("Hello There!");
            this.producer.send((Message)tMsg);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Hello There!")) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)"TextMessage is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send TextMessage");
            tMsg = this.session.createTextMessage("Where are you!");
            TestUtil.logMsg((String)"Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            this.producer.send((Message)tMsg);
            TestUtil.logMsg((String)"Receive TextMessage");
            tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Where are you!")) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)"TextMessage is incorrect");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("sendRecvMsgsOfEachMsgTypeTopicTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("sendRecvMsgsOfEachMsgTypeTopicTest failed");
        }
    }

    public void createTemporayTopicTest() throws EETest.Fault {
        boolean pass = true;
        try {
            String message = "a text message";
            this.setupGlobalVarsT();
            TestUtil.logMsg((String)"Creating TemporaryTopic");
            TemporaryTopic tempTopic = this.session.createTemporaryTopic();
            TestUtil.logMsg((String)"Creating MessageConsumer for TemporaryTopic");
            MessageConsumer tConsumer = this.session.createConsumer((Destination)tempTopic);
            TestUtil.logMsg((String)"Creating MessageProducer for TemporaryTopic");
            MessageProducer tProducer = this.session.createProducer((Destination)tempTopic);
            TestUtil.logMsg((String)("Creating TextMessage with text [" + message + "]"));
            TextMessage tMsg = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createTemporayTopicTest");
            TestUtil.logMsg((String)"Send TextMessage to temporaty topic");
            tProducer.send((Message)tMsg);
            TestUtil.logMsg((String)"Receive TextMessage from temporaty topic");
            TextMessage tMsgRecv = (TextMessage)tConsumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (tMsgRecv.getText().equals(message)) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)"TextMessage is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Attempting to delete temporary topic with an open consumer should not be allowed");
            try {
                tempTopic.delete();
                pass = false;
                TestUtil.logErr((String)"TemporaryTopic.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                TestUtil.logMsg((String)"Received expected JMSException: ");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Received unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Now close the open consumer");
            try {
                tConsumer.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Attempting to delete temporary topic with no open consumer should be allowed");
            try {
                tempTopic.delete();
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createTemporayTopicTest");
        }
        if (!pass) {
            throw new EETest.Fault("createTemporayTopicTest failed");
        }
    }

    public void getTransactedTopicTest() throws EETest.Fault {
        boolean actTransacted;
        boolean pass = true;
        try {
            this.setupGlobalVarsT();
            this.session.close();
            this.session = this.connection.createSession(1);
            boolean expTransacted = false;
            TestUtil.logMsg((String)("Calling getTransacted and expect " + expTransacted + " to be returned"));
            actTransacted = this.session.getTransacted();
            if (actTransacted != expTransacted) {
                TestUtil.logErr((String)("getTransacted() returned " + actTransacted + ", expected " + expTransacted));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getTransactedTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                boolean expTransacted = true;
                TestUtil.logMsg((String)("Calling getTransacted and expect " + expTransacted + " to be returned"));
                actTransacted = this.session.getTransacted();
                if (actTransacted != expTransacted) {
                    TestUtil.logErr((String)("getTransacted() returned " + actTransacted + ", expected " + expTransacted));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getTransactedTopicTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("getTransactedTopicTest failed");
        }
    }

    public void getAcknowledgeModeTopicTest() throws EETest.Fault {
        int actAcknowledgeMode;
        boolean pass = true;
        try {
            this.setupGlobalVarsT();
            this.session.close();
            this.session = this.connection.createSession(1);
            int expAcknowledgeMode = 1;
            TestUtil.logMsg((String)("Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned"));
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                TestUtil.logErr((String)("getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.session = this.connection.createSession(3);
            int expAcknowledgeMode = 3;
            TestUtil.logMsg((String)("Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned"));
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                TestUtil.logErr((String)("getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                int expAcknowledgeMode = 0;
                TestUtil.logMsg((String)("Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned"));
                actAcknowledgeMode = this.session.getAcknowledgeMode();
                if (actAcknowledgeMode != expAcknowledgeMode) {
                    TestUtil.logErr((String)("getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getAcknowledgeModeTopicTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("getAcknowledgeModeTopicTest failed");
        }
    }

    public void createConsumerProducerTopicTest() throws EETest.Fault {
        boolean pass = true;
        MessageConsumer consumerSelect = null;
        try {
            TextMessage tempMsg = null;
            Object msgs = null;
            this.setupGlobalVarsT();
            this.consumer.close();
            TestUtil.logMsg((String)"Create selective consumer to consume messages in Topic with boolproperty (lastMessage=TRUE)");
            consumerSelect = this.session.createConsumer(this.destination, "lastMessage=TRUE");
            TestUtil.logMsg((String)"Create normal consumer to consume all messages in Topic");
            this.consumer = this.session.createConsumer(this.destination);
            TestUtil.logMsg((String)"Send 3 messsages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerProducerTopicTest" + i);
                tempMsg.setJMSType("");
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Consume messages with selective consumer which has boolproperty (lastMessage=TRUE)");
            if (consumerSelect != null) {
                tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            }
            if (tempMsg == null) {
                TestUtil.logErr((String)"MessageConsumer.receive() returned NULL");
                TestUtil.logErr((String)"Message 3 missing from Topic");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message 3]"));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Make sure selective consumer receives no more messages");
            if (consumerSelect != null) {
                tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            }
            if (tempMsg != null) {
                TestUtil.logErr((String)("MessageConsumer.receive() returned a message [" + tempMsg.getText() + "] (Expected NULL)"));
                TestUtil.logErr((String)"MessageConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"No more messages for selective consumer (Correct)");
            }
            try {
                if (consumerSelect != null) {
                    consumerSelect.close();
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            TestUtil.logMsg((String)"Consume all messages with normal consumer");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"MessageConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Topic"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Make sure normal consumer receives no more messages");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected no message"));
                TestUtil.logErr((String)"MessageConsumer should have returned 3 messages");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createConsumerProducerTopicTest");
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createConsumerProducerTopicTest failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createDurableSubscriberTopicTest1() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        TopicSubscriber tSub = null;
        try {
            TextMessage expTextMessage = null;
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            TestUtil.logMsg((String)"Create a Durable Subscription and a TopicSubscriber for it");
            tSub = this.session.createDurableSubscriber(this.topic, "createDurableSubscriberTopicTest1");
            TestUtil.logMsg((String)"Send message to Topic");
            expTextMessage = this.session.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableSubscriberTopicTest1");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"Message sent");
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)tSub.receive(this.timeout);
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e));
                e.printStackTrace();
                throw new EETest.Fault("createDurableSubscriberTopicTest1", e);
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest1");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest1");
        }
        catch (Exception expTextMessage) {}
        if (pass) return;
        throw new EETest.Fault("createDurableSubscriberTopicTest1 failed");
    }

    /*
     * Loose catch block
     */
    public void createDurableSubscriberTopicTest2() throws EETest.Fault {
        TextMessage tempMsg;
        TopicSubscriber tSub;
        boolean pass;
        block29: {
            block27: {
                pass = true;
                String message = "Where are you!";
                tSub = null;
                this.toolT.getDefaultConnection().close();
                this.toolT.closeAllResources();
                this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
                this.setupGlobalVarsT2();
                TestUtil.logMsg((String)"Create a Durable Subscription and a TopicSubscriber for it");
                tSub = this.session.createDurableSubscriber(this.topic, "createDurableSubscriberTopicTest2", "lastMessage = TRUE", false);
                TestUtil.logMsg((String)"Send 3 to Topic");
                for (int i = 1; i <= 3; ++i) {
                    tempMsg = this.session.createTextMessage("Message " + i);
                    tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableSubscriberTopicTest2" + i);
                    if (i == 3) {
                        tempMsg.setBooleanProperty("lastMessage", true);
                    } else {
                        tempMsg.setBooleanProperty("lastMessage", false);
                    }
                    this.producer.send((Message)tempMsg);
                    TestUtil.logMsg((String)("Message " + i + " sent"));
                }
                TestUtil.logMsg((String)"Receive TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage("Message 3");
                TextMessage actTextMessage = (TextMessage)tSub.receive(this.timeout);
                if (actTextMessage == null) {
                    throw new EETest.Fault("Did not receive TextMessage");
                }
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                    break block27;
                }
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            try {
                this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest2");
            }
            catch (Exception expTextMessage) {}
            break block29;
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught exception: " + e));
                    e.printStackTrace();
                    throw new EETest.Fault("createDurableSubscriberTopicTest2", e);
                }
                catch (Throwable throwable) {
                    try {
                        this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest2");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        try {
            TestUtil.logMsg((String)"Create a Durable Subscription and a TopicSubscriber for it");
            tSub = this.session.createDurableSubscriber(this.topic, "createDurableSubscriberTopicTest2", "lastMessage = TRUE", true);
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableSubscriberTopicTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)tSub.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"message were delivered when noLocal=true");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createDurableSubscriberTopicTest2", e);
        }
        finally {
            try {
                this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest2");
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createDurableSubscriberTopicTest2 failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createDurableConsumerTopicTest1() throws EETest.Fault {
        boolean pass = true;
        String message1 = "Where are you!";
        String message2 = "Who are you!";
        MessageConsumer tCon = null;
        try {
            TextMessage expTextMessage = null;
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            TestUtil.logMsg((String)"Create a Durable Subscription and a MessageConsumer for it");
            tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest1");
            TestUtil.logMsg((String)"Send TextMessage message1 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message1 sent");
            TestUtil.logMsg((String)"Receive TextMessage message1");
            TextMessage actTextMessage = (TextMessage)tCon.receive(this.timeout);
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage message1");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Close durable MessageConsumer");
            tCon.close();
            TestUtil.logMsg((String)"Send TextMessage message2 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message2 sent");
            TestUtil.logMsg((String)"Recreate a Durable Subscription and a MessageConsumer for it");
            tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest1");
            TestUtil.logMsg((String)"Receive TextMessage message2");
            actTextMessage = (TextMessage)tCon.receive(this.timeout);
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage message2");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e));
                e.printStackTrace();
                throw new EETest.Fault("createDurableConsumerTopicTest1", e);
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest1");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest1");
        }
        catch (Exception expTextMessage) {}
        if (pass) return;
        throw new EETest.Fault("createDurableConsumerTopicTest1 failed");
    }

    /*
     * Loose catch block
     */
    public void createDurableConsumerTopicTest2() throws EETest.Fault {
        TextMessage tempMsg;
        MessageConsumer tCon;
        boolean pass;
        block29: {
            block27: {
                pass = true;
                String message = "Where are you!";
                tCon = null;
                this.toolT.getDefaultConnection().close();
                this.toolT.closeAllResources();
                this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
                this.setupGlobalVarsT2();
                TestUtil.logMsg((String)"Create a Durable Subscription and a MessageConsumer with message selector, noLocal=false");
                tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest2", "lastMessage = TRUE", false);
                TestUtil.logMsg((String)"Send 3 to Topic");
                for (int i = 1; i <= 3; ++i) {
                    tempMsg = this.session.createTextMessage("Message " + i);
                    tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest2" + i);
                    if (i == 3) {
                        tempMsg.setBooleanProperty("lastMessage", true);
                    } else {
                        tempMsg.setBooleanProperty("lastMessage", false);
                    }
                    this.producer.send((Message)tempMsg);
                    TestUtil.logMsg((String)("Message " + i + " sent"));
                }
                TestUtil.logMsg((String)"Receive TextMessage");
                TestUtil.logMsg((String)"This is noLacal=false case so expect to get just last message");
                TextMessage expTextMessage = this.session.createTextMessage("Message 3");
                TextMessage actTextMessage = (TextMessage)tCon.receive(this.timeout);
                if (actTextMessage == null) {
                    throw new EETest.Fault("Did not receive TextMessage");
                }
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                    break block27;
                }
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            try {
                this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest2");
            }
            catch (Exception expTextMessage) {}
            break block29;
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught exception: " + e));
                    e.printStackTrace();
                    throw new EETest.Fault("createDurableConsumerTopicTest2", e);
                }
                catch (Throwable throwable) {
                    try {
                        this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest2");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        try {
            TestUtil.logMsg((String)"Create a Durable Subscription and a MessageConsumer with message selector, noLocal=true");
            tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest2", "lastMessage = TRUE", true);
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)tCon.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Message was delivered when noLocal=true");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createDurableConsumerTopicTest2", e);
        }
        finally {
            try {
                this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest2");
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createDurableConsumerTopicTest2 failed");
        }
    }

    public void createSharedConsumerTopicTest1() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTopicTest1";
        TextMessage expTextMessage = null;
        try {
            this.setupGlobalVarsT();
            TestUtil.logMsg((String)"Create a shared non-durable Subscription and a MessageConsumer for it");
            this.consumer.close();
            this.consumer = this.session.createSharedConsumer(this.topic, sharedSubscriptionName);
            TestUtil.logMsg((String)"Create a second MessageConsumer for the Subscription");
            this.consumer2 = this.session.createSharedConsumer(this.topic, sharedSubscriptionName);
            TestUtil.logMsg((String)"Send message to Topic");
            expTextMessage = this.session.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"Message sent");
            TestUtil.logMsg((String)"Receive TextMessage from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
            TestUtil.logMsg((String)"Send another message to Topic");
            expTextMessage = this.session.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"Message sent");
            TestUtil.logMsg((String)"Receive TextMessage from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedConsumerTopicTest1", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Ignoring exception closing consumers: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedConsumerTopicTest1 failed");
        }
    }

    public void createSharedConsumerTopicTest2() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTopicTest2";
        try {
            this.setupGlobalVarsT();
            TestUtil.logMsg((String)"Create a shared non-durable Subscription and a MessageConsumer for it");
            this.consumer.close();
            this.consumer = this.session.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Create a second MessageConsumer for the Subscription");
            this.consumer2 = this.session.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.session.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage from consumer2");
            expTextMessage = this.session.createTextMessage("Message 3");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedConsumerTopicTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Ignoring exception closing consumers: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedConsumerTopicTest2 failed");
        }
    }

    public void createSharedDurableConsumerTopicTest1() throws EETest.Fault {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTopicTest1";
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            TextMessage expTextMessage = null;
            TestUtil.logMsg((String)"Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Create 2nd JMSConsumer for it");
            this.consumer2 = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Send TextMessage message1 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message1 sent");
            TestUtil.logMsg((String)"Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Close 1st shared durable JMSConsumer");
            this.consumer.close();
            TestUtil.logMsg((String)"Send TextMessage message2 to Topic");
            expTextMessage = this.session.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message2 sent");
            TestUtil.logMsg((String)"Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Now there should be no more messages to receive from topic");
            TestUtil.logMsg((String)"Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Try and receive a message from comsumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Consumer1 didn't receive a message (PASS)");
            }
            TestUtil.logMsg((String)"Try and receive a message from comsumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer2 received a message (FAIL)");
                pass = false;
                throw new EETest.Fault("Consumer2 received a message (FAIL)");
            }
            TestUtil.logMsg((String)"Consumer2 didn't receive a message (PASS)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedDurableConsumerTopicTest1", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.session, durableSubscriptionName);
                this.toolT2.getDefaultConnection().close();
                this.toolT2.closeAllResources();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedDurableConsumerTopicTest1 failed");
        }
    }

    public void createSharedDurableConsumerTopicTest2() throws EETest.Fault {
        boolean pass = true;
        String durableSubscriptionName = "createSharedDurableConsumerTopicTest2";
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            TestUtil.logMsg((String)"Create shared Durable Subscription and 1st JMSConsumer with message selector");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Create 2nd JMSConsumer with message selector");
            this.consumer2 = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.session.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedDurableConsumerTopicTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.session, durableSubscriptionName);
                this.toolT2.getDefaultConnection().close();
                this.toolT2.closeAllResources();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedDurableConsumerTopicTest2 failed");
        }
    }

    public void createSharedDurableConsumerTopicTest3() throws EETest.Fault {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTopicTest3";
        try {
            this.setupGlobalVarsT();
            TextMessage expTextMessage = null;
            TestUtil.logMsg((String)"Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Create 2nd JMSConsumer for it");
            this.consumer2 = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Send TextMessage message1 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest3");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message1 sent");
            TestUtil.logMsg((String)"Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Close 1st shared durable JMSConsumer");
            this.consumer.close();
            TestUtil.logMsg((String)"Send TextMessage message2 to Topic");
            expTextMessage = this.session.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest3");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message2 sent");
            TestUtil.logMsg((String)"Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Now there should be no more messages to receive from topic");
            TestUtil.logMsg((String)"Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Try and receive a message from comsumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Consumer1 didn't receive a message (PASS)");
            }
            TestUtil.logMsg((String)"Try and receive a message from comsumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer2 received a message (FAIL)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Consumer2 didn't receive a message (PASS)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedDurableConsumerTopicTest3", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.session, durableSubscriptionName);
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createSharedDurableConsumerTopicTest3 failed");
        }
    }

    public void invalidDestinationExceptionTests() throws EETest.Fault {
        boolean pass = true;
        Object invalidDestination = null;
        Topic invalidTopic = null;
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            TestUtil.logMsg((String)"Testing Session.createDurableSubscriber(Topic, String) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String) -> expect InvalidDestinationException");
                this.session.createDurableSubscriber(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createDurableSubscriber(Topic, String, String, boolean) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String, String, boolean) -> expect InvalidDestinationException");
                this.session.createDurableSubscriber(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createDurableConsumer(Topic, String) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String) -> expect InvalidDestinationException");
                this.session.createDurableConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createDurableConsumer(Topic, String, String, boolean) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidDestinationException");
                this.session.createDurableConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createSharedConsumer(Topic, String) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createSharedConsumer(Topic, String) for InvalidDestinationException");
                this.session.createSharedConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createSharedConsumer(Topic, String, String) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createSharedConsumer(Topic, String, String) for InvalidDestinationException");
                this.session.createSharedConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createSharedDurableConsumer(Topic, String) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createSharedDurableConsumer(Topic, String) -> expect InvalidDestinationException");
                this.session.createSharedDurableConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createSharedDurableConsumer(Topic, String, String) for InvalidDestinationException");
            try {
                TestUtil.logMsg((String)"Calling Session.createSharedDurableConsumer(Topic, String, String) -> expect InvalidDestinationException");
                this.session.createSharedDurableConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("invalidDestinationExceptionTests", e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidDestinationExceptionTests failed");
        }
    }

    public void invalidSelectorExceptionTopicTests() throws EETest.Fault {
        boolean pass = true;
        String invalidMessageSelector = "=TEST 'test'";
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            TestUtil.logMsg((String)"Testing Session.createDurableConsumer(Topic, String, String, boolean) for InvalidSelectorException");
            try {
                TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidSelectorException");
                this.session.createDurableConsumer(this.topic, "InvalidSelectorException", invalidMessageSelector, false);
            }
            catch (InvalidSelectorException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createSharedConsumer(Topic, String, String) for InvalidSelectorException");
            try {
                TestUtil.logMsg((String)"Calling Session.createSharedConsumer(Topic, String, String) for InvalidSelectorException");
                this.session.createSharedConsumer(this.topic, "InvalidSelectorException", invalidMessageSelector);
            }
            catch (InvalidSelectorException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing Session.createSharedDurableConsumer(Topic, String, String) for InvalidSelectorException");
            try {
                TestUtil.logMsg((String)"Calling Session.createSharedDurableConsumer(Topic, String, String) -> expect InvalidSelectorException");
                this.session.createSharedDurableConsumer(this.topic, "InvalidSelectorException", invalidMessageSelector);
            }
            catch (InvalidSelectorException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorException, received " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("invalidSelectorExceptionTopicTests", e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidSelectorExceptionTopicTests failed");
        }
    }

    public void illegalStateExceptionTests() throws EETest.Fault {
        JmsTool toolq = null;
        String lookupNormalTopicFactory = lookupNormalTopicFactory;
        boolean pass = true;
        MessageConsumer consumer = null;
        TopicSubscriber subscriber = null;
        try {
            toolq = new JmsTool(0, this.user, this.password, this.mode);
            Destination destination = this.toolT.getDefaultDestination();
            Topic topic = (Topic)destination;
            try {
                TestUtil.logMsg((String)"Calling QueueSession.createDurableConsumer(Topic, String)");
                toolq.getDefaultQueueSession().createDurableConsumer(topic, "mySub1");
                pass = false;
                TestUtil.logErr((String)"QueueSession.createDurableConsumer(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createDurableConsumer(Topic, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Calling QueueSession.createDurableConsumer(Topic, String, String, boolean)");
                toolq.getDefaultQueueSession().createDurableConsumer(topic, "mySub1", "TEST = 'test'", false);
                pass = false;
                TestUtil.logErr((String)"QueueSession.createDurableConsumer(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createDurableConsumer(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Calling QueueSession.createSharedConsumer(Topic, String)");
                toolq.getDefaultQueueSession().createSharedConsumer(topic, "mySub1");
                pass = false;
                TestUtil.logErr((String)"QueueSession.createSharedConsumer(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createSharedConsumer(Topic, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Calling QueueSession.createSharedConsumer(Topic, String, String)");
                toolq.getDefaultQueueSession().createSharedConsumer(topic, "mySub1", "TEST = 'test'");
                pass = false;
                TestUtil.logErr((String)"QueueSession.createSharedConsumer(Topic, String, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createSharedConsumer(Topic, String, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Calling QueueSession.createSharedDurableConsumer(Topic, String)");
                toolq.getDefaultQueueSession().createSharedDurableConsumer(topic, "mySub1");
                pass = false;
                TestUtil.logErr((String)"QueueSession.createSharedDurableConsumer(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createSharedDurableConsumer(Topic, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Calling QueueSession.createSharedDurableConsumer(Topic, String, String)");
                toolq.getDefaultQueueSession().createSharedDurableConsumer(topic, "mySub1", "TEST = 'test'");
                pass = false;
                TestUtil.logErr((String)"QueueSession.createSharedDurableConsumer(Topic, String, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createSharedDurableConsumer(Topic, String, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Create a Durable Subscriber with clientid unset (expect IllegalStateException");
                TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String)");
                subscriber = this.toolT.getDefaultSession().createDurableSubscriber(topic, "mySub1");
                pass = false;
                TestUtil.logErr((String)"Session.createDurableSubscriber(Topic, String) didn't throw expected IllegalStateException.");
                try {
                    subscriber.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {}
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from Session.createDurableSubscriber(Topic, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Create a Durable Subscriber with noLocal=true and clientid unset (expect IllegalStateException");
                TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
                subscriber = this.toolT.getDefaultSession().createDurableSubscriber(topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                TestUtil.logErr((String)"Session.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
                try {
                    subscriber.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {}
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from Session.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Create a Durable Consumer with clientid unset (expect IllegalStateException");
                TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String)");
                consumer = this.toolT.getDefaultSession().createDurableConsumer(topic, "mySub1");
                pass = false;
                TestUtil.logErr((String)"Session.createDurableConsumer(Topic, String) didn't throw expected IllegalStateException.");
                try {
                    consumer.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {}
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from Session.createDurableConsumer(Topic, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Create a Durable Consumer with noLocal=true and clientid unset (expect IllegalStateException");
                TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String, String, boolean)");
                consumer = this.toolT.getDefaultSession().createDurableConsumer(topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                TestUtil.logErr((String)"Session.createDurableConsumer(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
                try {
                    consumer.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {
                }
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from Session.createDurableConsumer(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("illegalStateExceptionTests Failed");
        }
        finally {
            try {
                toolq.getDefaultQueueConnection().close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateExceptionTests Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jMSExceptionTests() throws EETest.Fault {
        boolean pass = true;
        JmsTool toolt = null;
        Topic mytopic = null;
        try {
            this.setupGlobalVarsT();
            mytopic = this.toolT.createNewTopic("MY_TOPIC2");
            toolt = new JmsTool(1, this.user, this.password, lookupNormalTopicFactory, this.mode);
            try {
                TestUtil.logMsg((String)"Create a Durable TopicSubscriber with noLocal=true and clientid unset (expect JMSException");
                TestUtil.logMsg((String)"Calling TopicSession.createDurableSubscriber(Topic, String, String, boolean)");
                this.subscriber = toolt.getDefaultTopicSession().createDurableSubscriber(this.topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                TestUtil.logErr((String)"TopicSession.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected JMSException.");
            }
            catch (JMSException ex) {
                TestUtil.logMsg((String)"Got expected JMSException from TopicSession.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            finally {
                try {
                    if (this.subscriber != null) {
                        this.subscriber.close();
                    }
                    toolt.getDefaultTopicConnection().close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
            }
            try {
                TestUtil.logMsg((String)"Create a Durable Consumer with noLocal=true and clientid unset (expect JMSException");
                TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String, String, boolean)");
                this.consumer = null;
                this.consumer = this.session.createDurableConsumer(this.topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                TestUtil.logErr((String)"Session.createDurableConsumer(Topic, String, String, boolean) didn't throw expected JMSException.");
            }
            catch (JMSException ex) {
                TestUtil.logMsg((String)"Got expected JMSException from Session.createDurableConsumer(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.consumer.close();
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
            }
            try {
                TestUtil.logMsg((String)"Create a Durable TopicSubscriber with noLocal=true and clientid unset (expect JMSException");
                TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
                this.subscriber = null;
                this.subscriber = this.session.createDurableSubscriber(this.topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                TestUtil.logErr((String)"Session.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected JMSException.");
            }
            catch (JMSException ex) {
                TestUtil.logMsg((String)"Got expected JMSException from Session.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            finally {
                try {
                    if (this.subscriber != null) {
                        this.subscriber.close();
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("jMSExceptionTests Failed");
        }
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("jMSExceptionTests Failed");
        }
        try {
            TestUtil.logMsg((String)"Create durable subscriber");
            TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String)");
            this.subscriber2 = null;
            this.subscriber = null;
            this.subscriber = this.session.createDurableSubscriber(this.topic, "dummySubSCJMSException");
            TestUtil.logMsg((String)"Create second durable subscriber with same name but different topic");
            TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String)");
            this.subscriber2 = this.session.createDurableSubscriber(mytopic, "dummySubSCJMSException");
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createDurableSubscriber(Topic, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.subscriber != null) {
                    this.subscriber.close();
                }
                if (this.subscriber2 != null) {
                    this.subscriber2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        try {
            TestUtil.logMsg((String)"Create durable subscriber");
            TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
            this.subscriber2 = null;
            this.subscriber = null;
            this.subscriber = this.session.createDurableSubscriber(this.topic, "dummySubSCJMSException", "TEST = 'test'", false);
            TestUtil.logMsg((String)"Create second durable subscriber with same name but different topic");
            TestUtil.logMsg((String)"Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
            this.subscriber2 = this.session.createDurableSubscriber(mytopic, "dummySubSCJMSException", "TEST = 'test'", false);
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createDurableSubscriber(Topic, String, String, boolean)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.subscriber != null) {
                    this.subscriber.close();
                }
                if (this.subscriber2 != null) {
                    this.subscriber2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        try {
            TestUtil.logMsg((String)"Create shared consumer");
            TestUtil.logMsg((String)"Calling Session.createSharedConsumer(Topic, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedConsumer(this.topic, "dummySubSCJMSException");
            TestUtil.logMsg((String)"Create second shared consumer with same name but different topic");
            TestUtil.logMsg((String)"Calling Session.createSharedConsumer(Topic, String)");
            this.consumer2 = this.session.createSharedConsumer(mytopic, "dummySubSCJMSException");
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createSharedConsumer(Topic, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        try {
            TestUtil.logMsg((String)"Create shared consumer");
            TestUtil.logMsg((String)"Calling Session.createSharedConsumer(Topic, String, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedConsumer(this.topic, "dummySubSCJMSException", "TEST = 'test'");
            TestUtil.logMsg((String)"Create second shared consumer with same name but different topic");
            TestUtil.logMsg((String)"Calling Session.createSharedConsumer(Topic, String, String)");
            this.consumer2 = this.session.createSharedConsumer(mytopic, "dummySubSCJMSException", "TEST = 'test'");
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createSharedConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        try {
            TestUtil.logMsg((String)"Create shared durable subscription");
            TestUtil.logMsg((String)"Calling Session.createSharedDurableConsumer(Topic, String, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedDurableConsumer(this.topic, "dummySubSJMSException", "TEST = 'test'");
            TestUtil.logMsg((String)"Create second shared durable subscription with same name but different other args");
            TestUtil.logMsg((String)"Calling Session.createSharedDurableConsumer(Topic, String, String)");
            this.consumer2 = this.session.createSharedDurableConsumer(mytopic, "dummySubSJMSException", "TEST = 'test2'");
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createSharedDurableConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubSJMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        try {
            TestUtil.logMsg((String)"Create durable subscription");
            TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createDurableConsumer(this.topic, "dummySubDJMSException");
            TestUtil.logMsg((String)"Create second durable subscription with same name but different topic");
            TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String)");
            this.consumer2 = this.session.createDurableConsumer(mytopic, "dummySubDJMSException");
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubDJMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        try {
            TestUtil.logMsg((String)"Create shared durable subscription");
            TestUtil.logMsg((String)"Calling Session.createSharedDurableConsumer(Topic, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedDurableConsumer(this.topic, "dummySubSDJMSException");
            TestUtil.logMsg((String)"Create second shared durable subscription with same name but different topic");
            TestUtil.logMsg((String)"Calling Session.createSharedDurableConsumer(Topic, String)");
            this.consumer2 = this.session.createSharedDurableConsumer(mytopic, "dummySubSDJMSException");
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createSharedDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubSDJMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        try {
            TestUtil.logMsg((String)"Create durable subscription");
            TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createDurableConsumer(this.topic, "dummySubDJMSException", "TEST = 'test'", false);
            TestUtil.logMsg((String)"Create second durable subscription with same name but different other args");
            TestUtil.logMsg((String)"Calling Session.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer2 = this.session.createDurableConsumer(mytopic, "dummySubDJMSException", "TEST = 'test2'", false);
            TestUtil.logMsg((String)"Verify that JMSException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            TestUtil.logMsg((String)"Got expected JMSException from Session.createDurableConsumer(Topic, String, String, boolean)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubDJMSException");
                this.toolT.getDefaultConnection().close();
                this.toolT.closeAllResources();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("jMSExceptionTests Failed");
        }
    }

    public void sendAndRecvMsgsOfEachMsgTypeQueueTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.setupGlobalVarsQ();
            TestUtil.logMsg((String)"Send Message");
            Message msg = this.session.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(msg);
            TestUtil.logMsg((String)"Receive Message");
            Message msgRecv = this.consumer.receive(this.timeout);
            if (msgRecv == null) {
                throw new EETest.Fault("Did not receive Message");
            }
            TestUtil.logMsg((String)"Check the values in Message");
            if (msgRecv.getBooleanProperty("booleanProperty")) {
                TestUtil.logMsg((String)"booleanproperty is correct");
            } else {
                TestUtil.logMsg((String)"booleanproperty is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send BytesMessage");
            BytesMessage bMsg = this.session.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            this.producer.send((Message)bMsg);
            TestUtil.logMsg((String)"Receive BytesMessage");
            BytesMessage bMsgRecv = (BytesMessage)this.consumer.receive(this.timeout);
            if (bMsgRecv == null) {
                throw new EETest.Fault("Did not receive BytesMessage");
            }
            TestUtil.logMsg((String)"Check the values in BytesMessage");
            if (bMsgRecv.readByte() == 1) {
                TestUtil.logMsg((String)"bytevalue is correct");
            } else {
                TestUtil.logMsg((String)"bytevalue is incorrect");
                pass = false;
            }
            if (bMsgRecv.readInt() == 22) {
                TestUtil.logMsg((String)"intvalue is correct");
            } else {
                TestUtil.logMsg((String)"intvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send MapMessage");
            MapMessage mMsg = this.session.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send((Message)mMsg);
            TestUtil.logMsg((String)"Receive MapMessage");
            MapMessage mMsgRecv = (MapMessage)this.consumer.receive(this.timeout);
            if (mMsgRecv == null) {
                throw new EETest.Fault("Did not receive MapMessage");
            }
            TestUtil.logMsg((String)"Check the values in MapMessage");
            Enumeration list = mMsgRecv.getMapNames();
            String name = null;
            while (list.hasMoreElements()) {
                name = (String)list.nextElement();
                if (name.equals("booleanvalue")) {
                    if (mMsgRecv.getBoolean(name)) {
                        TestUtil.logMsg((String)"booleanvalue is correct");
                        continue;
                    }
                    TestUtil.logErr((String)"booleanvalue is incorrect");
                    pass = false;
                    continue;
                }
                if (name.equals("intvalue")) {
                    if (mMsgRecv.getInt(name) == 10) {
                        TestUtil.logMsg((String)"intvalue is correct");
                        continue;
                    }
                    TestUtil.logErr((String)"intvalue is incorrect");
                    pass = false;
                    continue;
                }
                TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                pass = false;
            }
            TestUtil.logMsg((String)"Send ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage oMsg = this.session.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            this.producer.send((Message)oMsg);
            TestUtil.logMsg((String)"Receive ObjectMessage");
            ObjectMessage oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new EETest.Fault("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Check the value in ObjectMessage");
            StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                TestUtil.logMsg((String)"objectvalue is correct");
            } else {
                TestUtil.logErr((String)"objectvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send ObjectMessage passing object as param");
            sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage passing object as param");
            oMsg = this.session.createObjectMessage((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            this.producer.send((Message)oMsg);
            TestUtil.logMsg((String)"Receive ObjectMessage");
            oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new EETest.Fault("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Check the value in ObjectMessage");
            sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                TestUtil.logMsg((String)"objectvalue is correct");
            } else {
                TestUtil.logErr((String)"objectvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send StreamMessage");
            StreamMessage sMsg = this.session.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send((Message)sMsg);
            TestUtil.logMsg((String)"Receive StreamMessage");
            StreamMessage sMsgRecv = (StreamMessage)this.consumer.receive(this.timeout);
            if (sMsgRecv == null) {
                throw new EETest.Fault("Did not receive StreamMessage");
            }
            TestUtil.logMsg((String)"Check the values in StreamMessage");
            if (sMsgRecv.readBoolean()) {
                TestUtil.logMsg((String)"booleanvalue is correct");
            } else {
                TestUtil.logMsg((String)"booleanvalue is incorrect");
                pass = false;
            }
            if (sMsgRecv.readInt() == 22) {
                TestUtil.logMsg((String)"intvalue is correct");
            } else {
                TestUtil.logMsg((String)"intvalue is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send TextMessage");
            TextMessage tMsg = this.session.createTextMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            tMsg.setText("Hello There!");
            this.producer.send((Message)tMsg);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Hello There!")) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)"TextMessage is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Send TextMessage");
            tMsg = this.session.createTextMessage("Where are you!");
            TestUtil.logMsg((String)"Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            this.producer.send((Message)tMsg);
            TestUtil.logMsg((String)"Receive TextMessage");
            tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Where are you!")) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)"TextMessage is incorrect");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("sendAndRecvMsgsOfEachMsgTypeQueueTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("sendAndRecvMsgsOfEachMsgTypeQueueTest failed");
        }
    }

    public void createTemporayQueueTest() throws EETest.Fault {
        boolean pass = true;
        MessageConsumer tConsumer = null;
        try {
            String message = "a text message";
            this.setupGlobalVarsQ();
            TestUtil.logMsg((String)"Creating TemporaryQueue");
            TemporaryQueue tempQueue = this.session.createTemporaryQueue();
            TestUtil.logMsg((String)"Creating MessageConsumer");
            tConsumer = this.session.createConsumer((Destination)tempQueue);
            TestUtil.logMsg((String)"Creating MessageProducer");
            MessageProducer tProducer = this.session.createProducer((Destination)tempQueue);
            TestUtil.logMsg((String)("Creating TextMessage with text [" + message + "]"));
            TextMessage tMsg = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createTemporayQueueTest");
            TestUtil.logMsg((String)"Send TextMessage to temporaty queue");
            tProducer.send((Message)tMsg);
            TestUtil.logMsg((String)"Receive TextMessage from temporaty queue");
            TextMessage tMsgRecv = null;
            if (tConsumer != null) {
                tMsgRecv = (TextMessage)tConsumer.receive(this.timeout);
            }
            if (tMsgRecv == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (tMsgRecv.getText().equals(message)) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)"TextMessage is incorrect");
                pass = false;
            }
            TestUtil.logMsg((String)"Attempting to delete temporary queue with an open consumer should not be allowed");
            try {
                tempQueue.delete();
                pass = false;
                TestUtil.logErr((String)"TemporaryQueue.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                TestUtil.logMsg((String)"Received expected JMSException: ");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Received unexpected JMSException: " + e));
                pass = false;
            }
            try {
                if (tConsumer != null) {
                    tConsumer.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            TestUtil.logMsg((String)"Attempting to delete temporary queue with no open consumer should be allowed");
            try {
                tempQueue.delete();
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createTemporayQueueTest");
        }
        if (!pass) {
            throw new EETest.Fault("createTemporayQueueTest failed");
        }
    }

    public void createQueueBrowserTest() throws EETest.Fault {
        boolean pass = true;
        QueueBrowser qBrowser = null;
        try {
            TextMessage tempMsg = null;
            Enumeration msgs = null;
            this.setupGlobalVarsQ();
            this.consumer.close();
            TestUtil.logMsg((String)"Send 3 to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createQueueBrowserTest" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Create QueueBrowser to peek at last message in Queue using message selector");
            qBrowser = this.session.createBrowser(this.queue, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Check that browser has just the last message");
            int msgCount = 0;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                if (!tempMsg.getText().equals("Message 3")) {
                    TestUtil.logErr((String)("Found [" + tempMsg.getText() + "] in browser expected [Message 3]"));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Found correct [Message 3] in browser");
                }
                ++msgCount;
            }
            if (msgCount != 1) {
                TestUtil.logErr((String)("Found " + msgCount + " messages in browser expected 1"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Found 1 message in browser (correct)");
            }
            qBrowser.close();
            TestUtil.logMsg((String)"Create QueueBrowser to browse all messages in the Queue");
            qBrowser = this.session.createBrowser(this.queue);
            TestUtil.logMsg((String)"Check that browser contains all 3 messages");
            msgCount = 0;
            int msgIndex = 1;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                if (!tempMsg.getText().equals("Message " + msgIndex)) {
                    TestUtil.logErr((String)("Found [" + tempMsg.getText() + "] in browser expected [Message " + msgIndex + "]"));
                    pass = false;
                }
                ++msgCount;
                ++msgIndex;
            }
            if (msgCount != 3) {
                TestUtil.logErr((String)("Found " + msgCount + " messages in browser expected " + 3));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Found 3 messages in browser (correct)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createQueueBrowserTest");
        }
        finally {
            try {
                if (qBrowser != null) {
                    qBrowser.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createQueueBrowserTest failed");
        }
    }

    public void getTransactedQueueTest() throws EETest.Fault {
        boolean actTransacted;
        boolean pass = true;
        try {
            this.setupGlobalVarsQ();
            this.session.close();
            this.session = this.connection.createSession(1);
            boolean expTransacted = false;
            TestUtil.logMsg((String)("Calling getTransacted and expect " + expTransacted + " to be returned"));
            actTransacted = this.session.getTransacted();
            if (actTransacted != expTransacted) {
                TestUtil.logErr((String)("getTransacted() returned " + actTransacted + ", expected " + expTransacted));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getTransactedQueueTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                boolean expTransacted = true;
                TestUtil.logMsg((String)("Calling getTransacted and expect " + expTransacted + " to be returned"));
                actTransacted = this.session.getTransacted();
                if (actTransacted != expTransacted) {
                    TestUtil.logErr((String)("getTransacted() returned " + actTransacted + ", expected " + expTransacted));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getTransactedQueueTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("getTransactedQueueTest failed");
        }
    }

    public void getAcknowledgeModeQueueTest() throws EETest.Fault {
        int actAcknowledgeMode;
        boolean pass = true;
        try {
            this.setupGlobalVarsQ();
            this.session.close();
            this.session = this.connection.createSession(1);
            int expAcknowledgeMode = 1;
            TestUtil.logMsg((String)("Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned"));
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                TestUtil.logErr((String)("getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.session = this.connection.createSession(3);
            int expAcknowledgeMode = 3;
            TestUtil.logMsg((String)("Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned"));
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                TestUtil.logErr((String)("getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                int expAcknowledgeMode = 0;
                TestUtil.logMsg((String)("Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned"));
                actAcknowledgeMode = this.session.getAcknowledgeMode();
                if (actAcknowledgeMode != expAcknowledgeMode) {
                    TestUtil.logErr((String)("getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getAcknowledgeModeTopicTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("getAcknowledgeModeQueueTest failed");
        }
    }

    public void createConsumerProducerQueueTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TextMessage tempMsg = null;
            Object msgs = null;
            this.setupGlobalVarsQ();
            this.consumer.close();
            TestUtil.logMsg((String)"Send 3 messages to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerProducerQueueTest" + i);
                tempMsg.setJMSType("");
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Create selective consumer to consume messages in Queue with boolproperty (lastMessage=TRUE)");
            this.consumer = this.session.createConsumer(this.destination, "lastMessage=TRUE");
            TestUtil.logMsg((String)"Consume messages with selective consumer which has boolproperty (lastMessage=TRUE)");
            if (this.consumer != null) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            }
            if (tempMsg == null) {
                TestUtil.logErr((String)"MessageConsumer.receive() returned NULL");
                TestUtil.logErr((String)"Message 3 missing from Queue");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message 3]"));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Make sure selective consumer receives no more messages");
            if (this.consumer != null) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            }
            if (tempMsg != null) {
                TestUtil.logErr((String)"MessageConsumer.receive() returned NULL");
                TestUtil.logErr((String)"MessageConsumer with selector should have returned just 1 message");
                pass = false;
            }
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            TestUtil.logMsg((String)"Consume rest of messages with normal consumer");
            this.consumer = this.session.createConsumer(this.destination);
            for (int msgCount = 1; msgCount < 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"MessageConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Queue"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Make sure normal consumer receives no more messages");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)"MessageConsumer should have returned 2 message");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createConsumerProducerQueueTest");
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createConsumerProducerQueueTest failed");
        }
    }
}

