/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServiceLifecycle;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServiceLifecycle.Hello;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServiceLifecycle.";
    private final String NAMESPACEURI = "http://helloservice.org/wsdl";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "helloservice.endpoint.1";
    private static final String WSDLLOC_URL = "helloservice.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    Hello port = null;
    Stub stub = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubJaxrpc() throws Exception {
        TestUtil.logMsg((String)"Get stub from service implementation class using JAXRPC porting instance");
        this.port = (Hello)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_server.ServiceLifecycle.HelloService", "getHelloPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"Obtained InitialContext");
        TestUtil.logMsg((String)"Lookup java:comp/env/service/servicelifecycle");
        Service svc = (Service)ctx.lookup("java:comp/env/service/servicelifecycle");
        TestUtil.logMsg((String)"Obtained service");
        this.port = (Hello)svc.getPort(Hello.class);
        TestUtil.logMsg((String)"Obtained port");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://helloservice.org/wsdl", "HelloService");
        this.PORT_QNAME = new QName("http://helloservice.org/wsdl", "HelloPort");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubJaxrpc();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            } else {
                this.getStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void initTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"initTest: test if ServiceLifecycle.init() called");
            TestUtil.logMsg((String)"Invoking RPC method wasInitCalled() and expect true ...");
            boolean yes = this.port.wasInitCalled();
            if (!yes) {
                TestUtil.logErr((String)"ServiceLifecycle.init() was not called");
                pass = false;
            } else {
                TestUtil.logMsg((String)"ServiceLifecycle.init() was called");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            throw new EETest.Fault("initTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("initTest failed");
        }
    }

    public void destroyTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"destroyTest: test if ServiceLifecycle.destroy() called");
            TestUtil.logMsg((String)"Invoking RPC method wasDestroyCalled() and expect true ...");
            boolean yes = this.port.wasDestroyCalled();
            if (!yes) {
                TestUtil.logErr((String)"ServiceLifecycle.destroy() was not called");
                pass = false;
            } else {
                TestUtil.logMsg((String)"ServiceLifecycle.destroy() was called");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            throw new EETest.Fault("destroyTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("destroyTest failed");
        }
    }
}

