/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Stub;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Stub.Hello;
import com.sun.ts.tests.jaxrpc.common.Constants;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Stub.";
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";
    private static final String BADURL = "/foobar";
    private static final String NAMESPACE_URI = "http://helloservice.org/wsdl";
    private static final String SERVICE_NAME = "HelloService";
    private static final String PORT_NAME = "HelloPort";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private static final Class PORT_CLASS = Hello.class;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private String username = null;
    private String password = null;
    private static final String ENDPOINT_URL = "helloservice.endpoint.1";
    private static final String WSDLLOC_URL = "helloservice.wsdlloc.1";
    private static final String SERVLET_URL = "helloservice.servlet.1";
    private String url = null;
    private URL wsdlurl = null;
    private String testservleturl = null;
    Hello port = null;
    Stub stub = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(SERVLET_URL);
        this.testservleturl = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
        TestUtil.logMsg((String)("Test Servlet URL:    " + this.testservleturl));
    }

    private void getTestURLfromStub() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(SERVLET_URL);
        this.testservleturl = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("TestServletURL: " + this.testservleturl));
    }

    private void getStubJaxrpc() throws Exception {
        TestUtil.logMsg((String)"Get stub from service implementation class using JAXRPC porting instance");
        this.port = (Hello)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Stub.HelloService", "getHelloPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"Obtained InitialContext");
        TestUtil.logMsg((String)"Lookup java:comp/env/service/stub");
        Service svc = (Service)ctx.lookup("java:comp/env/service/stub");
        TestUtil.logMsg((String)"Obtained service");
        this.port = (Hello)svc.getPort(Hello.class);
        TestUtil.logMsg((String)"Obtained port");
        TestUtil.logMsg((String)"Cast port to base Stub class");
        this.stub = (Stub)this.port;
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName(NAMESPACE_URI, SERVICE_NAME);
        this.PORT_QNAME = new QName(NAMESPACE_URI, PORT_NAME);
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.username = p.getProperty(USERNAME);
            this.password = p.getProperty(PASSWORD);
            TestUtil.logMsg((String)"Creating stub instance ...");
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubJaxrpc();
            } else {
                this.getStub();
                this.getTestURLfromStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void getPropertyNamesTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"getPropertyNamesTest1");
        boolean pass = true;
        Iterator iterator = null;
        try {
            TestUtil.logMsg((String)"Get of target endpoint ...");
            try {
                iterator = this.stub._getPropertyNames();
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
                return;
            }
            if (!iterator.hasNext()) {
                TestUtil.logMsg((String)"Stub has no configurable properties ...");
            } else {
                TestUtil.logMsg((String)"Stub has the following configurable properties ...");
                int i = 1;
                while (iterator.hasNext()) {
                    TestUtil.logMsg((String)("Property" + i++ + " = " + iterator.next()));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getPropertyNamesTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getPropertyNamesTest1 failed");
        }
    }

    public void setPropertyTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"setPropertyTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)("Setting endpoint address to " + this.url + " ..."));
            this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            TestUtil.logMsg((String)"Verify correct setting of endpoint address ...");
            String rec = (String)this.stub._getProperty("javax.xml.rpc.service.endpoint.address");
            if (!this.url.equals(rec)) {
                TestUtil.logErr((String)("endpoint address not set correctly: expected " + this.url + ", received " + rec));
                pass = false;
            } else {
                TestUtil.logMsg((String)("endpoint address set correctly to " + this.url));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setPropertyTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("setPropertyTest1 failed");
        }
    }

    public void setPropertyTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"setPropertyTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)("Setting username to " + this.username + " ..."));
            TestUtil.logMsg((String)("Setting username to " + this.username + " ..."));
            if (this.modeProperty.equals("standalone")) {
                this.stub._setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
            } else {
                try {
                    this.stub._setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
                    return;
                }
            }
            TestUtil.logMsg((String)"Verify correct setting of username ...");
            String rec = (String)this.stub._getProperty("javax.xml.rpc.security.auth.username");
            if (!this.username.equals(rec)) {
                TestUtil.logErr((String)("username not set correctly: expected " + this.username + ", received " + rec));
                pass = false;
            } else {
                TestUtil.logMsg((String)("username set correctly to " + this.username));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setPropertyTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("setPropertyTest2 failed");
        }
    }

    public void setPropertyTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"setPropertyTest3");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)("Setting password to " + this.password + " ..."));
            if (this.modeProperty.equals("standalone")) {
                this.stub._setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
            } else {
                try {
                    this.stub._setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
                    return;
                }
            }
            TestUtil.logMsg((String)"Verify correct setting of property ...");
            String rec = (String)this.stub._getProperty("javax.xml.rpc.security.auth.password");
            if (!this.password.equals(rec)) {
                TestUtil.logErr((String)("password not set correctly: expected " + this.password + ", received " + rec));
                pass = false;
            } else {
                TestUtil.logMsg((String)("password set correctly to " + this.password));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setPropertyTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("setPropertyTest3 failed");
        }
    }

    public void setPropertyTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"setPropertyTest4");
        boolean pass = true;
        Boolean v = new Boolean("true");
        try {
            TestUtil.logMsg((String)"Setting session maintain property to true ...");
            if (this.modeProperty.equals("standalone")) {
                this.stub._setProperty("javax.xml.rpc.session.maintain", (Object)v);
            } else {
                try {
                    this.stub._setProperty("javax.xml.rpc.session.maintain", (Object)v);
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
                    return;
                }
            }
            TestUtil.logMsg((String)"Verify correct setting of property ...");
            Boolean rec = (Boolean)this.stub._getProperty("javax.xml.rpc.session.maintain");
            if (!v.equals(rec)) {
                TestUtil.logErr((String)("session maintain not set correctly: expected " + v + ", received " + rec));
                pass = false;
            } else {
                TestUtil.logMsg((String)("session maintain set correctly to " + v));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setPropertyTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("setPropertyTest4 failed");
        }
    }

    public void setPropertyInvalidTest() throws EETest.Fault {
        TestUtil.logTrace((String)"setPropertyInvalidTest");
        boolean pass = true;
        if (!this.invalidPropertyTest1()) {
            pass = false;
        }
        if (!this.invalidPropertyTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("setPropertyInvalidTest failed");
        }
    }

    public void setPropertyTest6a() throws EETest.Fault {
        TestUtil.logTrace((String)"setPropertyTest6a");
        boolean pass = true;
        if (!this.invokeRPCMethodPositiveTest()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("setPropertyTest6a failed");
        }
    }

    public void setPropertyTest6b() throws EETest.Fault {
        TestUtil.logTrace((String)"setPropertyTest6b");
        boolean pass = true;
        if (!this.invokeRPCMethodNegativeTest1()) {
            pass = false;
        }
        if (!this.invokeRPCMethodNegativeTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("setPropertyTest6b failed");
        }
    }

    public void getPropertyTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getPropertyTest");
        boolean pass = true;
        if (!this.getPropertyPositiveTest()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getPropertyTest failed");
        }
    }

    public void getPropertyInvalidTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getPropertyInvalidTest");
        boolean pass = true;
        if (!this.getPropertyNegativeTest1()) {
            pass = false;
        }
        if (!this.getPropertyNegativeTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getPropertyInvalidTest failed");
        }
    }

    private boolean getPropertyPositiveTest() {
        TestUtil.logTrace((String)"getPropertyPositiveTest");
        boolean pass = true;
        Object p = null;
        String s = null;
        try {
            TestUtil.logMsg((String)"Get of endpoint address ...");
            try {
                p = this.stub._getProperty("javax.xml.rpc.service.endpoint.address");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
                return true;
            }
            if (p != null) {
                TestUtil.logMsg((String)("endpoint address received, value is: " + p));
            } else {
                TestUtil.logMsg((String)"endpoint address received, value is: null");
            }
            TestUtil.logMsg((String)"Set/Get of endpoint address ...");
            this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            s = (String)this.stub._getProperty("javax.xml.rpc.service.endpoint.address");
            if (!s.equals(this.url)) {
                TestUtil.logErr((String)("endpoint address not received correctly: expected " + this.url + ", received " + s));
                pass = false;
            } else {
                TestUtil.logMsg((String)"endpoint address received correctly");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "getPropertyPositiveTest2");
        return pass;
    }

    private boolean getPropertyNegativeTest1() {
        TestUtil.logTrace((String)"getPropertyNegativeTest1");
        boolean pass = true;
        Object p = null;
        try {
            TestUtil.logMsg((String)"Get of invalid property ...");
            try {
                p = this.stub._getProperty("javax.xml.rpc.foo.bar");
                TestUtil.logErr((String)"no exception occurred ...");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
            }
            catch (JAXRPCException e) {
                TestUtil.logMsg((String)"JAXRPCException as expected ...");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception ... ", (Throwable)e);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "getPropertyNegativeTest1");
        return pass;
    }

    private boolean getPropertyNegativeTest2() {
        TestUtil.logTrace((String)"getPropertyNegativeTest2");
        boolean pass = true;
        Object p = null;
        try {
            TestUtil.logMsg((String)"Get of invalid property ...");
            try {
                p = this.stub._getProperty(Constants.NULL_PROPERTY);
                TestUtil.logErr((String)"no exception occurred ...");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
            }
            catch (JAXRPCException e) {
                TestUtil.logMsg((String)"JAXRPCException as expected ...");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception ... ", (Throwable)e);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "getPropertyNegativeTest2");
        return pass;
    }

    private boolean invokeRPCMethodPositiveTest() {
        TestUtil.logTrace((String)"invokeRPCMethodPositiveTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)("Setting endpoint address to " + this.url + " ..."));
            this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            TestUtil.logMsg((String)"Invoking RPC method hello(\"foo\") and expect 'Hello, foo!' ...");
            String response = this.port.hello("foo");
            if (!response.equals("Hello, foo!")) {
                TestUtil.logErr((String)("RPC failed - expected \"Hello, foo!\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "invokeRPCMethodPositiveTest");
        return pass;
    }

    private boolean invokeRPCMethodNegativeTest1() {
        TestUtil.logTrace((String)"invokeRPCMethodNegativeTest1");
        boolean pass = true;
        try {
            this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, BADURL);
            TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
            this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            TestUtil.logMsg((String)"Invoking RPC method on an invalid target endpoint");
            try {
                String response = this.port.hello("foo");
                TestUtil.logErr((String)"Exception did not occur - unexpected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.logMsg((String)"Exception did occur - expected");
                TestUtil.logMsg((String)("Exception was: " + e));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "invokeRPCMethodNegativeTest1");
        return pass;
    }

    private boolean invokeRPCMethodNegativeTest2() {
        TestUtil.logTrace((String)"invokeRPCMethodNegativeTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)("Setting target endpoint to " + this.testservleturl + " ..."));
            this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.testservleturl);
            TestUtil.logMsg((String)"Invoking RPC method on an valid target endpoint that does not process SOAP messages");
            try {
                String response = this.port.hello("foo");
                TestUtil.logErr((String)"Exception did not occur - unexpected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.logMsg((String)"Exception did occur - expected");
                TestUtil.logMsg((String)("Exception was: " + e));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "invokeRPCMethodNegativeTest2");
        return pass;
    }

    private boolean invalidPropertyTest1() {
        TestUtil.logTrace((String)"invalidPropertyTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setting invalid property javax.xml.rpc.foo.bar ...");
            try {
                this.stub._setProperty("javax.xml.rpc.foo.bar", new Object());
                TestUtil.logErr((String)"No exception ... unexpected");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
            }
            catch (JAXRPCException e) {
                TestUtil.logMsg((String)"JAXRPCException caught as expected ...");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception ... ", (Throwable)e);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "invalidPropertyTest1");
        return pass;
    }

    private boolean invalidPropertyTest2() {
        TestUtil.logTrace((String)"invalidPropertyTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setting invalid property - null ...");
            try {
                this.stub._setProperty(Constants.NULL_PROPERTY, new Object());
                TestUtil.logErr((String)"No exception ... unexpected");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Unsupported Operation ... no further testing");
            }
            catch (JAXRPCException e) {
                TestUtil.logMsg((String)"JAXRPCException caught as expected ...");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception ... ", (Throwable)e);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "invalidPropertyTest2");
        return pass;
    }

    private boolean printTestStatus(boolean pass, String test) {
        if (pass) {
            TestUtil.logMsg((String)("" + test + " ... PASSED"));
        } else {
            TestUtil.logErr((String)("" + test + " ... FAILED"));
        }
        return pass;
    }
}

