/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.entityManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.SynchronizationType;
import javax.persistence.TransactionRequiredException;

public class Client
extends PMClientBase {
    Properties props = null;
    Map map = new HashMap();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void createEntityManagerSynchronizationTypeMapTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Test UNSYNCHRONIZED");
            EntityManager em1 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.UNSYNCHRONIZED, this.map);
            if (em1 != null) {
                TestUtil.logTrace((String)"Received non-null EntityManager");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Received null EntityManager");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Test SYNCHRONIZED");
            EntityManager em2 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.SYNCHRONIZED, this.map);
            if (em2 != null) {
                TestUtil.logTrace((String)"Received non-null EntityManager");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Received null EntityManager");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("createEntityManagerSynchronizationTypeMapTest failed");
        }
    }

    public void createEntityManagerSynchronizationTypeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Test UNSYNCHRONIZED");
            EntityManager em1 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.UNSYNCHRONIZED);
            if (em1 != null) {
                TestUtil.logTrace((String)"Received non-null EntityManager");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Received null EntityManager");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Test SYNCHRONIZED");
            EntityManager em2 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.SYNCHRONIZED);
            if (em2 != null) {
                TestUtil.logTrace((String)"Received non-null EntityManager");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Received null EntityManager");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("createEntityManagerSynchronizationTypeTest failed");
        }
    }

    public void joinTransactionTransactionRequiredExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityManager().joinTransaction();
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinTransactionTransactionRequiredExceptionTest failed");
        }
    }
}

