/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.ejb.session.stateful.bean2beanmultijartest.bean1;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.ejb.session.stateful.bean2beanmultijartest.bean1.TestBean1;
import com.sun.ts.tests.interop.ejb.session.stateful.bean2beanmultijartest.bean2.TestBean2;
import com.sun.ts.tests.interop.ejb.session.stateful.bean2beanmultijartest.bean2.TestBean2Home;
import java.io.Serializable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.rmi.PortableRemoteObject;

public class TestBean1EJB
implements SessionBean {
    private static final String MyString = "message from bean1";
    private Handle MyHandle = null;
    private HomeHandle MyHomeHandle = null;
    private EJBMetaData MyEJBMetaData = null;
    private EJBObject myEJBObject = null;
    private EJBHome myEJBHome = null;
    private static final String ExpectedString = "message from bean2";
    private TestBean1 bean1Ref = null;
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private TestBean2Home bean2Home = null;
    private TestBean2 bean2Ref = null;
    private TSNamingContext nctx = null;
    private static final String testBean2 = "java:comp/env/ejb/TestBean2";

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"obtain naming context");
            this.nctx = new TSNamingContext();
            this.bean2Home = (TestBean2Home)this.nctx.lookup(testBean2, TestBean2Home.class);
            this.bean2Ref = this.bean2Home.create(this.harnessProps);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception in ejbCreate", (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    private void getInfo() throws EJBException {
        try {
            this.myEJBObject = this.sctx.getEJBObject();
            this.myEJBHome = this.myEJBObject.getEJBHome();
            this.MyHandle = this.myEJBObject.getHandle();
            this.MyHomeHandle = this.myEJBHome.getHomeHandle();
            this.MyEJBMetaData = this.myEJBHome.getEJBMetaData();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("EJBException: " + e);
        }
    }

    public String whoAmI() {
        return MyString;
    }

    public boolean returnBean2String() {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"returnBean2String");
            String s = this.bean2Ref.returnBean2String();
            if (s == null) {
                TestUtil.logErr((String)"String returned is null");
            } else if (s.equals(ExpectedString)) {
                TestUtil.logMsg((String)"String returned in returnBean2String is correct");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception in returnBean2String: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnBean2Handle() {
        TestBean2 bRef2 = null;
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"returnBean2Handle");
            Handle v = this.bean2Ref.returnBean2Handle();
            if (v == null) {
                TestUtil.logErr((String)"Handle returned is null");
            } else if (!(v instanceof Serializable)) {
                TestUtil.logErr((String)"Handle returned is not serializable");
            } else {
                TestUtil.logMsg((String)"Convert Handle to appropriate bean reference");
                EJBObject ejbObject = v.getEJBObject();
                bRef2 = (TestBean2)PortableRemoteObject.narrow((Object)ejbObject, TestBean2.class);
                TestUtil.logMsg((String)"Check if we have correct bean reference");
                String whoami = bRef2.whoAmI();
                if (whoami.equals(ExpectedString)) {
                    pass = true;
                    TestUtil.logMsg((String)"Correct bean reference (thus correct Handle)");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception in returnBean2Handle: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (bRef2 != null) {
                    bRef2.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logTrace((String)("Caught exception removing bRef2 in returnBean2Handle: " + e.getMessage()));
            }
        }
        return pass;
    }

    public boolean returnBean2HomeHandle() {
        boolean pass = false;
        TestBean2Home bean2Home = null;
        try {
            TestUtil.logTrace((String)"returnBean2HomeHandle");
            HomeHandle v = this.bean2Ref.returnBean2HomeHandle();
            if (v == null) {
                TestUtil.logErr((String)"HomeHandle returned is null");
            } else if (!(v instanceof Serializable)) {
                TestUtil.logErr((String)"HomeHandle returned is not serializable");
            } else {
                TestUtil.logMsg((String)"Get HomeHandle and narrow to appropriate beanhome reference");
                EJBHome ejbHome = v.getEJBHome();
                bean2Home = (TestBean2Home)PortableRemoteObject.narrow((Object)ejbHome, TestBean2Home.class);
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception in returnBean2HomeHandle: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return pass;
    }

    public boolean returnBean2EJBMetaData() {
        boolean pass = false;
        Object bean2Home = null;
        try {
            TestUtil.logTrace((String)"returnBean2EJBMetaData");
            EJBMetaData v = this.bean2Ref.returnBean2EJBMetaData();
            if (v == null) {
                TestUtil.logErr((String)"EJBMetaData returned is null");
            } else if (!(v instanceof Serializable)) {
                TestUtil.logErr((String)"EJBMetaData returned is not serializable");
            } else {
                TestUtil.logMsg((String)"Get the home interface class from EJBMetaData");
                Class cls = v.getHomeInterfaceClass();
                String clsName = cls.getName();
                TestUtil.logMsg((String)("The class name = " + clsName));
                if (clsName.endsWith("TestBean2Home")) {
                    pass = true;
                    TestUtil.logMsg((String)"Correct beanhome (thus correct EJBMetaData)");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return pass;
    }

    public boolean passBean1String() {
        try {
            TestUtil.logTrace((String)"passBean1String");
            return this.bean2Ref.passBean1String(MyString);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Caught Exception:" + e.getMessage());
        }
    }

    public boolean passBean1Handle() {
        try {
            TestUtil.logTrace((String)"passBean1Handle");
            this.getInfo();
            return this.bean2Ref.passBean1Handle(this.MyHandle);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Caught Exception:" + e.getMessage());
        }
    }

    public boolean passBean1HomeHandle() {
        try {
            TestUtil.logTrace((String)"passBean1HomeHandle");
            this.getInfo();
            return this.bean2Ref.passBean1HomeHandle(this.MyHomeHandle);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Caught Exception:" + e.getMessage());
        }
    }

    public boolean passBean1EJBMetaData() {
        try {
            TestUtil.logTrace((String)"passBean1EJBMetaData");
            this.getInfo();
            return this.bean2Ref.passBean1EJBMetaData(this.MyEJBMetaData);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Caught Exception:" + e.getMessage());
        }
    }
}

