/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.dao;

import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.InvalidDAOSettingException;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.DataSourceCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.TxCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.CompoundPKCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.CompoundPKDSCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.FloatPKCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.FloatPKDSCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.LongPKCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.LongPKDSCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.StringPKCoffeeDAO;
import com.sun.ts.tests.common.dao.coffee.variants.StringPKDSCoffeeDAO;
import java.util.Properties;

public class TSDAOFactory
extends DAOFactory {
    private boolean debug = true;
    private static final String PKG = "com.sun.ts.tests.common.dao.daofactory";
    public static final String BACKEND_ACCESS_PROPERTY = "com.sun.ts.tests.common.dao.daofactory.backend.access";
    public static final String BACKEND_ACCESS_DATASOURCE = "DataSource";
    public static final String AUTH_TYPE_PROPERTY = "com.sun.ts.tests.common.dao.daofactory.authorization.type";
    public static final String AUTH_TYPE_CONTAINER = "Container";
    public static final String AUTH_TYPE_COMPONENT = "Component";
    public static final String AUTH_USER_PROPERTY = "com.sun.ts.tests.common.dao.daofactory.authorization.component.user";
    public static final String AUTH_PASSWORD_PROPERTY = "com.sun.ts.tests.common.dao.daofactory.authorization.component.password";
    public static final String TABLE_PREFIX_PROPERTY = "com.sun.ts.tests.common.dao.daofactory.db.table.prefix";

    @Override
    public CoffeeDAO getCoffeeDAO() throws DAOException {
        return this.getCoffeeDAO(new Properties());
    }

    @Override
    public CoffeeDAO getCoffeeDAO(Properties p) throws DAOException {
        CoffeeDAOInfo info = this.parseCoffeeProps(p, "COFFEE");
        DataSourceCoffeeDAO dao = info.containerAuth ? new DataSourceCoffeeDAO(info.tablePrefix) : new DataSourceCoffeeDAO(info.tablePrefix, info.user, info.password);
        if (this.debug) {
            dao.setPolicy(1);
        }
        return dao;
    }

    @Override
    public TxCoffeeDAO getTxCoffeeDAO() throws DAOException {
        throw new UnsupportedOperationException("To be implemented");
    }

    @Override
    public TxCoffeeDAO getTxCoffeeDAO(Properties p) throws DAOException {
        throw new UnsupportedOperationException("To be implemented");
    }

    @Override
    public StringPKCoffeeDAO getStringPKCoffeeDAO() throws DAOException {
        return this.getStringPKCoffeeDAO(new Properties());
    }

    public StringPKCoffeeDAO getStringPKCoffeeDAO(Properties p) throws DAOException {
        CoffeeDAOInfo info = this.parseCoffeeProps(p, "COFFEE_STRING_PK");
        StringPKDSCoffeeDAO dao = info.containerAuth ? new StringPKDSCoffeeDAO(info.tablePrefix) : new StringPKDSCoffeeDAO(info.tablePrefix, info.user, info.password);
        if (this.debug) {
            dao.setPolicy(1);
        }
        return dao;
    }

    @Override
    public LongPKCoffeeDAO getLongPKCoffeeDAO() throws DAOException {
        return this.getLongPKCoffeeDAO(new Properties());
    }

    public LongPKCoffeeDAO getLongPKCoffeeDAO(Properties p) throws DAOException {
        CoffeeDAOInfo info = this.parseCoffeeProps(p, "COFFEE_LONG_PK");
        LongPKDSCoffeeDAO dao = info.containerAuth ? new LongPKDSCoffeeDAO(info.tablePrefix) : new LongPKDSCoffeeDAO(info.tablePrefix, info.user, info.password);
        if (this.debug) {
            dao.setPolicy(1);
        }
        return dao;
    }

    @Override
    public FloatPKCoffeeDAO getFloatPKCoffeeDAO() throws DAOException {
        return this.getFloatPKCoffeeDAO(new Properties());
    }

    public FloatPKCoffeeDAO getFloatPKCoffeeDAO(Properties p) throws DAOException {
        CoffeeDAOInfo info = this.parseCoffeeProps(p, "COFFEE_FLOAT_PK");
        FloatPKDSCoffeeDAO dao = info.containerAuth ? new FloatPKDSCoffeeDAO(info.tablePrefix) : new FloatPKDSCoffeeDAO(info.tablePrefix, info.user, info.password);
        if (this.debug) {
            dao.setPolicy(1);
        }
        return dao;
    }

    @Override
    public CompoundPKCoffeeDAO getCompoundPKCoffeeDAO() throws DAOException {
        return this.getCompoundPKCoffeeDAO(new Properties());
    }

    public CompoundPKCoffeeDAO getCompoundPKCoffeeDAO(Properties p) throws DAOException {
        CoffeeDAOInfo info = this.parseCoffeeProps(p, "COFFEE_COMPOUND_PK");
        CompoundPKDSCoffeeDAO dao = info.containerAuth ? new CompoundPKDSCoffeeDAO(info.tablePrefix) : new CompoundPKDSCoffeeDAO(info.tablePrefix, info.user, info.password);
        if (this.debug) {
            dao.setPolicy(1);
        }
        return dao;
    }

    protected CoffeeDAOInfo parseCoffeeProps(Properties props, String defaultTablePrefix) throws DAOException {
        CoffeeDAOInfo info = new CoffeeDAOInfo();
        if (null == props) {
            throw new IllegalArgumentException("Null props");
        }
        if (null == defaultTablePrefix || "".equals(defaultTablePrefix)) {
            throw new IllegalArgumentException("Invalid table prefix: " + defaultTablePrefix);
        }
        info.tablePrefix = props.getProperty(TABLE_PREFIX_PROPERTY, defaultTablePrefix);
        String authType = props.getProperty(AUTH_TYPE_PROPERTY, AUTH_TYPE_CONTAINER);
        String backendAccess = props.getProperty(BACKEND_ACCESS_PROPERTY, BACKEND_ACCESS_DATASOURCE);
        if (!backendAccess.equals(BACKEND_ACCESS_DATASOURCE)) {
            throw new InvalidDAOSettingException(BACKEND_ACCESS_PROPERTY, backendAccess, "Unsupported backend access");
        }
        if (null == info.tablePrefix || info.tablePrefix.equals("")) {
            throw new InvalidDAOSettingException(TABLE_PREFIX_PROPERTY, info.tablePrefix, "Null or empty table prefix");
        }
        info.containerAuth = authType.equals(AUTH_TYPE_CONTAINER);
        if (!authType.equals(AUTH_TYPE_COMPONENT) && !info.containerAuth) {
            throw new InvalidDAOSettingException(AUTH_TYPE_PROPERTY, authType, "Unknown authorization type");
        }
        if (!info.containerAuth) {
            info.user = props.getProperty(AUTH_USER_PROPERTY);
            if (null == info.user) {
                throw new InvalidDAOSettingException(AUTH_USER_PROPERTY, info.user, "No username!");
            }
            info.password = props.getProperty(AUTH_PASSWORD_PROPERTY);
            if (null == info.password) {
                throw new InvalidDAOSettingException(AUTH_PASSWORD_PROPERTY, info.password, "No password!");
            }
        }
        return info;
    }

    public class CoffeeDAOInfo {
        public String tablePrefix;
        public boolean containerAuth;
        public String user;
        public String password;
    }
}

