/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.ObjectHolder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.xml.rpc.holders.ObjectHolder;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private static final Short myShort = new Short(Short.MIN_VALUE);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void ObjectHolderConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"ObjectHolderConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ObjectHolder() ...");
            ObjectHolder n = new ObjectHolder();
            if (n != null) {
                TestUtil.logMsg((String)"ObjectHolder object created successfully");
            } else {
                TestUtil.logErr((String)"ObjectHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("ObjectHolderConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("ObjectHolderConstructorTest1 failed");
        }
    }

    public void ObjectHolderConstructorTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"ObjectHolderConstructorTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ObjectHolder(Object) ...");
            ObjectHolder n = new ObjectHolder((Object)myShort);
            if (n != null) {
                TestUtil.logMsg((String)"ObjectHolder object created successfully");
            } else {
                TestUtil.logErr((String)"ObjectHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("ObjectHolderConstructorTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("ObjectHolderConstructorTest2 failed");
        }
    }

    public void getValueTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest");
        boolean pass = true;
        if (!this.getValueTest1()) {
            pass = false;
        }
        if (!this.getValueTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getValueTest failed");
        }
    }

    private boolean getValueTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ObjectHolder() ...");
            ObjectHolder n = new ObjectHolder();
            if (n != null) {
                Object v = n.value;
                if (v == null) {
                    TestUtil.logMsg((String)"Value set to null as expected");
                } else {
                    TestUtil.logErr((String)("Value: expected - null, received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"ObjectHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean getValueTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via ObjectHolder(Object) ...");
            ObjectHolder n = new ObjectHolder((Object)myShort);
            if (n != null) {
                Short v = (Short)n.value;
                if (v.equals(myShort)) {
                    TestUtil.logMsg((String)("Value set as expected to " + myShort));
                } else {
                    TestUtil.logErr((String)("Value: expected - " + myShort + ", received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"ObjectHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

