/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.xa;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.transaction.UserTransaction;

public class MsgBeanxa
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    protected MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;

    public MsgBeanxa() {
        TestUtil.logTrace((String)"@MsgBeanMsgTestPropsQ()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"mdb -ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        QueueSession qSession = null;
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)(" @onMessage!" + msg));
        Object messageSent = null;
        try {
            TestUtil.logTrace((String)("TestCase:=====================" + msg.getStringProperty("COM_SUN_JMS_TESTNAME")));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                qSession = this.qConnection.createQueueSession(false, 1);
            }
            TestUtil.logTrace((String)("will run TestCase: " + msg.getStringProperty("COM_SUN_JMS_TESTNAME")));
            this.runTests(msg, qSession);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void runTests(Message msg, QueueSession qSession) {
        try {
            if (msg.getIntProperty("TestCaseNum") > 0) {
                switch (msg.getIntProperty("TestCaseNum")) {
                    case 1: {
                        this.runTest1(msg, qSession);
                        break;
                    }
                    case 2: {
                        this.runTest2(msg, qSession);
                        break;
                    }
                    case 3: {
                        this.runTest3(msg, qSession);
                        break;
                    }
                    case 4: {
                        this.runTest4(msg, qSession);
                        break;
                    }
                    case 5: {
                        this.runTest5(msg, qSession);
                        break;
                    }
                    case 6: {
                        this.runTest6(msg, qSession);
                        break;
                    }
                    case 7: {
                        this.runTest7(msg, qSession);
                        break;
                    }
                    case 8: {
                        this.runTest8(msg, qSession);
                        break;
                    }
                    case 9: {
                        this.runTest9(msg, qSession);
                        break;
                    }
                    case 10: {
                        this.runTest10(msg, qSession);
                        break;
                    }
                    default: {
                        TestUtil.logTrace((String)("Error in mdb - No test match for TestCaseNum: " + msg.getIntProperty("TestCaseNum")));
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest1(Message msg, QueueSession qSession) {
        try {
            TestUtil.logTrace((String)("Second time? = " + this.isJmsRedelivered(msg)));
            if (!this.isJmsRedelivered(msg)) {
                TestUtil.logTrace((String)"Test1 message: first time thru");
                TestUtil.logTrace((String)("Message Number: " + msg.getIntProperty("TestCaseNum")));
                this.mdc.setRollbackOnly();
            } else {
                TestUtil.logTrace((String)"Test1 message: again - Pass!");
                JmsUtil.sendTestResults("xaTest1", true, qSession, this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest2(Message msg, QueueSession qSession) {
        try {
            if (!this.isJmsRedelivered(msg)) {
                TestUtil.logTrace((String)"Test2 message: first time thru");
                TestUtil.logTrace((String)("Message Number: " + msg.getIntProperty("TestCaseNum")));
                JmsUtil.sendTestResults("xaTest2", false, qSession, this.queueR);
                this.mdc.setRollbackOnly();
            } else {
                TestUtil.logTrace((String)"Test2 message: again - Pass!");
                JmsUtil.sendTestResults("xaTest2", true, qSession, this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest3(Message msg, QueueSession qSession) {
        if (this.mdc.getRollbackOnly()) {
            TestUtil.logTrace((String)"runTest3! =====    FAIL!");
            JmsUtil.sendTestResults("xaTest3", false, qSession, this.queueR);
        } else {
            TestUtil.logTrace((String)"runTest3 =====    PASS!");
            JmsUtil.sendTestResults("xaTest3", true, qSession, this.queueR);
        }
    }

    private void runTest4(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            int status = ut.getStatus();
            if (status != 6) {
                JmsUtil.sendTestResults("xaTest4", false, qSession, this.queueR);
                TestUtil.logTrace((String)"runTest4 =====    FAIL!");
            } else {
                TestUtil.logTrace((String)"runTest4 =====    PASS!");
                JmsUtil.sendTestResults("xaTest4", true, qSession, this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest5(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults("xaTest5", true, qSession, this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest6(Message msg, QueueSession session) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults("xaTest6", true, session, this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest7(Message msg, QueueSession qSession) {
        try {
            TestUtil.logTrace((String)("JmsRedelivered flag = " + this.isJmsRedelivered(msg)));
            if (!this.isJmsRedelivered(msg)) {
                TestUtil.logTrace((String)"Test7 message: first time thru");
                TestUtil.logTrace((String)("Message Number: " + msg.getIntProperty("TestCaseNum")));
                this.mdc.setRollbackOnly();
            } else {
                TestUtil.logTrace((String)"Test7 message: again - Pass!");
                JmsUtil.sendTestResults("xaTest7", true, qSession, this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest8(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults("xaTest8", false, qSession, this.queueR);
            ut.rollback();
            ut.begin();
            JmsUtil.sendTestResults("xaTest8", true, qSession, this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest9(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults("xaTest9", false, qSession, this.queueR);
            ut.rollback();
            ut.begin();
            JmsUtil.sendTestResults("xaTest9", true, qSession, this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest10(Message msg, QueueSession qSession) {
        try {
            TestUtil.logTrace((String)("Second time? = " + this.isJmsRedelivered(msg)));
            if (!this.isJmsRedelivered(msg)) {
                TestUtil.logTrace((String)"Test10 message: first time thru");
                TestUtil.logTrace((String)("Message Number: " + msg.getIntProperty("TestCaseNum")));
                JmsUtil.sendTestResults("xaTest10", false, qSession, this.queueR);
                this.mdc.setRollbackOnly();
            } else {
                TestUtil.logTrace((String)"Test10 message: again - Pass!");
                JmsUtil.sendTestResults("xaTest10", true, qSession, this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private boolean isJmsRedelivered(Message msg) {
        boolean redelivered = false;
        try {
            redelivered = msg.getJMSRedelivered();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return redelivered;
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"remove()!!");
    }
}

