/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.webservices.allowedmethodstest.bm;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.webservices.allowedmethodstest.bm.Test;
import com.sun.ts.tests.ejb.ee.webservices.allowedmethodstest.bm.TestBean;
import com.sun.ts.tests.ejb.ee.webservices.allowedmethodstest.bm.TestBeanHome;
import java.util.Properties;
import javax.xml.rpc.Service;

public class Client
extends EETest {
    private static final String testName = "AllowedmethodsTest";
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final String serviceLookup = "java:comp/env/service/TestService";
    private TestBean beanRef = null;
    private Service svc = null;
    private Test port = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;
    private String user_value;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        this.user_value = this.props.getProperty("user");
        String authUsername = this.props.getProperty("authuser");
        String authPassword = this.props.getProperty("authpassword");
        TestUtil.logMsg((String)("user_value= " + this.user_value));
        TestUtil.logMsg((String)("auth_username= " + authUsername));
        TestUtil.logMsg((String)("auth_password= " + authPassword));
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TSLoginContext lc = new TSLoginContext();
            lc.login(authUsername, authPassword);
            TestUtil.logMsg((String)"Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            TestUtil.logMsg((String)"Looking up service: java:comp/env/service/TestService");
            this.svc = (Service)this.nctx.lookup(serviceLookup);
            TestUtil.logMsg((String)"Obtained service");
            this.port = (Test)this.svc.getPort(Test.class);
            TestUtil.logMsg((String)"Obtained port");
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void wsbmAllowedMethodsTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Operation Tests for businessMethod");
        boolean pass = true;
        boolean response = false;
        try {
            TestUtil.logMsg((String)"Create EJB instance");
            this.beanRef = this.beanHome.create();
            TestUtil.logMsg((String)"Initialize remote logging");
            this.beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Calling EJB business method from Web Service Endpoint Interface");
            response = this.port.businessMethod();
            if (!response) {
                TestUtil.logErr((String)"INCORRECT RESULTS RECEIVED");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("wsbmAllowedMethodsTest1 failed", e);
        }
        try {
            this.beanRef.remove();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected Exception caught removing bean:" + e), (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("wsbmAllowedMethodsTest1 failed");
        }
    }

    public void wsbmAllowedMethodsTest2() throws EETest.Fault {
        boolean pass = true;
        boolean response1 = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create();
            this.beanRef.initLogging(this.props);
            this.logMsg("Calling method with user: " + this.user_value);
            response1 = this.port.getCallerPrincipalTest(this.user_value);
            if (!response1) {
                TestUtil.logErr((String)"INCORRECT RESULTS RECEIVED");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("wsbmAllowedMethodsTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("wsbmAllowedMethodsTest2 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }
}

