/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.wsdlImport.http.shared1;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices.wsdlImport.http.shared1.AllStruct;
import com.sun.ts.tests.webservices.wsdlImport.http.shared1.SharedTest1;
import com.sun.ts.tests.webservices.wsdlImport.http.shared1.SharedTest2;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;

public class Client
extends ServiceEETest {
    SharedTest1 port1 = null;
    SharedTest2 port2 = null;

    private void getStub() throws Exception {
        TestUtil.logMsg((String)"JNDI lookup for Service1");
        InitialContext ctx = new InitialContext();
        Service svc = (Service)ctx.lookup("java:comp/env/service/svc1");
        TestUtil.logMsg((String)"Get port from Service1");
        this.port1 = (SharedTest1)svc.getPort(SharedTest1.class);
        TestUtil.logMsg((String)"Port1 obtained");
        TestUtil.logMsg((String)"JNDI lookup for Service2");
        Service svc2 = (Service)ctx.lookup("java:comp/env/service/svc2");
        TestUtil.logMsg((String)"Get port from Service2");
        this.port2 = (SharedTest2)svc2.getPort(SharedTest2.class);
        TestUtil.logMsg((String)"Port2 obtained");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.getStub();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void SharedImportTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"SharedImportTest");
            AllStruct orig = new AllStruct();
            orig.setVarString("SharedImportTest");
            orig.setVarInt(11);
            TestUtil.logMsg((String)"Calling first port ");
            AllStruct ret1 = this.port1.echoAllStruct(orig);
            TestUtil.logMsg((String)"Calling second port ");
            AllStruct ret2 = this.port2.echoAllStruct(orig);
            String expectedString1 = orig.getVarString() + "_SharedTestImpl1";
            int expectedInt1 = orig.getVarInt() + 1;
            String expectedString2 = orig.getVarString() + "_SharedTestImpl2";
            int expectedInt2 = orig.getVarInt() + 2;
            if (!ret1.getVarString().equals(expectedString1)) {
                TestUtil.logErr((String)("unexpected string from returned structure while calling svc1: expecting " + expectedString1 + ", but got: " + ret1.getVarString()));
                pass = false;
            }
            if (ret1.getVarInt() != expectedInt1) {
                TestUtil.logErr((String)("unexpected int from returned structure while calling svc1: expecting " + expectedInt1 + ", but got: " + ret1.getVarInt()));
                pass = false;
            }
            if (!ret2.getVarString().equals(expectedString2)) {
                TestUtil.logErr((String)("unexpected string from returned structure while calling svc2: expecting " + expectedString2 + ", but got: " + ret2.getVarString()));
                pass = false;
            }
            if (ret2.getVarInt() != expectedInt2) {
                TestUtil.logErr((String)("unexpected int from returned structure while calling svc2: expecting " + expectedInt2 + ", but got: " + ret2.getVarInt()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("did not pass");
        }
    }
}

