/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_rec;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee.mdb.mdb_rec.MDB_AR_Test;
import java.util.Properties;
import javax.ejb.EJB;

public class MDBClient
extends EETest {
    @EJB(name="ejb/MDB_AR_Test")
    private static MDB_AR_Test hr;
    private Properties props = null;

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            if (hr == null) {
                throw new EETest.Fault("@EJB injection failed");
            }
            hr.setup(p);
            if (hr.isThereSomethingInTheQueue()) {
                TestUtil.logTrace((String)"Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                TestUtil.logTrace((String)"Nothing left in queue");
            }
            this.logMsg("Setup ok;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup Failed!", e);
        }
    }

    public void asynRecTextMsgQueueTest() throws EETest.Fault {
        try {
            this.logMsg("Call bean - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_Text_Msg_Test";
            hr.sendTextMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: test1 failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecMapMsgQueueTest() throws EETest.Fault {
        try {
            this.logMsg("Call bean  - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_MapMessage_Test";
            TestUtil.logTrace((String)"Have bean send mdb a map message;");
            hr.sendMapMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: test3 failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecObjectMsgQueueTest() throws EETest.Fault {
        try {
            this.logMsg("Call bean - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_ObjectMessage_Test";
            TestUtil.logTrace((String)"Have bean send mdb a object message;");
            hr.sendObjectMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: test5 failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecTextMsgTopicTest() throws EETest.Fault {
        String matchMe = "mdb_asynchRecFromTopic_Text_Msg_Test";
        try {
            this.logMsg("Call bean  - have it send mdb a message;");
            hr.sendTextMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: test6 failed");
            }
            this.logMsg("Test passed;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecBytesMsgQueueTest() throws EETest.Fault {
        try {
            this.logMsg("Call bean  - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_BytesMessage_Test";
            TestUtil.logTrace((String)"Have bean send mdb a bytes message;");
            hr.sendBytesMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: test2 failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecStreamMsgQueueTest() throws EETest.Fault {
        try {
            this.logMsg("Call bean - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_StreamMessage_Test";
            TestUtil.logTrace((String)"Have bean send mdb a stream message;");
            hr.sendStreamMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: test4 failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecMapMsgTopicTest() throws EETest.Fault {
        String matchMe = "mdb_asynchRecFromTopic_Map_Msg_Test";
        try {
            this.logMsg("Call bean - have it send mdb a message;");
            hr.sendMapMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: asynRecMapMsgTopicTest failed");
            }
            this.logMsg("Test passed;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecObjectMsgTopicTest() throws EETest.Fault {
        String matchMe = "mdb_asynchRecFromTopic_Object_Msg_Test";
        try {
            this.logMsg("Call bean - have it send mdb a message;");
            hr.sendObjectMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: asynRecObjectMsgTopicTest failed");
            }
            this.logMsg("Test passed;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecBytesMsgTopicTest() throws EETest.Fault {
        String matchMe = "mdb_asynchRecFromTopic_Bytes_Msg_Test";
        try {
            this.logMsg("Call bean - have it send mdb a message;");
            hr.sendBytesMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: asynRecBytesMsgTopicTest failed");
            }
            this.logMsg("Test passed;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void asynRecStreamMsgTopicTest() throws EETest.Fault {
        String matchMe = "mdb_asynchRecFromTopic_Stream_Msg_Test";
        try {
            this.logMsg("Call bean - have it send mdb a message;");
            hr.sendStreamMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: asynRecStreamMsgTopicTest failed");
            }
            this.logMsg("Test passed;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                TestUtil.logTrace((String)"Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                TestUtil.logTrace((String)"Nothing left in queue");
            }
            this.logMsg("End  of client cleanup;");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception cleaning up the Queue", e);
        }
        finally {
            TestUtil.logTrace((String)"Closing all connections");
            try {
                hr.cleanup();
            }
            catch (Exception oh) {
                TestUtil.logErr((String)"Fail: unexpected exception closing Connections", (Throwable)oh);
                TestUtil.printStackTrace((Throwable)oh);
                throw new EETest.Fault("Fail");
            }
            TestUtil.logTrace((String)"Removing EJBs");
            try {
                hr.remove();
            }
            catch (Exception oh) {
                TestUtil.logErr((String)"Fail: unexpected exception removing EJB", (Throwable)oh);
                TestUtil.printStackTrace((Throwable)oh);
                throw new EETest.Fault("Fail");
            }
        }
    }
}

