/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.CapabilityProfile;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Properties;
import javax.xml.registry.CapabilityProfile;

public class JAXRClient
extends JAXRCommonClient {
    int level = 0;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.level = Integer.parseInt(p.getProperty("providerCapability"));
            super.setup(args, p);
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            TestUtil.logTrace((String)this.debug.toString());
            this.debug.clear();
        }
    }

    public void CapabilityProfile_getVersionTest() throws EETest.Fault {
        String testName = "CapabilityProfile_getVersionTest";
        String jaxrSpecVersion = "1.0";
        try {
            CapabilityProfile cp = this.rs.getCapabilityProfile();
            this.debug.add("Expecting version " + jaxrSpecVersion + "\n");
            this.debug.add("Specification version returned" + cp.getVersion());
            String version = cp.getVersion();
            if (version.indexOf(jaxrSpecVersion) == -1) {
                throw new EETest.Fault(testName + " Error: version " + jaxrSpecVersion + " not found ");
            }
            this.debug.add("Test passed\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void CapabilityProfile_getCapabilityLevelTest() throws EETest.Fault {
        String testName = "CapabilityProfile_getCapabilityLevelTest";
        try {
            CapabilityProfile cp = this.rs.getCapabilityProfile();
            int cpLevel = cp.getCapabilityLevel();
            this.debug.add("The expected capability level is " + this.level + "\n");
            this.debug.add("The capability level returned from getCapabilityLevel is " + cpLevel + "\n");
            if (this.level != cpLevel) {
                throw new EETest.Fault(testName + " failed");
            }
            this.debug.add("Test passed\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }
}

