/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.reentranttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.reentranttest.LoopBack;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.reentranttest.TestBean;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

public class TestBeanEJB
implements EntityBean {
    private CoffeeBean cache;
    private CoffeeDAO dao = null;
    private EntityContext ectx = null;

    public Integer ejbCreate(Properties p, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logMsg((String)"Get DB Connection");
            this.dao.startSession();
            TestUtil.logTrace((String)"DAO: Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cache = new CoffeeBean(cofID, cofName, cofPrice);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Remove row...");
            this.dao.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            throw new RemoveException("Caught DAOException" + e);
        }
        catch (Exception e) {
            throw new RemoveException("Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ping() {
        TestUtil.logTrace((String)"ping");
    }

    public void sleep(int n) {
        long t2;
        TestUtil.logTrace((String)"sleep");
        long t1 = System.currentTimeMillis();
        while ((t2 = System.currentTimeMillis()) < t1 + (long)n) {
        }
    }

    public boolean loopBackSameBean() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackSameBean");
        TestUtil.logMsg((String)"Perform loopback test");
        try {
            TestUtil.logMsg((String)"getPrimaryKey() object");
            Object o = this.ectx.getPrimaryKey();
            TestUtil.logMsg((String)"getEJBObject() reference");
            TestBean ref = (TestBean)this.ectx.getEJBObject();
            TestUtil.logMsg((String)"Performing self-referential loopback call test");
            ref.ping();
            TestUtil.logMsg((String)"The loopback call test passed");
            pass = true;
        }
        catch (RemoteException e) {
            TestUtil.logErr((String)("Caught unexpected RemoteException: " + e), (Throwable)e);
            pass = false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackAnotherBean(LoopBack ref) {
        boolean pass;
        TestUtil.logTrace((String)"loopBackAnotherBean");
        try {
            TestUtil.logMsg((String)"Performing loopback call test");
            pass = ref.loopBackTest();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

