/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.versioning;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.versioning.Member;
import java.math.BigInteger;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin versionTest1");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass3 = true;
        BigInteger donation = new BigInteger("5000000");
        try {
            this.getEntityTransaction().begin();
            Member m = new Member(1, "Jie Leng", true);
            this.getEntityManager().persist((Object)m);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember.getVersion() == null) {
                TestUtil.logErr((String)"version after persistence is null.");
                pass1 = false;
            } else {
                TestUtil.logTrace((String)("Correct non-null version after create: " + newMember.getVersion()));
            }
            this.getEntityTransaction().begin();
            Member newMember2 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            int oldVersion = newMember2.getVersion();
            newMember2.setDonation(donation);
            this.getEntityManager().merge((Object)newMember2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember3 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember3.getVersion() <= oldVersion) {
                TestUtil.logErr((String)("Wrong version after update: " + newMember3.getVersion() + ", old version: " + oldVersion));
                pass2 = false;
            } else {
                TestUtil.logTrace((String)("Correct version after update: " + newMember3.getVersion() + ", old version: " + oldVersion));
            }
            oldVersion = newMember3.getVersion();
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("SELECT m FROM Member m where m.memberName = :name").setParameter("name", (Object)"Jie Leng").getResultList();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember4 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember4.getVersion() != oldVersion) {
                TestUtil.logErr((String)("Wrong version after query, expected " + oldVersion + ", got " + newMember4.getVersion()));
                pass3 = false;
            } else {
                TestUtil.logTrace((String)("Correct version after query, expected " + oldVersion + ", got:" + newMember4.getVersion()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass1 = false;
            pass2 = false;
            pass3 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("versionTest1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

