/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.RegistryEntry;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.AuditableEvent;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;

public class JAXRClient
extends JAXRCommonClient {
    BusinessQueryManager bqm = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            super.cleanUpRegistry();
            this.debug.clear();
            this.bqm = this.rs.getBusinessQueryManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void registryEntry_setgetExpiration() throws EETest.Fault {
        String testName = "registryEntry_setgetExpiration";
        String serviceName = "testService";
        Date setDate = null;
        int providerlevel = 0;
        String name = "TestOrganizationName";
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            setDate = new Date();
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(name));
            Service service = this.blm.createService(serviceName);
            service.setExpiration(setDate);
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + "failed to throw expected UnsupportedCapabilityException.");
            }
            Date retDate = service.getExpiration();
            if (retDate.compareTo(setDate) != 0) {
                throw new EETest.Fault(testName + " failed to return correct expiration date");
            }
            TestUtil.logMsg((String)"Good: expected expiration date was returned");
        }
        catch (UnsupportedCapabilityException uce) {
            if (providerlevel != 0) {
                TestUtil.logErr((String)("Cleanup error: " + uce.toString()));
                TestUtil.printStackTrace((Throwable)uce);
                throw new EETest.Fault(testName + " failed - unexpected UnsupportedCapabilityException");
            }
        }
        catch (Exception e) {
            if (providerlevel == 0) {
                TestUtil.logErr((String)"Expected level 0 provider to throw UnsupportedCapabilityException");
            }
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryEntry_setgetStability() throws EETest.Fault {
        String testName = "registryEntry_setgetStability";
        String serviceName = "testService";
        int providerlevel = 0;
        String name = "TestOrganizationName";
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(name));
            Service service = this.blm.createService(serviceName);
            service.setStability(2);
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + "failed to throw expected UnsupportedCapabilityException.");
            }
            int retStability = service.getStability();
            if (retStability != 2) {
                throw new EETest.Fault(testName + " failed to return correct stability");
            }
            TestUtil.logMsg((String)"Good: expected stability was returned");
        }
        catch (UnsupportedCapabilityException uce) {
            if (providerlevel != 0) {
                TestUtil.logErr((String)("Cleanup error: " + uce.toString()));
                TestUtil.printStackTrace((Throwable)uce);
                throw new EETest.Fault(testName + " failed - unexpected UnsupportedCapabilityException");
            }
        }
        catch (Exception e) {
            if (providerlevel == 0) {
                TestUtil.logErr((String)"Expected level 0 provider to throw UnsupportedCapabilityException");
            }
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryEntry_getAuditTrailTest() throws EETest.Fault {
        String testName = "registryEntry_getAuditTrailTest";
        String orgName = "TS Default Organization";
        int providerlevel = 0;
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            this.debug.add("Level 0 Providers must throw an UnsupportedCapabilityException for getAuditTrail\n");
            this.debug.add("This provider report a Capability Level of " + providerlevel + "\n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            Collection at = org.getAuditTrail();
            System.out.println("at size is: " + at.size());
            for (AuditableEvent ae : at) {
                System.out.println("ae tyep " + ae.getEventType());
            }
        }
        catch (UnsupportedCapabilityException uc) {
            if (providerlevel == 0) {
                this.debug.add(" Call to getAuditTrail threw UnsupportedCapabilityException as expected\n");
            }
            throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

