/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.mapkey;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.mapkey.Department;
import com.sun.ts.tests.jpa.core.annotations.mapkey.Employee;
import com.sun.ts.tests.jpa.core.annotations.mapkey.Employee2;
import com.sun.ts.tests.jpa.core.annotations.mapkey.Employee3;
import com.sun.ts.tests.jpa.core.annotations.mapkey.Employee4;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private Employee[] empRef = new Employee[10];
    private Employee2 empRef2;
    private Employee3 empRef3;
    private Employee4 empRef4;
    private static Department[] deptRef = new Department[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupCreateTestData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupCreateTestData2(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData2();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupCreateTestData")
    public void annotationMapKeyTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find Employees belonging to Department: Marketing");
            List l = this.getEntityManager().createQuery("Select e from Employee e where e.department.name = 'Marketing'").getResultList();
            for (Object o : l) {
                Employee e = (Employee)o;
                actual.add(e.getId());
            }
            Collections.sort(actual);
            if (expected.equals(actual)) {
                TestUtil.logTrace((String)"Received expected employees");
            } else {
                TestUtil.logErr((String)"Expected id values were:");
                for (Integer i : expected) {
                    TestUtil.logErr((String)("id: " + i));
                }
                TestUtil.logErr((String)"actual id values were:");
                Collections.sort(actual);
                for (Integer i : actual) {
                    TestUtil.logErr((String)("id: " + i));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("annotationMapKeyTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupCreateTestData")
    public void annotationMapKeyTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[3].getId());
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find Employees belonging to Department: Marketing");
            List l = this.getEntityManager().createQuery("Select e.id from Employee e where e.department.name = 'Administration' ORDER BY e.id DESC").getResultList();
            for (Object o : l) {
                Integer i = (Integer)o;
                actual.add(i);
            }
            Collections.sort(actual);
            if (expected.equals(actual)) {
                TestUtil.logTrace((String)"Received expected employees");
            } else {
                TestUtil.logErr((String)"Expected id values were:");
                for (Integer i : expected) {
                    TestUtil.logErr((String)("id: " + i));
                }
                TestUtil.logErr((String)"actual id values were:");
                Collections.sort(actual);
                for (Integer i : actual) {
                    TestUtil.logErr((String)("id: " + i));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("annotationMapKeyTest2 failed");
        }
    }

    @SetupMethod(name="setupCreateTestData2")
    public void joinColumnInsertable() throws EETest.Fault {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            TestUtil.logTrace((String)"find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            TestUtil.logTrace((String)("Name:" + emp2.getFirstName() + " " + emp2.getLastName()));
            Department dept = emp2.getDepartment();
            if (dept == null) {
                TestUtil.logTrace((String)"Received expected null department for employee2");
            } else {
                pass = false;
                TestUtil.logErr((String)("Expected null department, actual:" + dept.getName()));
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            TestUtil.logTrace((String)("Name:" + emp3.getFirstName() + " " + emp3.getLastName()));
            dept = emp3.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[0].getName())) {
                TestUtil.logTrace((String)("Received expected department for employee3:" + dept.getName()));
            } else {
                pass = false;
                if (dept != null) {
                    TestUtil.logErr((String)("Expected department:" + deptRef[0].getName() + ", actual:" + dept.getName()));
                } else {
                    TestUtil.logErr((String)("Expected department:" + deptRef[0].getName() + ", actual:null"));
                }
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            TestUtil.logTrace((String)("Name:" + emp4.getFirstName() + " " + emp4.getLastName()));
            dept = emp4.getDepartment();
            if (dept == null) {
                TestUtil.logTrace((String)"Received expected null department for employee4");
            } else {
                pass = false;
                TestUtil.logErr((String)("Expected department: null, actual:" + dept.getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinColumnInsertable Failed");
        }
    }

    @SetupMethod(name="setupCreateTestData2")
    public void joinColumnUpdatable() throws EETest.Fault {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            TestUtil.logTrace((String)"find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            TestUtil.logTrace((String)("Name:" + emp2.getFirstName() + " " + emp2.getLastName()));
            TestUtil.logTrace((String)("set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName()));
            emp2.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp2);
            this.getEntityManager().flush();
            this.clearCache();
            TestUtil.logTrace((String)"find employee2 again");
            emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            TestUtil.logTrace((String)("Name:" + emp2.getFirstName() + " " + emp2.getLastName()));
            Department dept = emp2.getDepartment();
            if (dept == null) {
                TestUtil.logTrace((String)"Received expected null department");
            } else {
                pass = false;
                TestUtil.logErr((String)("Expected null department, actual:" + dept.getName()));
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            TestUtil.logTrace((String)("Name:" + emp3.getFirstName() + " " + emp3.getLastName()));
            TestUtil.logTrace((String)("Department:" + emp3.getDepartment().getId() + ", " + emp3.getDepartment().getName()));
            TestUtil.logTrace((String)("set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName()));
            emp3.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp3);
            this.getEntityManager().flush();
            this.clearCache();
            TestUtil.logTrace((String)"find employee3 again");
            emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            TestUtil.logTrace((String)("Name:" + emp3.getFirstName() + " " + emp3.getLastName()));
            dept = emp3.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[0].getName())) {
                TestUtil.logTrace((String)("Received expected department:" + dept.getName()));
            } else {
                pass = false;
                if (dept != null) {
                    TestUtil.logErr((String)("Expected department:" + deptRef[0].getName() + ", actual:" + dept.getName()));
                } else {
                    TestUtil.logErr((String)("Expected department:" + deptRef[0].getName() + ", actual:null"));
                }
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            TestUtil.logTrace((String)("Name:" + emp4.getFirstName() + " " + emp4.getLastName()));
            if (emp4.getFirstName() != null) {
                TestUtil.logErr((String)("Expected first name to be null, actual:" + emp4.getFirstName()));
                pass = false;
            }
            if (emp4.getDepartment() != null) {
                TestUtil.logErr((String)("Expected Department to be null, actual:" + emp4.getDepartment().toString()));
                pass = false;
            }
            TestUtil.logTrace((String)("set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName()));
            emp4.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp4);
            this.getEntityManager().flush();
            this.clearCache();
            TestUtil.logTrace((String)"find employee4 again");
            emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            TestUtil.logTrace((String)("Name:" + emp4.getFirstName() + " " + emp4.getLastName()));
            dept = emp4.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[1].getName())) {
                TestUtil.logTrace((String)("Received expected department:" + dept.getName()));
            } else {
                pass = false;
                if (dept != null) {
                    TestUtil.logErr((String)("Expected " + deptRef[1].getName() + " department, actual:" + dept.getName()));
                } else {
                    TestUtil.logErr((String)("Expected " + deptRef[1].getName() + " department, actual:null"));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinColumnUpdatable Failed");
        }
    }

    @SetupMethod(name="setupCreateTestData2")
    public void columnInsertable() throws EETest.Fault {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            TestUtil.logTrace((String)"find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            String firstName = emp2.getFirstName();
            TestUtil.logTrace((String)("Name:" + firstName + " " + emp2.getLastName()));
            if (firstName == null) {
                TestUtil.logTrace((String)"Received expected null firstName");
            } else {
                pass = false;
                TestUtil.logErr((String)("Expected firstName: null, actual:" + firstName));
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            firstName = emp3.getFirstName();
            TestUtil.logTrace((String)("Name:" + firstName + " " + emp3.getLastName()));
            if (firstName != null && firstName.equals("Paul")) {
                TestUtil.logTrace((String)("Received expected firstName:" + firstName));
            } else {
                pass = false;
                TestUtil.logErr((String)"Expected firstName: Paul, actual: null");
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            firstName = emp4.getFirstName();
            TestUtil.logTrace((String)("Name:" + firstName + " " + emp4.getLastName()));
            if (firstName == null) {
                TestUtil.logTrace((String)"Received expected null firstName");
            } else {
                pass = false;
                TestUtil.logErr((String)("Expected firstName: null, actual:" + firstName));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("columnInsertable Failed");
        }
    }

    @SetupMethod(name="setupCreateTestData2")
    public void columnUpdatable() throws EETest.Fault {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            TestUtil.logTrace((String)"find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            TestUtil.logTrace((String)("Name:" + emp2.getFirstName() + " " + emp2.getLastName()));
            TestUtil.logTrace((String)"set firstName and save");
            emp2.setFirstName("foo");
            this.getEntityManager().merge((Object)emp2);
            this.getEntityManager().flush();
            this.clearCache();
            TestUtil.logTrace((String)"find employee2 again");
            emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            TestUtil.logTrace((String)("Name:" + emp2.getFirstName() + " " + emp2.getLastName()));
            String firstName = emp2.getFirstName();
            if (firstName == null) {
                TestUtil.logTrace((String)"Received expected null firstName");
            } else {
                pass = false;
                TestUtil.logErr((String)("Expected firstName: null, actual:" + firstName));
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            TestUtil.logTrace((String)("Name:" + emp3.getFirstName() + " " + emp3.getLastName()));
            TestUtil.logTrace((String)"set firstName and save");
            emp3.setFirstName("foo");
            this.getEntityManager().merge((Object)emp3);
            this.getEntityManager().flush();
            this.clearCache();
            TestUtil.logTrace((String)"find employee3 again");
            emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            TestUtil.logTrace((String)("Name:" + emp3.getFirstName() + " " + emp3.getLastName()));
            firstName = emp3.getFirstName();
            if (firstName != null && firstName.equals("Paul")) {
                TestUtil.logTrace((String)("Received expected firstName:" + firstName));
            } else {
                pass = false;
                TestUtil.logErr((String)"Expected firstName: Paul, actual: null");
            }
            this.clearCache();
            TestUtil.logTrace((String)"--------------");
            TestUtil.logTrace((String)"find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            TestUtil.logTrace((String)("Name:" + emp4.getFirstName() + " " + emp4.getLastName()));
            TestUtil.logTrace((String)"set firstName and save");
            emp4.setFirstName("foo");
            this.getEntityManager().merge((Object)emp4);
            this.getEntityManager().flush();
            this.clearCache();
            TestUtil.logTrace((String)"find employee4 again");
            emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            TestUtil.logTrace((String)("Name:" + emp4.getFirstName() + " " + emp4.getLastName()));
            firstName = emp4.getFirstName();
            if (firstName != null && firstName.equals("foo")) {
                TestUtil.logTrace((String)("Received expected firstName:" + firstName));
            } else {
                pass = false;
                TestUtil.logErr((String)"Expected firstName: foo, actual: null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("columnUpdatable Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestDataCommon() throws Exception {
        try {
            TestUtil.logTrace((String)"createTestDataCommon");
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 2 Departments");
            Client.deptRef[0] = new Department(1, "Marketing");
            Client.deptRef[1] = new Department(2, "Administration");
            TestUtil.logTrace((String)"Start to persist departments ");
            for (Department dept : deptRef) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                TestUtil.logTrace((String)("persisted department " + dept.getName()));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() throws Exception {
        try {
            TestUtil.logTrace((String)"createTestData");
            this.createTestDataCommon();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 5 employees");
            this.empRef[0] = new Employee(1, "Alan", "Frechette");
            this.empRef[0].setDepartment(deptRef[0]);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette");
            this.empRef[1].setDepartment(deptRef[1]);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan");
            this.empRef[2].setDepartment(deptRef[0]);
            this.empRef[3] = new Employee(4, "Robert", "Bissett");
            this.empRef[3].setDepartment(deptRef[1]);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla");
            this.empRef[4].setDepartment(deptRef[0]);
            HashMap<String, Employee> link = new HashMap<String, Employee>();
            link.put(this.empRef[0].getLastName(), this.empRef[0]);
            link.put(this.empRef[2].getLastName(), this.empRef[2]);
            link.put(this.empRef[4].getLastName(), this.empRef[4]);
            deptRef[0].setLastNameEmployees(link);
            HashMap<String, Employee> link1 = new HashMap<String, Employee>();
            link1.put(this.empRef[1].getLastName(), this.empRef[1]);
            link1.put(this.empRef[3].getLastName(), this.empRef[3]);
            deptRef[1].setLastNameEmployees(link1);
            TestUtil.logTrace((String)"Start to persist employees ");
            for (Employee emp : this.empRef) {
                if (emp == null) continue;
                this.getEntityManager().persist((Object)emp);
                TestUtil.logTrace((String)("persisted employee " + emp.getId()));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    public void createTestData2() throws Exception {
        try {
            TestUtil.logTrace((String)"createTestData2");
            this.createTestDataCommon();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create and persist employee2 ");
            this.empRef2 = new Employee2(6, "John", "Smith");
            this.empRef2.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef2);
            TestUtil.logTrace((String)"Create and persist employee3 ");
            this.empRef3 = new Employee3(7, "Paul", "Jones");
            this.empRef3.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef3);
            TestUtil.logTrace((String)"Create and persist employee4 ");
            this.empRef4 = new Employee4(8, "Thomas", "Brady");
            this.empRef4.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef4);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in RemoveSchemaData:", (Throwable)re);
            }
        }
    }
}

