/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler_soap.SOAPMessageContext;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler_soap.SOAPMessageContext.Hello;
import com.sun.ts.tests.jaxrpc.common.HandlerTracker;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;

public class Client
extends ServiceEETest {
    private Service service = null;
    private HandlerRegistry hr = null;
    private HandlerChain hc = null;
    private Properties props = null;
    Hello port = null;
    Service svc = null;

    private void getStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            TestUtil.logMsg((String)"Obtained InitialContext");
            TestUtil.logMsg((String)"Lookup java:comp/env/service/soapmessagecontext");
            this.svc = (Service)ic.lookup("java:comp/env/service/soapmessagecontext");
            TestUtil.logMsg((String)"Obtained service");
            this.port = (Hello)this.svc.getPort(Hello.class);
            TestUtil.logMsg((String)"Obtained port");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.getStub();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void DoSOAPMessageContextTest() throws EETest.Fault {
        TestUtil.logTrace((String)"DoSOAPMessageContextTest");
        boolean pass = true;
        boolean fault = true;
        try {
            TestUtil.logMsg((String)"This is a test to verify the JAXRPC Soap Message Handler Functionality");
            TestUtil.logMsg((String)"Invoking RPC method port.doSOAPMessageContextTest()");
            HandlerTracker.purge();
            String serverSideMsgs = this.port.doSOAPMessageContextTest();
            String clientSideMsgs = HandlerTracker.getMessages3();
            TestUtil.logMsg((String)"-----------------------------------------------");
            TestUtil.logMsg((String)"Dumping Client-Side SOAPMessageContext messages");
            TestUtil.logMsg((String)"-----------------------------------------------");
            TestUtil.logMsg((String)clientSideMsgs);
            TestUtil.logMsg((String)"Verifying Client-Side SOAPMessageContext usage messages");
            if (!this.VerifySOAPMessageContext("client", clientSideMsgs)) {
                TestUtil.logErr((String)"Client-Side SOAPMessageContext usage (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Client-Side SOAPMessageContext usage (correct)");
            }
            TestUtil.logMsg((String)"-----------------------------------------------");
            TestUtil.logMsg((String)"Dumping Server-Side SOAPMessageContext messages");
            TestUtil.logMsg((String)"-----------------------------------------------");
            TestUtil.logMsg((String)serverSideMsgs);
            TestUtil.logMsg((String)"Verifying Server-Side SOAPMessageContext usage");
            if (!this.VerifySOAPMessageContext("server", serverSideMsgs)) {
                TestUtil.logErr((String)"Server-Side SOAPMessageContext usage (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Server-Side SOAPMessageContext usage (correct)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("DoSOAPMessageContextTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("DoSOAPMessageContextTest failed");
        }
    }

    private boolean VerifySOAPMessageContext(String who, String calls) {
        boolean startIdx = false;
        boolean endIdx = false;
        boolean pass = true;
        if (who.equals("client")) {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("SOAPMessageContext.getMessage(ClientHandler1Request)") == -1) {
                TestUtil.logErr((String)"SOAPMessageContext.getMessage(ClientHandler1Request) was not called");
                pass = false;
            }
            if (calls.indexOf("SOAPMessageContext.setMessage(ClientHandler1Request)") == -1) {
                TestUtil.logErr((String)"SOAPMessageContext.setMessage(ClientHandler1Request) was not called");
                pass = false;
            }
            if (calls.indexOf("SOAPMessageContext.getMessage(ClientHandler1Response)") == -1) {
                TestUtil.logErr((String)"SOAPMessageContext.getMessage(ClientHandler1Response) was not called");
                pass = false;
            }
            if (calls.indexOf("SOAPMessageContext.setMessage(ClientHandler1Response)") == -1) {
                TestUtil.logErr((String)"SOAPMessageContext.setMessage(ClientHandler1Response) was not called");
                pass = false;
            }
        } else {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (calls.indexOf("SOAPMessageContext.getMessage(ServerHandler1Request)") == -1) {
                TestUtil.logErr((String)"SOAPMessageContext.getMessage(ServerHandler1Request) was not called");
                pass = false;
            }
            if (calls.indexOf("SOAPMessageContext.setMessage(ServerHandler1Request)") == -1) {
                TestUtil.logErr((String)"SOAPMessageContext.setMessage(ServerHandler1Request) was not called");
                pass = false;
            }
        }
        return pass;
    }
}

