/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.detach.oneXone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.detach.oneXone.A;
import com.sun.ts.tests.jpa.core.entitytest.detach.oneXone.B;
import java.util.Properties;
import javax.persistence.EntityExistsException;
import javax.persistence.PersistenceException;
import javax.transaction.TransactionRolledbackException;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering Setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach1X1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin detach1X1Test1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Call contains to determine if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                TestUtil.logTrace((String)"entity is not detached, cannot proceed with test.");
                pass = false;
            } else {
                try {
                    TestUtil.logTrace((String)"Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"IllegalArgumentException thrown trying to persist a detached entity", (Throwable)iae);
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    TestUtil.logTrace((String)"entityExistsException thrown trying to persist an existing entity", (Throwable)eee);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"or, Transaction commit will fail. Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("detach1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach1X1Test2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin detach1X1Test2");
        boolean pass = false;
        A a1 = new A("2", "a2", 2);
        B bRef = new B("2", "a2", 2, a1);
        try {
            TestUtil.logTrace((String)"Persist B");
            this.createB(bRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getEntityManager().contains((Object)bRef)) {
                TestUtil.logTrace((String)"contains method returned true; unexpected, test fails.");
                pass = false;
            } else {
                try {
                    TestUtil.logTrace((String)"Status is false as expected, try remove");
                    this.getEntityManager().remove((Object)bRef);
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"IllegalArgumentException caught as expected  trying to remove a detached entity", (Throwable)iae);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"or, Transaction commit will fail.   Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("detach1X1Test2 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private void createB(B b) {
        TestUtil.logTrace((String)"Entered createB method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)b);
        this.getEntityTransaction().commit();
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

