/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.j2w.simpletest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.j2w.simpletest.Hello;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.j2w.simpletest.";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String NAMESPACEURI = "http://simpletestservice.org/wsdl";
    private static final String SERVICENAMEPROP = "j2wsimpletest.servicename.1";
    private static final String PORTNAMEPROP = "j2wsimpletest.portname.1";
    private String SERVICE_NAME;
    private String PORT_NAME;
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    String modeProperty = null;
    private static final String ENDPOINT_URL = "j2wsimpletest.endpoint.1";
    private static final String WSDLLOC_URL = "j2wsimpletest.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    private static final String DIIENDPOINT_URL = "j2wst.endpoint.1";
    Hello port = null;
    Stub stub = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubStandalone() throws Exception {
        this.port = (Hello)JAXRPC_Util.getStub(PKG_NAME + this.SERVICE_NAME, "get" + this.PORT_NAME);
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getDIITestURLs() throws Exception {
        TestUtil.logMsg((String)"Get JAXRPC porting instance");
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(DIIENDPOINT_URL);
        this.url = new TSURL().getURLString(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
    }

    private void getStub() throws Exception {
        InitialContext ctx = new InitialContext();
        Service svc = (Service)ctx.lookup("java:comp/env/service/j2wsimpletest1");
        TestUtil.logMsg((String)"Get stub from generic Service instance");
        this.port = (Hello)svc.getPort(Hello.class);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.SERVICE_NAME = JAXRPC_Util.getURLFromProp(SERVICENAMEPROP);
                this.PORT_NAME = JAXRPC_Util.getURLFromProp(PORTNAMEPROP);
                this.getTestURLs();
                this.getStubStandalone();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            } else {
                this.SERVICE_NAME = "SimpleTestService";
                this.PORT_NAME = "HelloPort";
                this.getStub();
                this.getDIITestURLs();
            }
            this.SERVICE_QNAME = new QName(NAMESPACEURI, this.SERVICE_NAME);
            this.PORT_QNAME = new QName(NAMESPACEURI, this.PORT_NAME);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void InvokeRPCViaStubTest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaStubTest");
        boolean pass = true;
        String singleLineExpected = "Hello, foo!";
        String multiLineExpected = "Hello, bar\nand\nGoodbye!";
        try {
            TestUtil.logMsg((String)("Invoking RPC method port.hello(\"foo\") and expect '" + singleLineExpected + "' ..."));
            String response = this.port.hello("foo");
            if (!response.equals(singleLineExpected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + singleLineExpected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
            TestUtil.logMsg((String)("Invoking RPC method port.hello(\"bar\nand\nGoodbye!\") and expect '" + multiLineExpected + "' ..."));
            response = this.port.hello("bar\nand\nGoodbye");
            if (!response.equals(multiLineExpected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + multiLineExpected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaStubTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaStubTest failed");
        }
    }

    public void InvokeRPCViaDIITest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaDIITest");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                InitialContext ctx = new InitialContext();
                service = (Service)ctx.lookup("java:comp/env/service/j2wsimpletest2");
            }
            Call call = service.createCall();
            call = JAXRPC_Util.setCallProperties(call, " ");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            call.setPortTypeName(this.PORT_QNAME);
            call.setTargetEndpointAddress(this.url);
            call.setOperationName(new QName(NAMESPACEURI, "hello"));
            boolean b = call.isParameterAndReturnSpecRequired(new QName(NAMESPACEURI, "hello"));
            if (b) {
                call.addParameter("String_1", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                call.setReturnType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            }
            Object[] params = new String[]{new String("foo")};
            TestUtil.logMsg((String)("Invoking RPC method hello(\"foo\") and expect '" + expected + "' ..."));
            String response = (String)call.invoke(params);
            if (!response.equals(expected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaDIITest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaDIITest failed");
        }
    }

    public void InvokeRPCViaDIIOneWayTest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaDIIOneWayTest");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                InitialContext ctx = new InitialContext();
                service = (Service)ctx.lookup("java:comp/env/service/j2wsimpletest2");
            }
            Call call = service.createCall();
            call = JAXRPC_Util.setCallProperties(call, " ");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            call.setPortTypeName(this.PORT_QNAME);
            call.setTargetEndpointAddress(this.url);
            call.setOperationName(new QName(NAMESPACEURI, "helloOneWay"));
            boolean b = call.isParameterAndReturnSpecRequired(new QName(NAMESPACEURI, "helloOneWay"));
            if (b) {
                call.addParameter("String_1", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
            }
            Object[] params = new String[]{new String("foo")};
            TestUtil.logMsg((String)"Invoking RPC method helloOneWay(\"foo\") ...");
            call.invokeOneWay(params);
            TestUtil.logMsg((String)"RPC passed - invokeOneWay call successful");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaDIIOneWayTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaDIIOneWayTest failed");
        }
    }

    public void InvokeRPCViaDynProxyTest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaDynProxyTest");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                InitialContext ctx = new InitialContext();
                service = (Service)ctx.lookup("java:comp/env/service/j2wsimpletest1");
            }
            Hello hello = (Hello)service.getPort(this.PORT_QNAME, Hello.class);
            if (hello != null) {
                TestUtil.logMsg((String)("Hello dynproxy = " + hello));
            }
            TestUtil.logMsg((String)("Invoking RPC method hello(\"foo\") and expect '" + expected + "' ..."));
            if (hello != null) {
                String response = hello.hello("foo");
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            } else {
                TestUtil.logErr((String)"RPC failed - proxy object returned was null");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaDynProxyTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaDynProxyTest failed");
        }
    }
}

