/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.BadOrderFault;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.ConfigFault;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.ConfigHeader;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.CustomerInfo;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.HeaderTest;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.ProductOrderItem;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.ProductOrderRequest;
import com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.ProductOrderResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "wsirlheadertest.endpoint.1";
    private static final String WSDLLOC_URL = "wsirlheadertest.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    HeaderTest port = null;
    Stub stub = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubStandalone() throws Exception {
        TestUtil.logMsg((String)"Get stub from service implementation class using JAXRPC porting instance");
        this.port = (HeaderTest)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest.HeaderTestService", "getHeaderTestPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        TestUtil.logMsg((String)"JNDI lookup for Service1");
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"Lookup java:comp/env/service/wsirlheadertest");
        Service svc = (Service)ctx.lookup("java:comp/env/service/wsirlheadertest");
        TestUtil.logMsg((String)"Get port from Service");
        this.port = (HeaderTest)svc.getPort(HeaderTest.class);
        TestUtil.logMsg((String)"Port obtained");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubStandalone();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
                JAXRPC_Util.setSOAPLogging(this.stub, System.out);
            } else {
                this.getStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void GoodOrderTestWithSoapHeaderAndMUFalse() throws EETest.Fault {
        TestUtil.logMsg((String)"GoodOrderTestWithSoapHeaderAndMUFalse");
        boolean pass = true;
        ProductOrderRequest poRequest = new ProductOrderRequest();
        ProductOrderItem[] poiArray = new ProductOrderItem[1];
        ProductOrderItem poi = new ProductOrderItem();
        poi.setProductName("Product-1");
        poi.setProductCode(new BigInteger("100"));
        poi.setQuantity(10);
        poi.setPrice(new BigDecimal(119.0));
        poiArray[0] = poi;
        CustomerInfo ci = new CustomerInfo();
        ci.setCreditcard("1201-4465-1567-9823");
        ci.setName("John Doe");
        ci.setStreet("1 Network Drive");
        ci.setCity("Burlington");
        ci.setState("Ma");
        ci.setZip("01837");
        ci.setCountry("USA");
        poRequest.setItem(poiArray);
        poRequest.setCustomerInfo(ci);
        ConfigHeader ch = new ConfigHeader();
        ch.setMustUnderstand(false);
        ch.setMessage("Config Header");
        ch.setTestName("GoodOrderTestWithSoapHeaderAndMUFalse");
        try {
            TestUtil.logMsg((String)"Submit good order with soap header (ConfigHeader:MU=false)");
            TestUtil.logMsg((String)"ConfigHeader must be ignored because MU=false");
            TestUtil.logMsg((String)"The service endpoint simply ignores the soap header");
            TestUtil.logMsg((String)"The RPC request must succeed");
            ProductOrderResponse poResponse = this.port.submitOrder(poRequest, ch);
            if (!this.ProductOrdersEqual(poRequest, poResponse)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GoodOrderTestWithSoapHeaderAndMUFalse failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GoodOrderTestWithSoapHeaderAndMUFalse failed");
        }
    }

    public void GoodOrderTestWithSoapHeaderAndMUTrue() throws EETest.Fault {
        TestUtil.logMsg((String)"GoodOrderTestWithSoapHeaderAndMUTrue");
        boolean pass = true;
        ProductOrderRequest poRequest = new ProductOrderRequest();
        ProductOrderItem[] poiArray = new ProductOrderItem[1];
        ProductOrderItem poi = new ProductOrderItem();
        poi.setProductName("Product-1");
        poi.setProductCode(new BigInteger("100"));
        poi.setQuantity(10);
        poi.setPrice(new BigDecimal(119.0));
        poiArray[0] = poi;
        CustomerInfo ci = new CustomerInfo();
        ci.setCreditcard("1201-4465-1567-9823");
        ci.setName("John Doe");
        ci.setStreet("1 Network Drive");
        ci.setCity("Burlington");
        ci.setState("Ma");
        ci.setZip("01837");
        ci.setCountry("USA");
        poRequest.setItem(poiArray);
        poRequest.setCustomerInfo(ci);
        ConfigHeader ch = new ConfigHeader();
        ch.setMustUnderstand(true);
        ch.setMessage("Config Header");
        ch.setTestName("GoodOrderTestWithSoapHeaderAndMUTrue");
        try {
            TestUtil.logMsg((String)"Submit good order with soap header (ConfigHeader:MU=true)");
            TestUtil.logMsg((String)"ConfigHeader must be understood and valid bacause MU=true");
            TestUtil.logMsg((String)"The service endpoint understands and validates the soap header as ok");
            TestUtil.logMsg((String)"The RPC request must succeed");
            ProductOrderResponse poResponse = this.port.submitOrder(poRequest, ch);
            TestUtil.logMsg((String)"GoodOrderTestWithMUTrueHeader succeeded (expected)");
            if (!this.ProductOrdersEqual(poRequest, poResponse)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GoodOrderTestWithSoapHeaderAndMUTrue failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GoodOrderTestWithSoapHeaderAndMUTrue failed");
        }
    }

    public void SoapHeaderFaultTest() throws EETest.Fault {
        TestUtil.logMsg((String)"SoapHeaderFaultTest");
        boolean pass = true;
        ProductOrderRequest poRequest = new ProductOrderRequest();
        ProductOrderItem[] poiArray = new ProductOrderItem[1];
        ProductOrderItem poi = new ProductOrderItem();
        poi.setProductName("Product-1");
        poi.setProductCode(new BigInteger("100"));
        poi.setQuantity(10);
        poi.setPrice(new BigDecimal(119.0));
        poiArray[0] = poi;
        CustomerInfo ci = new CustomerInfo();
        ci.setCreditcard("1201-4465-1567-9823");
        ci.setName("John Doe");
        ci.setStreet("1 Network Drive");
        ci.setCity("Burlington");
        ci.setState("Ma");
        ci.setZip("01837");
        ci.setCountry("USA");
        poRequest.setItem(poiArray);
        poRequest.setCustomerInfo(ci);
        ConfigHeader ch = new ConfigHeader();
        ch.setMustUnderstand(true);
        ch.setMessage("Config Header");
        ch.setTestName("SoapHeaderFaultTest");
        try {
            TestUtil.logMsg((String)"Submit good order with soap header (ConfigHeader:MU=true)");
            TestUtil.logMsg((String)"ConfigHeader must be understood and valid bacause MU=true");
            TestUtil.logMsg((String)"The service endpoint does not understand the soap header");
            TestUtil.logMsg((String)"The RPC request must fail with a ConfigFault");
            ProductOrderResponse poResponse = this.port.submitOrder(poRequest, ch);
            TestUtil.logErr((String)"Did not throw expected ConfigFault");
            pass = false;
        }
        catch (ConfigFault e) {
            TestUtil.logMsg((String)"Caught expected ConfigFault");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SoapHeaderFaultTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SoapHeaderFaultTest failed");
        }
    }

    public void SoapFaultTest() throws EETest.Fault {
        TestUtil.logMsg((String)"SoapFaultTest");
        boolean pass = true;
        ProductOrderRequest poRequest = new ProductOrderRequest();
        ProductOrderItem[] poiArray = new ProductOrderItem[1];
        ProductOrderItem poi = new ProductOrderItem();
        poi.setProductName("Product-1");
        poi.setProductCode(new BigInteger("1234123412341234"));
        poi.setQuantity(10);
        poi.setPrice(new BigDecimal(119.0));
        poiArray[0] = poi;
        CustomerInfo ci = new CustomerInfo();
        ci.setCreditcard("1201-4465-1567-9823");
        ci.setName("John Doe");
        ci.setStreet("1 Network Drive");
        ci.setCity("Burlington");
        ci.setState("Ma");
        ci.setZip("01837");
        ci.setCountry("USA");
        poRequest.setItem(poiArray);
        poRequest.setCustomerInfo(ci);
        ConfigHeader ch = new ConfigHeader();
        ch.setMustUnderstand(false);
        ch.setMessage("Config Header");
        ch.setTestName("SoapFaultTest");
        try {
            TestUtil.logMsg((String)"Submit bad order with soap header (ConfigHeader:MU=false)");
            TestUtil.logMsg((String)"ConfigHeader must be ignored because MU=false");
            TestUtil.logMsg((String)"The service endpoint simply ignores the soap header");
            TestUtil.logMsg((String)"Order contains bad product code (must throw BadOrderFault)");
            TestUtil.logMsg((String)"The RPC request must fail with a BadOrderFault");
            ProductOrderResponse poResponse = this.port.submitOrder(poRequest, ch);
            TestUtil.logErr((String)"Did not throw expected BadOrderFault");
            pass = false;
        }
        catch (BadOrderFault e) {
            TestUtil.logMsg((String)"Caught expected BadOrderFault");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SoapFaultTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SoapFaultTest failed");
        }
    }

    private boolean ProductOrdersEqual(ProductOrderRequest req, ProductOrderResponse resp) {
        boolean equal = true;
        TestUtil.logMsg((String)"Performing data comparison of request/response (should be equal)");
        ProductOrderItem[] reqArray = req.getItem();
        ProductOrderItem[] respArray = resp.getItem();
        ProductOrderItem reqItem = null;
        ProductOrderItem respItem = null;
        if (reqArray == null || respArray == null) {
            TestUtil.logErr((String)"Data comparison error (unexpected)");
            TestUtil.logErr((String)("Got:      Item Array = " + respItem));
            TestUtil.logErr((String)("Expected: Item Array = " + reqItem));
            equal = false;
        } else if (reqArray.length != respArray.length) {
            TestUtil.logErr((String)"Data comparison error (unexpected)");
            TestUtil.logErr((String)("Got:      Item Array length = " + respArray.length));
            TestUtil.logErr((String)("Expected: Item Array length = " + reqArray.length));
            equal = false;
        } else {
            reqItem = reqArray[0];
            respItem = respArray[0];
        }
        if (equal) {
            if (!(reqItem.getProductName().equals(respItem.getProductName()) && reqItem.getProductCode().equals(respItem.getProductCode()) && reqItem.getQuantity() == respItem.getQuantity() && reqItem.getPrice().equals(respItem.getPrice()))) {
                TestUtil.logErr((String)"Data comparison error (unexpected)");
                TestUtil.logErr((String)("Got:      <" + respItem.getProductName() + "," + respItem.getProductCode() + "," + respItem.getQuantity() + "," + respItem.getPrice() + ">"));
                TestUtil.logErr((String)("Expected: <" + reqItem.getProductName() + "," + reqItem.getProductCode() + "," + reqItem.getQuantity() + "," + reqItem.getPrice() + ">"));
                equal = false;
            } else {
                TestUtil.logMsg((String)"Data comparison ok (expected)");
                TestUtil.logMsg((String)("Got:      <" + respItem.getProductName() + "," + respItem.getProductCode() + "," + respItem.getQuantity() + "," + respItem.getPrice() + ">"));
                TestUtil.logMsg((String)("Expected: <" + reqItem.getProductName() + "," + reqItem.getProductCode() + "," + reqItem.getQuantity() + "," + reqItem.getPrice() + ">"));
            }
        }
        return equal;
    }
}

