/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.stateless.common;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.stateless.common.SecTestLocal;
import com.sun.ts.tests.ejb.ee.sec.stateless.common.SecTestLocalHome;
import com.sun.ts.tests.ejb.ee.sec.stateless.common.SecTestRoleRefLocal;
import com.sun.ts.tests.ejb.ee.sec.stateless.common.SecTestRoleRefLocalHome;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class lTestEJB
implements SessionBean {
    private static final String ejb1name = "java:comp/env/ejb/SecTestLocal";
    private static final String ejb2name = "java:comp/env/ejb/SecTestRoleRefLocal";
    private SecTestLocalHome ejb1home = null;
    private SecTestLocal ejb1ref = null;
    private SecTestRoleRefLocalHome ejb2home = null;
    private SecTestRoleRefLocal ejb2ref = null;
    private SessionContext sctx = null;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private TSNamingContext nctx = null;

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
    }

    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"TestEJB initLogging failed.");
            throw new EJBException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        this.sctx = sc;
        try {
            this.nctx = new TSNamingContext();
            this.ejb1home = (SecTestLocalHome)this.nctx.lookup(ejb1name);
            this.ejb2home = (SecTestRoleRefLocalHome)this.nctx.lookup(ejb2name);
            TestUtil.logMsg((String)"setSessionContext in TestEJB");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in Setup: ", (Throwable)e);
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public boolean IsCallerB1(String caller) {
        String name = this.sctx.getCallerPrincipal().getName();
        TestUtil.logMsg((String)("IsCallerB1: " + name));
        return name.indexOf(caller) >= 0;
    }

    public boolean IsCallerB2(String caller, Properties p) {
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.IsCaller(caller);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean InRole(String role, Properties p) {
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbNotAuthz(Properties p) {
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            this.ejb1ref.EjbNotAuthz();
            TestUtil.logErr((String)"Method call did not generate an expected java.rmi.RemoteException");
            this.ejb1ref.remove();
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught javax.ejb.EJBException as expected");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    private void cleanup(SecTestLocal ejbref) {
        if (ejbref != null) {
            try {
                ejbref.remove();
                ejbref = null;
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Cannot remove the bean: ", (Throwable)ex);
            }
        } else {
            TestUtil.logMsg((String)"ejbref == null");
        }
    }

    public boolean EjbIsAuthz(Properties p) {
        TestUtil.logMsg((String)"Starting Caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.EjbIsAuthz();
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean EjbSecRoleRef(String role, Properties p) {
        TestUtil.logMsg((String)"Starting Security role reference positive test");
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRef1(String role, Properties p) {
        TestUtil.logMsg((String)"Starting Security role reference negative test");
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRefScope(String role, Properties p) {
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
            this.ejb2ref = this.ejb2home.create();
            this.ejb2ref.initLogging(p);
            result = this.ejb2ref.EjbSecRoleRefScope(role);
            this.ejb2ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbOverloadedSecRoleRefs(String role1, String role2, Properties p) {
        TestUtil.logMsg((String)"Starting Overloaded security role references test");
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1);
            this.ejb1ref.remove();
            if (!result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref) returned false");
                return false;
            }
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1, role2);
            this.ejb1ref.remove();
            if (result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref,mgr_secrole_ref) returned true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("EjbOverloadedSecRoleRefs(" + role1 + "," + role2 + ") failed with Exception: "), (Throwable)e);
            return false;
        }
    }

    public boolean checktest1(Properties p) {
        try {
            this.ejb1ref = this.ejb1home.create();
            this.ejb1ref.initLogging(p);
            boolean result = this.ejb1ref.checktest1();
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean excludetest1(Properties p) {
        try {
            this.ejb1ref = this.ejb1home.create();
            boolean result = this.ejb1ref.excludetest1();
            this.ejb1ref.remove();
            TestUtil.logTrace((String)"Should not be here.");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logTrace((String)"Got expected EJBException");
            return true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Got wrong Exception in excludetest1:", (Throwable)ex);
            return false;
        }
    }
}

