/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.exceptionerrortest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.exceptionerrortest.MyApplicationException;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.exceptionerrortest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.exceptionerrortest.TestBeanHome;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.CreateException;

public class Client
extends EETest {
    private static final String testName = "ExceptionlogErrorTest";
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final String testProps = "exceptionerrortest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, false);
            try {
                this.beanRef.throwMyApplicationException();
                TestUtil.logErr((String)"no MyApplicationException occurred");
                pass = false;
            }
            catch (MyApplicationException e) {
                TestUtil.logMsg((String)("MyApplicationException received as expected " + e));
                if (!e.getMessage().equals("an application exception")) {
                    pass = false;
                    TestUtil.logErr((String)"application exception message not same");
                } else {
                    TestUtil.logMsg((String)"application exception message same");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
        TestUtil.logMsg((String)"test1 passed");
    }

    public void test2() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, false);
            try {
                this.beanRef.throwEJBException();
                TestUtil.logErr((String)"no RemoteException occurred - unexpected");
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)("RemoteException received as expected " + e));
            }
            catch (Exception e) {
                TestUtil.logErr((String)("unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"Check to make sure instance was discarded");
            try {
                this.beanRef.remove();
                TestUtil.logMsg((String)"instance not discarded - unexpected");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                TestUtil.logMsg((String)"instance discarded - expected");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
        TestUtil.logMsg((String)"test2 passed");
    }

    public void test4() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create EJB instance");
            try {
                this.beanRef = this.beanHome.create(this.props, true);
                TestUtil.logErr((String)"no CreateException occurred");
                pass = false;
            }
            catch (CreateException e) {
                TestUtil.logMsg((String)("CreateException received as expected " + (Object)((Object)e)));
                if (!e.getMessage().equals("a create exception")) {
                    pass = false;
                    TestUtil.logErr((String)"create exception message not same");
                } else {
                    TestUtil.logErr((String)"create exception message same");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"Check to make sure instance not created");
            if (this.beanRef != null) {
                TestUtil.logErr((String)"bean reference is not null - unexpected");
                pass = false;
                try {
                    this.beanRef.remove();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"bean reference is null - expected");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
        TestUtil.logMsg((String)"test4 passed");
    }

    public void test5() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, false);
            try {
                this.beanRef.throwEJBException();
                TestUtil.logErr((String)"no RemoteException occurred - unexpected");
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)("RemoteException received as expected " + e));
            }
            catch (Exception e) {
                TestUtil.logErr((String)("unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"Check to make sure instance was discarded");
            try {
                this.beanRef.remove();
                TestUtil.logMsg((String)"instance not discarded - unexpected");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                TestUtil.logMsg((String)"instance discarded - expected");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
        TestUtil.logMsg((String)"test5 passed");
    }

    public void test6() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, false);
            try {
                this.beanRef.throwError();
                TestUtil.logErr((String)"no RemoteException occurred - unexpected");
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)("RemoteException received as expected " + e));
            }
            catch (Exception e) {
                TestUtil.logErr((String)("unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"Check to make sure instance was discarded");
            try {
                this.beanRef.remove();
                TestUtil.logMsg((String)"instance not discarded - unexpected");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                TestUtil.logMsg((String)"instance discarded - expected");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test6 failed");
        }
        TestUtil.logMsg((String)"test6 passed");
    }

    public void cleanup() throws EETest.Fault {
        this.beanRef = null;
        TestUtil.logMsg((String)"cleanup ok");
    }
}

