/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.messaging;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.messaging.Constants;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class StatusReporter
implements Constants {
    private static StatusReporter reporter = new StatusReporter();

    private static StatusReporter getInstance() {
        return reporter;
    }

    public static void report(String testname, boolean result, String reason, QueueConnectionFactory qFactory, Queue replyQueue) {
        StatusReporter reporter = StatusReporter.getInstance();
        reporter.report0(testname, result, reason, qFactory, replyQueue);
    }

    public static void report(String testname, boolean result, QueueConnectionFactory qFactory, Queue queueR) {
    }

    private void report0(String testname, boolean result, String reason, QueueConnectionFactory qFactory, Queue queueR) {
        QueueConnection qConnection = null;
        QueueSession qSession = null;
        try {
            qConnection = qFactory.createQueueConnection();
            qSession = qConnection.createQueueSession(false, 1);
            StatusReporter.sendTestResults(testname, result, reason, qSession, queueR);
        }
        catch (JMSException e) {
            String description = null;
            description = result ? "The test " + testname + " passed in the bean." : "The test " + testname + " failed in the bean: " + reason;
            throw new IllegalStateException(description + " Failed to create connection/session in StatusReporter:", e);
        }
        finally {
            if (qConnection != null) {
                try {
                    qConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void sendTestResults(String testCase, boolean results, String reason, QueueSession qSession, Queue queueR) {
        TextMessage msg = null;
        QueueSender mSender = null;
        try {
            mSender = qSession.createSender(queueR);
            msg = qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            mSender.send((Message)msg);
            TLogger.log("Status message (" + results + ") sent for test " + testCase + ". Reason:" + reason);
        }
        catch (JMSException e) {
            TLogger.log("Failed to send back status:", e);
        }
        catch (Exception e) {
            TLogger.log("Failed to send back status:", e);
        }
    }
}

