/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.detach.basic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.detach.basic.A;
import java.util.Properties;
import javax.persistence.PersistenceException;
import javax.transaction.TransactionRolledbackException;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachBasicTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin detachBasicTest1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"tx started, see if entity is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                TestUtil.logErr((String)"contains method returned true; expected false (detached), test fails.");
                pass = false;
            } else {
                try {
                    TestUtil.logTrace((String)"try remove");
                    this.getEntityManager().remove((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"IllegalArgumentException caught as expected", (Throwable)iae);
                    pass = true;
                }
            }
            TestUtil.logTrace((String)"tx commit");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass) {
                if (e instanceof TransactionRolledbackException || e instanceof PersistenceException) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Not TransactionRolledbackException nor PersistenceException, totally unexpected:", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("detachBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachBasicTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin detachBasicTest2");
        boolean pass = false;
        A expected = new A("1", "a1", 1);
        try {
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(new A("1", "a1", 1));
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Executing find");
            A newA = (A)this.getEntityManager().find(A.class, (Object)"1");
            TestUtil.logTrace((String)("newA:" + newA.toString()));
            TestUtil.logTrace((String)"changing name");
            newA.setAName("foobar");
            TestUtil.logTrace((String)("newA:" + newA.toString()));
            TestUtil.logTrace((String)"executing detach");
            this.getEntityManager().detach((Object)newA);
            TestUtil.logTrace((String)("newA:" + newA.toString()));
            TestUtil.logTrace((String)"tx commit");
            this.getEntityTransaction().commit();
            A newAA = (A)this.getEntityManager().find(A.class, (Object)"1");
            TestUtil.logTrace((String)("newAA:" + newAA.toString()));
            if (expected.equals((Object)newAA)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Changes made to entity were persisted even though it was detached without a flush");
                TestUtil.logErr((String)("expected A:" + expected.toString() + ", actual A:" + newAA.toString()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("detachBasicTest2 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

