/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateless.sessionbeantest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class TestBeanEJB
implements SessionBean {
    private SessionContext sctx = null;
    private boolean ejbNewInstanceFlag = false;
    private boolean ejbSessionContextFlag = false;
    private boolean ejbCreateFlag = false;
    private boolean createLifeCycleFlag = true;

    public TestBeanEJB() {
        TestUtil.logTrace((String)"newInstance => default constructor called");
        this.ejbNewInstanceFlag = true;
        if (this.ejbSessionContextFlag || this.ejbCreateFlag) {
            this.createLifeCycleFlag = false;
        }
        if (this.ejbSessionContextFlag) {
            TestUtil.logErr((String)"newInstance() not called before setSessionContext()");
        }
        if (this.ejbCreateFlag) {
            TestUtil.logErr((String)"newInstance() not called before ejbCreate()");
        }
    }

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.ejbCreateFlag = true;
        if (!this.ejbNewInstanceFlag || !this.ejbSessionContextFlag) {
            this.createLifeCycleFlag = false;
        }
        if (!this.ejbNewInstanceFlag) {
            TestUtil.logErr((String)"newInstance() not called before ejbCreate()");
        }
        if (!this.ejbSessionContextFlag) {
            TestUtil.logErr((String)"setSessionContext() not called before ejbCreate()");
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
        this.ejbSessionContextFlag = true;
        if (!this.ejbNewInstanceFlag || this.ejbCreateFlag) {
            this.createLifeCycleFlag = false;
        }
        if (!this.ejbNewInstanceFlag) {
            TestUtil.logErr((String)"newInstance() not called before setSessionContext()");
        }
        if (this.ejbCreateFlag) {
            TestUtil.logErr((String)"ejbCreate() called before setSessionContext()");
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
        this.reset();
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ping() {
        TestUtil.logTrace((String)"ping");
    }

    public boolean isCreateLifeCycle() {
        TestUtil.logTrace((String)"isCreateLifeCycle");
        boolean status = this.createLifeCycleFlag;
        this.reset();
        return status;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void reset() {
        this.ejbSessionContextFlag = false;
        this.ejbCreateFlag = false;
        this.createLifeCycleFlag = true;
    }
}

