/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.HandlerInfo;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.ClientHandler1;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;

public class Client
extends ServiceEETest {
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void HandlerInfoConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"HandlerInfoConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo() ...");
            HandlerInfo hi = new HandlerInfo();
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("HandlerInfoConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("HandlerInfoConstructorTest1 failed");
        }
    }

    public void HandlerInfoConstructorTest2a() throws EETest.Fault {
        TestUtil.logTrace((String)"HandlerInfoConstructorTest2a");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo(Class, Map, QName[]) ...");
            HandlerInfo hi = new HandlerInfo(ClientHandler1.class, null, null);
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("HandlerInfoConstructorTest2a failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("HandlerInfoConstructorTest2a failed");
        }
    }

    public void HandlerInfoConstructorTest2b() throws EETest.Fault {
        TestUtil.logTrace((String)"HandlerInfoConstructorTest2b");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo(Class, Map, QName[]) ...");
            QName[] headers = new QName[10];
            for (int i = 0; i < headers.length; ++i) {
                headers[i] = new QName("This is header #" + i);
            }
            Hashtable map = new Hashtable();
            HandlerInfo hi = new HandlerInfo(ClientHandler1.class, map, headers);
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("HandlerInfoConstructorTest2b failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("HandlerInfoConstructorTest2b failed");
        }
    }

    public void SetGetHandlerClassTest() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetHandlerClassTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo() ...");
            HandlerInfo hi = new HandlerInfo();
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"Set the Handler class");
                TestUtil.logMsg((String)"Call HandleInfo.setHandlerClass()");
                hi.setHandlerClass(ClientHandler1.class);
                TestUtil.logMsg((String)"Get the Handler class");
                TestUtil.logMsg((String)"Call HandleInfo.getHandlerClass()");
                Object o = Class.forName("com.sun.ts.tests.jaxrpc.common.ClientHandler1").newInstance();
                Class c = hi.getHandlerClass();
                TestUtil.logMsg((String)("Handler class = " + c));
                if (c.isInstance(o)) {
                    TestUtil.logMsg((String)"Returned correct Handler class");
                } else {
                    TestUtil.logErr((String)"Returned incorrect Handler class");
                    TestUtil.logErr((String)("Expected: " + o));
                    TestUtil.logErr((String)("Received: " + c));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetHandlerClassTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetHandlerClassTest failed");
        }
    }

    public void GetHandlerClassNegativeTest() throws EETest.Fault {
        TestUtil.logTrace((String)"GetHandlerClassNegativeTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo() ...");
            HandlerInfo hi = new HandlerInfo();
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"Do not set a Handler class");
                TestUtil.logMsg((String)"Get the Handler class (should return null)");
                TestUtil.logMsg((String)"Call HandleInfo.getHandlerClass()");
                Class c = hi.getHandlerClass();
                if (c != null) {
                    TestUtil.logErr((String)"Did not return expected null");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetHandlerClassNegativeTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetHandlerClassNegativeTest failed");
        }
    }

    public void SetGetHeadersTest() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetHeadersTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo() ...");
            HandlerInfo hi = new HandlerInfo();
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"Set the Header blocks for this Handler");
                QName[] headers1 = new QName[10];
                for (int i = 0; i < headers1.length; ++i) {
                    headers1[i] = new QName("This is header #" + i);
                }
                TestUtil.logMsg((String)"Call HandleInfo.setHeaders()");
                hi.setHeaders(headers1);
                TestUtil.logMsg((String)"Get the Header blocks for this Handler");
                TestUtil.logMsg((String)"Call HandleInfo.getHeaders()");
                QName[] headers2 = hi.getHeaders();
                if (headers1.length != headers2.length) {
                    TestUtil.logErr((String)("Returned incorrect count of headers:  expected " + headers1.length + ", received " + headers2.length));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("headers1.length=" + headers1.length + ", headers2.length=" + headers2.length));
                    TestUtil.logMsg((String)"Check that contents of headers are equal");
                    for (int i = 0; i < headers1.length; ++i) {
                        if (headers1[i].equals(headers2[i])) continue;
                        TestUtil.logErr((String)("headers1[" + i + "]=" + headers1[i] + ", headers2[" + i + "]=" + headers2[i]));
                        pass = false;
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetHeadersTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetHeadersTest failed");
        }
    }

    public void SetGetHandlerConfigTest() throws EETest.Fault {
        TestUtil.logTrace((String)"SetGetHandlerConfigTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo() ...");
            HandlerInfo hi = new HandlerInfo();
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"Set the Handler configuration");
                Hashtable<String, String> map1 = new Hashtable<String, String>();
                map1.put("Key1", "Value1");
                TestUtil.logMsg((String)"Call HandleInfo.setHandlerConfig()");
                hi.setHandlerConfig(map1);
                TestUtil.logMsg((String)"Get the Handler configuration");
                TestUtil.logMsg((String)"Call HandleInfo.getHandlerConfig()");
                Map map2 = hi.getHandlerConfig();
                if (map1.size() != map2.size()) {
                    TestUtil.logErr((String)("Returned incorrect map size:  expected " + map1.size() + ", received " + map2.size()));
                    pass = false;
                } else {
                    if (!map2.containsKey("Key1")) {
                        TestUtil.logErr((String)"Map2 does not contain key: Key1");
                        pass = false;
                    }
                    if (!map2.containsValue("Value1")) {
                        TestUtil.logErr((String)"Map2 does not contain value: Value1");
                        pass = false;
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SetGetHandlerConfigTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SetGetHandlerConfigTest failed");
        }
    }

    public void GetHandlerConfigNegativeTest() throws EETest.Fault {
        TestUtil.logTrace((String)"GetHandlerConfigNegativeTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via HandlerInfo() ...");
            HandlerInfo hi = new HandlerInfo();
            if (hi != null) {
                TestUtil.logMsg((String)"HandlerInfo object created successfully");
            } else {
                TestUtil.logErr((String)"HandlerInfo object not created");
                pass = false;
            }
            if (pass) {
                TestUtil.logMsg((String)"Do not set a Handler configuration");
                TestUtil.logMsg((String)"Get the Handler configuration (should return null)");
                TestUtil.logMsg((String)"Call HandleInfo.getHandlerConfig()");
                Map map = hi.getHandlerConfig();
                if (!map.isEmpty()) {
                    TestUtil.logErr((String)"Did not return expected empty Map");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetHandlerConfigNegativeTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetHandlerConfigNegativeTest failed");
        }
    }
}

