/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.common;

import com.sun.ts.lib.util.TestUtil;
import java.io.FileInputStream;
import java.net.PasswordAuthentication;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public final class JAXR_Util {
    static Locale tsLocale = new Locale("en", "US");
    public Connection conn = null;
    public ConnectionFactory factory = null;
    public String supr = "JAXRCommonClient";
    protected static final String JAXRPASSWORD = "jaxrPassword";
    protected static final String JAXRUSER = "jaxrUser";
    protected String jaxrPassword;
    protected String jaxrUser;
    protected RegistryService rs = null;
    protected BusinessLifeCycleManager blm = null;
    public static final String TS_DEFAULT_PERSON_NAME_FULLNAME = "TS Test Person";
    public static final String TS_DEFAULT_ORGANIZATION_NAME = "TS Default Organization";
    public static final String TS_DEFAULT_ORGANIZATION_DESCRIPTION = "TS default Organization Data";
    public static final String TS_DEFAULT_SERVICE_NAME = "TS default Service";
    protected static final int USE_USERNAME_PASSWORD = 0;
    protected static final int USE_DIGITAL_CERTIFICATES = 1;

    public static Organization createDefaultOrganization(BusinessLifeCycleManager blm) {
        Organization theOrg = null;
        Service sv = null;
        String name = TS_DEFAULT_ORGANIZATION_NAME;
        String descr = TS_DEFAULT_ORGANIZATION_DESCRIPTION;
        User user = null;
        try {
            ArrayList<User> users = null;
            users = new ArrayList<User>();
            theOrg = (Organization)blm.createObject("Organization");
            theOrg.setName(blm.createInternationalString(tsLocale, name));
            theOrg.setDescription(blm.createInternationalString(tsLocale, descr));
            sv = JAXR_Util.createDefaultService(blm);
            theOrg.addService(sv);
            user = JAXR_Util.createDefaultUser(blm);
            users.add(user);
            user = JAXR_Util.createDefaultUsers(blm, "Fred", "Flintstone", "Fred Flintstone");
            users.add(user);
            user = JAXR_Util.createDefaultUsers(blm, "Wilma", "Flintstone", "Wilma Flintstone");
            users.add(user);
            user = JAXR_Util.createDefaultUsers(blm, "Betty", "Rubble", "Betty Rubble");
            users.add(user);
            theOrg.addUsers(users);
            theOrg.setPrimaryContact(user);
            TelephoneNumber pNumber = JAXR_Util.createDefaultTelephoneNumber(blm, "123-1234", "cell");
            ArrayList<TelephoneNumber> pNumbers = null;
            pNumbers = new ArrayList<TelephoneNumber>();
            pNumbers.add(pNumber);
            theOrg.setTelephoneNumbers(pNumbers);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return theOrg;
    }

    public static Service createDefaultService(BusinessLifeCycleManager blm) {
        Service sv = null;
        String name = "TS Default Service";
        String descr = "TS default Service Data";
        Object user = null;
        try {
            sv = blm.createService("defaultTSService");
            sv.setName(blm.createInternationalString(tsLocale, name));
            sv.setDescription(blm.createInternationalString(tsLocale, descr));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return sv;
    }

    public static ServiceBinding createDefaultServiceBinding(BusinessLifeCycleManager blm) {
        ServiceBinding sb = null;
        String descr = "TS default ServiceBinding Data";
        try {
            sb = blm.createServiceBinding();
            sb.setDescription(blm.createInternationalString(tsLocale, descr));
            SpecificationLink sl = JAXR_Util.createDefaultSpecificationLink(blm);
            sb.addSpecificationLink(sl);
            sb.setAccessURI("http://www.something.com");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return sb;
    }

    public static SpecificationLink createDefaultSpecificationLink(BusinessLifeCycleManager blm) {
        SpecificationLink sl = null;
        String usageDescription = "TS Default SpecificationLink Usage Description: test link ";
        String name = "TS Default SpecificationLink";
        String descr = "TS default SpecificationLink Data";
        try {
            sl = (SpecificationLink)blm.createObject("SpecificationLink");
            InternationalString iusageDescription = blm.createInternationalString(tsLocale, usageDescription);
            sl.setUsageDescription(iusageDescription);
            sl.setName(blm.createInternationalString(tsLocale, name));
            sl.setDescription(blm.createInternationalString(tsLocale, descr));
            Concept ro = JAXR_Util.createDefaultConcept(blm);
            sl.setSpecificationObject((RegistryObject)ro);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return sl;
    }

    public static Concept createDefaultConcept(BusinessLifeCycleManager blm) {
        String name = "TS Default Concept";
        String descr = "TS default Concept Data";
        Concept c = null;
        try {
            c = (Concept)blm.createObject("Concept");
            c.setName(blm.createInternationalString(tsLocale, name));
            c.setDescription(blm.createInternationalString(tsLocale, descr));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return c;
    }

    public static User createDefaultUser(BusinessLifeCycleManager blm) {
        String name = "TS Default PrimaryContact User";
        String descr = "TS default User Primary Contact Data";
        User user = null;
        try {
            user = (User)blm.createObject("User");
            Object tn = null;
            String phoneNumber = "123-1234";
            user.setDescription(blm.createInternationalString(tsLocale, descr));
            PersonName pn = JAXR_Util.createDefaultPersonName(blm);
            user.setPersonName(pn);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return user;
    }

    public static User createDefaultUsers(BusinessLifeCycleManager blm, String name, String descr, String fullName) {
        User user = null;
        PersonName pn = null;
        TelephoneNumber tn = null;
        String phoneNumber = "123-1234";
        ArrayList<EmailAddress> addresses = null;
        try {
            addresses = new ArrayList<EmailAddress>();
            user = (User)blm.createObject("User");
            user.setDescription(blm.createInternationalString(tsLocale, descr));
            pn = JAXR_Util.createDefaultPersonName(blm);
            pn.setFullName(fullName);
            user.setPersonName(pn);
            String emailaddress = name + "@Bedrock.org";
            String emailType = "whatever";
            EmailAddress ea = JAXR_Util.createEmailAddress(blm, emailaddress, emailType);
            addresses.add(ea);
            user.setEmailAddresses(addresses);
            tn = JAXR_Util.createDefaultTelephoneNumber(blm, phoneNumber, null);
            ArrayList<TelephoneNumber> nums = new ArrayList<TelephoneNumber>();
            nums.add(tn);
            user.setTelephoneNumbers(nums);
            user.setType("defaultUser");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return user;
    }

    public static EmailAddress createEmailAddress(BusinessLifeCycleManager blm, String address, String emailType) {
        EmailAddress ea = null;
        try {
            ea = (EmailAddress)blm.createObject("EmailAddress");
            ea.setAddress(address);
            ea.setType(emailType);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return ea;
    }

    public static TelephoneNumber createDefaultTelephoneNumber(BusinessLifeCycleManager blm, String phoneNumber, String phoneType) {
        TelephoneNumber tn = null;
        try {
            tn = (TelephoneNumber)blm.createObject("TelephoneNumber");
            tn.setNumber(phoneNumber);
            tn.setType(phoneType);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return tn;
    }

    public static PersonName createDefaultPersonName(BusinessLifeCycleManager blm) {
        String fullName = TS_DEFAULT_PERSON_NAME_FULLNAME;
        PersonName pn = null;
        try {
            pn = (PersonName)blm.createObject("PersonName");
            pn.setFullName(fullName);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return pn;
    }

    public static InternationalString getOrgName(Organization org) {
        InternationalString o = null;
        try {
            o = org.getName();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return o;
    }

    public static Collection getOrganizationData(Organization theOrg) {
        ArrayList<InternationalString> o = new ArrayList<InternationalString>();
        try {
            o.add(theOrg.getName());
            o.add(theOrg.getDescription());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return o;
    }

    public static boolean checkBulkResponse(String whoami, BulkResponse br, Collection debug) {
        boolean pass = false;
        debug.add("\n================ Checking BulkResponse =====================\n");
        try {
            debug.add("=====  for " + whoami + "\n");
            if (br.getExceptions() == null) {
                pass = true;
                debug.add("== Got back bulkresponse with no Exceptions!\n");
            } else {
                debug.add("== Exception returned from BulkResponse!!\n");
                Collection ex = br.getExceptions();
                for (JAXRException je : ex) {
                    debug.add("== Detail Message for the JAXRException object: " + je.getMessage() + "\n");
                }
            }
            debug.add("== Is response available returns: " + br.isAvailable() + "\n");
            debug.add("== IsPartialResponse returns: " + br.isPartialResponse() + "\n");
            debug.add("== The JAXR Response Status: " + JAXR_Util.checkBulkResponseStatus(br.getStatus()) + "\n");
            debug.add("== The Unique Request Id for the request that generated this response is: " + br.getRequestId() + "\n");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return pass;
    }

    static String checkBulkResponseStatus(int status) {
        String response;
        switch (status) {
            case 0: {
                response = "STATUS_SUCCESS ";
                break;
            }
            case 2: {
                response = "STATUS_FAILURE ";
                break;
            }
            case 3: {
                response = "STATUS_UNAVAILABLE ";
                break;
            }
            case 1: {
                response = "STATUS_WARNING  ";
                break;
            }
            default: {
                response = "Unknown Status! ";
            }
        }
        return response;
    }

    public static void deleteConcept(Collection conceptKeys, BusinessLifeCycleManager blm, Collection debug) {
        try {
            BulkResponse br = blm.deleteConcepts(conceptKeys);
            if (!JAXR_Util.checkBulkResponse("deleteConcepts", br, debug)) {
                debug.add("Error reported in deleteConcept method:  deleteConcepts failed \n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public static Collection findConceptsbyName(String conceptName, BusinessQueryManager bqm, Collection debug) {
        Key key = null;
        ArrayList<Key> conceptKeys = null;
        try {
            ArrayList<String> names = new ArrayList<String>();
            conceptKeys = new ArrayList<Key>();
            names.add(conceptName);
            BulkResponse br = bqm.findConcepts(null, names, null, null, null);
            if (!JAXR_Util.checkBulkResponse("findConcepts", br, debug)) {
                debug.add("Error reported:  findConcepts failed \n");
                return null;
            }
            Collection concepts = br.getCollection();
            if (concepts.size() == 0) {
                debug.add("WARNING:   findConceptbyName method found nothing in the registry\n");
                return null;
            }
            for (Concept concept : concepts) {
                key = concept.getKey();
                conceptKeys.add(key);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return conceptKeys;
    }

    public static Key findConceptbyName(String conceptName, BusinessQueryManager bqm, Collection debug) {
        Key key = null;
        try {
            ArrayList<String> names = new ArrayList<String>();
            names.add(conceptName);
            BulkResponse br = bqm.findConcepts(null, names, null, null, null);
            if (!JAXR_Util.checkBulkResponse("findConcepts", br, debug)) {
                debug.add("Error reported:  findConcepts failed \n");
                return null;
            }
            Collection concepts = br.getCollection();
            if (concepts.size() == 0) {
                debug.add("WARNING:   findConceptbyName method found nothing in the registry\n");
                return null;
            }
            if (concepts.size() > 0) {
                debug.add("WARNING:   findConceptbyName method found more than one concept\n");
                return null;
            }
            for (Concept concept : concepts) {
                key = concept.getKey();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Organization getMyOrgByName(RegistryService rs, String orgName) {
        BusinessQueryManager bqm = null;
        Organization o = null;
        ArrayList<String> debug = null;
        try {
            debug = new ArrayList<String>();
            bqm = rs.getBusinessQueryManager();
            ArrayList<String> names = new ArrayList<String>();
            names.add(orgName);
            BulkResponse br = bqm.findOrganizations(null, names, null, null, null, null);
            if (!JAXR_Util.checkBulkResponse("findOrganizations", br, debug)) {
                debug.add("Error:    findOrganizations failed \n");
                Organization organization = null;
                return organization;
            }
            Collection myOrgs = br.getCollection();
            if (myOrgs.size() != 1) {
                debug.add("Expected 1 organization, but got: " + myOrgs.size() + "\n");
                Organization organization = null;
                return organization;
            }
            Iterator iter = myOrgs.iterator();
            o = null;
            while (iter.hasNext()) {
                o = (Organization)iter.next();
            }
            if (o != null && o.getName().equals(orgName)) {
                debug.add("======================================\n");
                debug.add("Success: Found published Organization \n");
                debug.add("======================================\n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            System.out.print(((Object)debug).toString());
        }
        return o;
    }

    public static Set doCredentials(int jaxrSecurityCredentialType, Properties creds, String whichUser) {
        Set credentials = null;
        try {
            switch (jaxrSecurityCredentialType) {
                case 0: {
                    if (whichUser.equals("user1")) {
                        credentials = JAXR_Util.getUsernamePasswordCredentials(creds.getProperty(JAXRUSER), creds.getProperty(JAXRPASSWORD));
                        TestUtil.logTrace((String)("Setting credentials for " + creds.getProperty(JAXRUSER)));
                        break;
                    }
                    credentials = JAXR_Util.getUsernamePasswordCredentials(creds.getProperty("jaxrUser2"), creds.getProperty("jaxrPassword2"));
                    TestUtil.logTrace((String)("Setting credentials for " + creds.getProperty("jaxrUser2")));
                    break;
                }
                case 1: {
                    if (whichUser.equals("user1")) {
                        credentials = JAXR_Util.getDigitalCertificateCredentials(creds.getProperty("jaxrAlias"), creds.getProperty("jaxrAliasPassword"));
                        TestUtil.logTrace((String)("Setting credentials for " + creds.getProperty("jaxrAlias")));
                        break;
                    }
                    credentials = JAXR_Util.getDigitalCertificateCredentials(creds.getProperty("jaxrAlias2"), creds.getProperty("jaxrAlias2Password"));
                    TestUtil.logTrace((String)("Setting credentials for " + creds.getProperty("jaxrAlias2")));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return credentials;
    }

    private static Set getUsernamePasswordCredentials(String jaxrUser, String jaxrPassword) {
        PasswordAuthentication passwdAuth = null;
        HashSet<PasswordAuthentication> credentials = new HashSet<PasswordAuthentication>();
        passwdAuth = new PasswordAuthentication(jaxrUser, jaxrPassword.toCharArray());
        credentials.add(passwdAuth);
        return credentials;
    }

    private static Set getDigitalCertificateCredentials(String useralias, String aliasPassword) {
        String keystoreType = "JKS";
        HashSet<X500PrivateCredential> credentials = new HashSet<X500PrivateCredential>();
        try {
            String keystoreFile = System.getProperty("javax.net.ssl.keyStore");
            String keyPass = System.getProperty("javax.net.ssl.keyStorePassword");
            char[] passphrase = null;
            passphrase = keyPass.toCharArray();
            KeyStore ks = KeyStore.getInstance(keystoreType);
            ks.load(new FileInputStream(keystoreFile), passphrase);
            Certificate certificate = ks.getCertificate(useralias);
            PrivateKey key = (PrivateKey)ks.getKey(useralias, aliasPassword.toCharArray());
            X509Certificate cert = (X509Certificate)certificate;
            X500PrivateCredential privateCredential = null;
            privateCredential = new X500PrivateCredential(cert, key, useralias);
            credentials.add(privateCredential);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return credentials;
    }
}

