/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.relationship.bidironexmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.relationship.bidironexmany.BiDir1XMPerson;
import com.sun.ts.tests.jpa.core.relationship.bidironexmany.BiDir1XMProject;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void biDir1XMTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin BiDir1X1Test1");
        boolean pass = false;
        try {
            BiDir1XMProject newProject2;
            this.getEntityTransaction().begin();
            BiDir1XMProject project1 = new BiDir1XMProject(1L, "JavaEE", Float.valueOf(500.0f));
            BiDir1XMProject project2 = new BiDir1XMProject(2L, "Identity", Float.valueOf(500.0f));
            BiDir1XMPerson person = new BiDir1XMPerson(1L, "Duke");
            TestUtil.logTrace((String)"persisted Person Entity");
            Vector<BiDir1XMProject> projects = new Vector<BiDir1XMProject>();
            projects.add(project1);
            projects.add(project2);
            TestUtil.logTrace((String)"set Projects to Person");
            person.setProjects(projects);
            TestUtil.logTrace((String)"set Person to Projects");
            project1.setBiDir1XMPerson(person);
            project2.setBiDir1XMPerson(person);
            this.getEntityManager().persist((Object)person);
            TestUtil.logTrace((String)"persisted Person Entity");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            boolean pass1 = false;
            boolean pass2 = false;
            BiDir1XMProject newProject1 = (BiDir1XMProject)this.getEntityManager().find(BiDir1XMProject.class, (Object)1L);
            if (newProject1 != null) {
                if (newProject1.getName().equals("JavaEE")) {
                    BiDir1XMPerson newPerson = newProject1.getBiDir1XMPerson();
                    if (newPerson != null) {
                        if (newPerson.getName().equals("Duke")) {
                            TestUtil.logTrace((String)"Found Expected Person Entity");
                            pass1 = true;
                        }
                    } else {
                        TestUtil.logTrace((String)"searched Person not Found");
                    }
                }
            } else {
                TestUtil.logTrace((String)"searched Project not Found");
            }
            if ((newProject2 = (BiDir1XMProject)this.getEntityManager().find(BiDir1XMProject.class, (Object)2L)) != null) {
                if (newProject2.getName().equals("Identity")) {
                    BiDir1XMPerson newPerson = newProject2.getBiDir1XMPerson();
                    if (newPerson != null) {
                        if (newPerson.getName().equals("Duke")) {
                            TestUtil.logTrace((String)"Found Expected Person Entity");
                            pass2 = true;
                        }
                    } else {
                        TestUtil.logTrace((String)"searched Person not Found");
                    }
                }
            } else {
                TestUtil.logTrace((String)"searched Project not Found");
            }
            if (pass1 && pass2) {
                TestUtil.logTrace((String)"biDir1X1Test1: Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("biDir1XMTest1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1XMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1XMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

