/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.assembly.appres.common;

import com.sun.ts.tests.ejb30.assembly.appres.common.AppResLocalIF;
import com.sun.ts.tests.ejb30.assembly.appres.common.AppResRemoteIF;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.Context;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AppResTest {
    private AppResTest() {
    }

    public static HelloRemoteIF getHelloBeanRemote() {
        return (HelloRemoteIF)ServiceLocator.lookupNoTry("java:app/env/hello", new Context[0]);
    }

    public static AppResRemoteIF getAppResBeanRemote() {
        return (AppResRemoteIF)ServiceLocator.lookupNoTry("java:app/env/AppResBean-remote", new Context[0]);
    }

    public static AppResLocalIF getAppResBeanLocal() {
        return (AppResLocalIF)ServiceLocator.lookupNoTry("java:app/env/AppResBean-local", new Context[0]);
    }

    public static final void verifyMyString(StringBuilder sb) {
        String s = (String)ServiceLocator.lookupNoTry("java:app/env/myString", new Context[0]);
        Helper.assertEquals(null, "myString", s, sb);
    }

    public static final void verifyDataSource(StringBuilder sb) {
        DataSource db1 = (DataSource)ServiceLocator.lookupNoTry("java:app/env/db1", new Context[0]);
        Helper.assertNotEquals(null, null, db1, sb);
    }

    public static final void verifyUserTransaction(StringBuilder sb) {
        UserTransaction ut = (UserTransaction)ServiceLocator.lookupNoTry("java:app/env/ut", new Context[0]);
        Helper.assertNotEquals(null, null, ut, sb);
    }

    public static final void verifyPersistenceContext(StringBuilder sb) {
        EntityManager em = (EntityManager)ServiceLocator.lookupNoTry("java:app/env/entityManager", new Context[0]);
        Helper.assertNotEquals(null, null, em, sb);
    }

    public static final void verifyPersistenceUnit(StringBuilder sb) {
        EntityManagerFactory pu = (EntityManagerFactory)ServiceLocator.lookupNoTry("java:app/env/persistenceUnit", new Context[0]);
        Helper.assertNotEquals(null, null, pu, sb);
    }

    public static final void verifyQueue(StringBuilder sb) {
        Queue queue = (Queue)ServiceLocator.lookupNoTry("java:app/env/receiveQueue", new Context[0]);
        Helper.assertNotEquals(null, null, queue, sb);
        try {
            queue.getQueueName();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void verifyValidatorAndFactory(StringBuilder sb) {
        Validator v = (Validator)ServiceLocator.lookupNoTry("java:comp/Validator", new Context[0]);
        ValidatorFactory vf = (ValidatorFactory)ServiceLocator.lookupNoTry("java:comp/ValidatorFactory", new Context[0]);
        Validator v2 = vf.getValidator();
        Helper.assertNotEquals("Check Validator java:comp/Validator", null, v, sb);
        Helper.assertNotEquals("Check Validator from factory", null, v2, sb);
        Helper.assertNotEquals("Check ValidatorFactory java:comp/ValidatorFactory", null, vf, sb);
        v = (Validator)ServiceLocator.lookupNoTry("java:app/env/validator", new Context[0]);
        vf = (ValidatorFactory)ServiceLocator.lookupNoTry("java:app/env/validatorFactory", new Context[0]);
        v2 = vf.getValidator();
        Helper.assertNotEquals("Check Validator java:app/env/validator", null, v, sb);
        Helper.assertNotEquals("Check Validator from factory", null, v2, sb);
        Helper.assertNotEquals("Check ValidatorFactory java:app/env/validatorFactory", null, vf, sb);
    }

    public static final void verifyInjections(StringBuilder sb, Object ... oo) {
        for (Object o : oo) {
            Helper.assertNotEquals(null, null, o, sb);
        }
    }

    public static void beanPostConstruct(String myString, StringBuilder postConstructRecords, boolean namingContextLookup, boolean ejbContextLookup) {
        int a = 1;
        int b = 1;
        int c = a + b;
        try {
            AppResTest.verifyMyString(postConstructRecords);
            AppResTest.verifyUserTransaction(postConstructRecords);
            AppResTest.verifyDataSource(postConstructRecords);
            AppResTest.verifyQueue(postConstructRecords);
            String appName = (String)ServiceLocator.lookupNoTry("java:app/AppName", new Context[0]);
            if (!appName.endsWith("appclientejb")) {
                AppResTest.verifyPersistenceContext(postConstructRecords);
            }
            AppResTest.verifyPersistenceUnit(postConstructRecords);
            AppResTest.verifyValidatorAndFactory(postConstructRecords);
            Helper.assertEquals(null, c, AppResTest.getHelloBeanRemote().add(a, b), postConstructRecords);
            Helper.assertEquals(null, "myString", myString, postConstructRecords);
            if (namingContextLookup) {
                AppResRemoteIF br = AppResTest.getAppResBeanRemote();
                AppResLocalIF bl = AppResTest.getAppResBeanLocal();
                if (ejbContextLookup) {
                    SessionContext sctx = (SessionContext)ServiceLocator.lookupNoTry("java:app/env/sctx", new Context[0]);
                    AppResLocalIF bl2 = (AppResLocalIF)sctx.lookup("java:app/env/AppResBean-local");
                    AppResRemoteIF br2 = (AppResRemoteIF)sctx.lookup("java:app/env/AppResBean-remote");
                    Helper.assertEquals(null, br, br2, postConstructRecords);
                    Helper.assertEquals(null, bl, bl2, postConstructRecords);
                }
            }
        }
        catch (RuntimeException e) {
            Helper.getLogger().warning(postConstructRecords.toString());
            throw e;
        }
        catch (Error e) {
            Helper.getLogger().warning(postConstructRecords.toString());
            throw e;
        }
    }
}

