/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.utils;

import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPUtils
implements SOAPConstants {
    public static final String FAULT_DETAIL = "detail";
    public static final String FAULT_ACTOR = "faultactor";
    public static final String FAULT_STRING = "faultstring";
    public static final String FAULT_CODE = "faultcode";
    public static final String VERSION_MISMATCH = "VersionMismatch";
    public static final String CLIENT = "Client";
    public static final String MUST_UNDERSTAND = "MustUnderstand";
    public static final String[] FAULT_CHILDREN = new String[]{"faultactor", "faultcode", "detail", "faultstring"};

    public static boolean isValidSoapFaultChildName(SOAPElement element) {
        for (int i = 0; i < FAULT_CHILDREN.length; ++i) {
            if (!FAULT_CHILDREN[i].equals(element.getElementName().getLocalName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isVersionMismatchFaultcode(SOAPMessage message) throws SOAPException {
        return SOAPUtils.isFaultcode(message, VERSION_MISMATCH);
    }

    public static boolean isMustUnderstandFaultcode(SOAPMessage message) throws SOAPException {
        return SOAPUtils.isFaultcode(message, MUST_UNDERSTAND);
    }

    public static boolean isClientFaultcode(SOAPMessage message) throws SOAPException {
        return SOAPUtils.isFaultcode(message, CLIENT);
    }

    public static boolean isMustUnderstandFaultcode(SOAPFaultException se) {
        return SOAPUtils.isFaultcode(se, MUST_UNDERSTAND);
    }

    private static boolean isFaultcode(SOAPFaultException se, String faultcode) {
        return se.getFaultCode().toString().endsWith(faultcode);
    }

    private static boolean isFaultcode(SOAPMessage message, String faultcode) throws SOAPException {
        SOAPBody body = message.getSOAPPart().getEnvelope().getBody();
        if (body.hasFault()) {
            return body.getFault().getFaultCode().endsWith(faultcode);
        }
        return false;
    }
}

