/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.callback.xml;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.core.callback.common.Constants;
import com.sun.ts.tests.jpa.core.callback.common.EntityCallbackClientBase;
import com.sun.ts.tests.jpa.core.callback.xml.Customer;
import com.sun.ts.tests.jpa.core.callback.xml.LineItem;
import com.sun.ts.tests.jpa.core.callback.xml.Order;
import com.sun.ts.tests.jpa.core.callback.xml.Product;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.persistence.Query;

public class Client
extends EntityCallbackClientBase {
    private static final long serialVersionUID = 1L;
    private Product product;
    private Order order;
    private LineItem lineItem;
    private Customer customer;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void prePersistTest() throws EETest.Fault {
        String testName = "prePersistTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("prePersistTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().flush();
            if (!this.product.isPrePersistCalled()) {
                String reason = "Product: prePersist was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "Product: prePersist was called.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void prePersistMultiTest() throws EETest.Fault {
        String testName = "prePersistMultiTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("prePersistMultiTest");
            this.getEntityManager().persist((Object)this.product);
            List actual = this.product.getPrePersistCalls();
            this.compareResultList(Constants.LISTENER_AABBCC, actual);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void prePersistCascadeTest() throws EETest.Fault {
        String testName = "prePersistCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("prePersistCascadeTest");
            this.product = this.newProduct("prePersistCascadeTest");
            this.lineItem = this.newLineItem("prePersistCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            this.getEntityManager().flush();
            if (!this.order.isPrePersistCalled()) {
                String reason = "Order: prePersist was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "Order: prePersist was called.";
            TestUtil.logTrace((String)reason);
            if (!this.lineItem.isPrePersistCalled()) {
                reason = "LineItem: prePersist was not called.";
                throw new EETest.Fault(reason);
            }
            reason = "LineItem: prePersist was called.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistCascadeTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void prePersistMultiCascadeTest() throws EETest.Fault {
        String testName = "prePersistMultiCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("prePersistMultiCascadeTest");
            this.product = this.newProduct("prePersistMultiCascadeTest");
            this.lineItem = this.newLineItem("prePersistMultiCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            List actual = this.order.getPrePersistCalls();
            this.compareResultList(Constants.LISTENER_AABBCC, actual);
            actual = this.lineItem.getPrePersistCalls();
            this.compareResultList(Constants.LISTENER_BBCC, actual);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preRemoveTest() throws EETest.Fault {
        String testName = "preRemoveTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("preRemoveTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().remove((Object)this.product);
            if (!this.product.isPreRemoveCalled()) {
                String reason = "Product: preRemove was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "Product: preRemove was called.";
            TestUtil.logTrace((String)reason);
            this.product = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during preRemoveTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preRemoveMultiTest() throws EETest.Fault {
        String testName = "preRemoveMultiTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("preRemoveMultiTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().remove((Object)this.product);
            List actual = this.product.getPreRemoveCalls();
            this.compareResultList(Constants.LISTENER_AABBCC, actual);
            this.product = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preRemoveCascadeTest() throws EETest.Fault {
        String testName = "preRemoveCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("preRemoveCascadeTest");
            this.product = this.newProduct("preRemoveCascadeTest");
            this.lineItem = this.newLineItem("preRemoveCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            this.getEntityManager().remove((Object)this.order);
            boolean b = this.order.isPreRemoveCalled();
            this.order = null;
            if (!b) {
                String reason = "Order: preRemove was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "Order: preRemove was called.";
            TestUtil.logTrace((String)reason);
            if (!this.lineItem.isPreRemoveCalled()) {
                reason = "LineItem: preRemove was not called.";
                throw new EETest.Fault(reason);
            }
            reason = "LineItem: preRemove was called.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during preRemoveCascadeTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preRemoveMultiCascadeTest() throws EETest.Fault {
        String testName = "preRemoveMultiCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("preRemoveMultiCascadeTest");
            this.product = this.newProduct("preRemoveMultiCascadeTest");
            this.lineItem = this.newLineItem("preRemoveMultiCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            this.getEntityManager().remove((Object)this.order);
            boolean b = this.order.isPreRemoveCalled();
            List actual = this.order.getPreRemoveCalls();
            this.compareResultList(Constants.LISTENER_AABBCC, actual);
            actual = this.lineItem.getPreRemoveCalls();
            this.compareResultList(Constants.LISTENER_BBCC, actual);
            this.order = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during preRemoveMultiCascadeTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void preUpdateTest() throws EETest.Fault {
        String testName = "preUpdateTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("preUpdateTest");
            this.getEntityManager().persist((Object)this.product);
            this.product.setPrice(2.0);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during preUpdateTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void postLoadTest() throws EETest.Fault {
        String testName = "postLoadTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("postLoadTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.product);
            Query q = this.getEntityManager().createQuery("select distinct p from Product p");
            List results = q.getResultList();
            TestUtil.logTrace((String)results.toString());
            if (!this.product.isPostLoadCalled()) {
                String reason = "Product: postLoad was not called even after the query result was returned.";
                throw new EETest.Fault(reason);
            }
            String reason = "Product: postLoad was called after the query result was returned.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during postLoadTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void postLoadMultiTest() throws EETest.Fault {
        String testName = "postLoadMultiTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("postLoadMultiTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.product);
            Query q = this.getEntityManager().createQuery("select distinct p from Product p");
            List results = q.getResultList();
            TestUtil.logTrace((String)results.toString());
            List actual = this.product.getPostLoadCalls();
            this.compareResultList(Constants.LISTENER_AABBCC, actual);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void prePersistRuntimeExceptionTest() throws EETest.Fault {
        String testName = "prePersistRuntimeExceptionTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("prePersistRuntimeExceptionTest");
            this.product = (Product)this.txShouldRollback(this.product, "prePersistRuntimeExceptionTest");
            List actual = this.product.getPrePersistCalls();
            ArrayList<String> expected = new ArrayList<String>(Arrays.asList("ListenerA"));
            if (!this.product.isPrePersistCalled() || !expected.equals(actual)) {
                TestUtil.logErr((String)("Expected: " + ((Object)expected).toString() + ", actual:" + actual.toString()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistRuntimeExceptionTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    public void prePersistDefaultListenerTest() throws EETest.Fault {
        String testName = "prePersistDefaultListenerTest";
        try {
            this.getEntityTransaction().begin();
            this.customer = this.newCustomer("prePersistDefaultListenerTest");
            this.getEntityManager().persist((Object)this.customer);
            this.getEntityManager().flush();
            if (!this.customer.isPrePersistCalled()) {
                String reason = "Customer: prePersist was not called.";
                throw new EETest.Fault(reason);
            }
            String reason = "Customer: prePersist was called.";
            TestUtil.logTrace((String)reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during prePersistTest", (Throwable)e);
            throw new EETest.Fault(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    private Product newProduct(String testName) {
        Product product = new Product();
        product.setTestName(testName);
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    private Order newOrder(String testName) {
        Order order = new Order(testName, 1.0);
        order.setTestName(testName);
        return order;
    }

    private LineItem newLineItem(String testName) {
        LineItem lineItem = new LineItem();
        lineItem.setTestName(testName);
        lineItem.setId(testName);
        lineItem.setQuantity(1);
        return lineItem;
    }

    private Customer newCustomer(String testName) {
        Customer customer = new Customer(testName, testName);
        return customer;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM LINEITEM_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ORDER_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUSTOMER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

