/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.objectMsgQueue;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class ObjectMsgQueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.objectMsgQueue.ObjectMsgQueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ObjectMsgQueueTests theTests = new ObjectMsgQueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'numConsumers' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'numProducers' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void messageObjectCopyQTest() throws EETest.Fault {
        boolean pass = true;
        try {
            ObjectMessage messageSentObject = null;
            ObjectMessage messageReceivedObject = null;
            StringBuffer sBuff = new StringBuffer("This is");
            String initial = "This is";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSentObject = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentObject.setObject((Serializable)sBuff);
            sBuff.append("a test ");
            messageSentObject.setStringProperty("COM_SUN_JMS_TESTNAME", "messageObjectCopyQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentObject);
            messageReceivedObject = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("Ensure that changing the object did not change the message");
            StringBuffer s = (StringBuffer)messageReceivedObject.getObject();
            this.logTrace("s is " + s);
            if (s.toString().equals(initial)) {
                this.logTrace("Pass: msg was not changed");
            } else {
                this.logTrace("Fail: msg was changed!");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("messageObjectCopyQTest");
        }
    }

    public void notWritableTest() throws EETest.Fault {
        boolean pass = true;
        StringBuffer sBuff = new StringBuffer("This is");
        String testName = "notWritableTest";
        try {
            ObjectMessage messageSentObject = null;
            ObjectMessage messageReceivedObject = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSentObject = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentObject.setObject((Serializable)sBuff);
            messageSentObject.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentObject);
            messageReceivedObject = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                messageReceivedObject.setObject((Serializable)sBuff);
                TestUtil.logErr((String)"Error: expected MessageNotWriteableException not thrown");
                pass = false;
            }
            catch (MessageNotWriteableException ex) {
                TestUtil.logTrace((String)"Got expected MessageNotWriteableException");
            }
            if (!pass) {
                throw new EETest.Fault(testName);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)(testName + " failed: "), (Throwable)e);
            throw new EETest.Fault(testName);
        }
    }
}

