/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.stateful.mdb;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class MDB_SND_TestEJB
implements SessionBean {
    private SessionContext sessionContext;
    private Properties p = null;
    private transient Queue rcvrQueue;
    private transient QueueConnection qConnect;
    private transient Queue q;
    private transient QueueConnectionFactory qFactory;
    TSNamingContext context;
    private long timeout;
    private String jmsUser;
    private String jmsPassword;

    public void ejbCreate(Properties props) throws CreateException {
        this.p = props;
        try {
            TestUtil.init((Properties)props);
            this.timeout = Long.parseLong(props.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in cts.jte must be > 0");
            }
            this.jmsUser = props.getProperty("authuser");
            this.jmsPassword = props.getProperty("authpassword");
            TestUtil.logTrace((String)("@ejbCreate:" + this.jmsUser + " " + this.jmsPassword));
            this.context = new TSNamingContext();
            TestUtil.logTrace((String)"got the context");
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            TestUtil.logTrace((String)"looked up queue connection factory object");
            this.q = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            TestUtil.logTrace((String)"looked up the queue");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"init failed", (Throwable)e);
        }
    }

    public boolean askMDBToSendAMessage(String typeOfMessage) {
        TestUtil.logTrace((String)"@askMDBToSendAMessage");
        boolean ok = true;
        String myMessage = "I want you to send a message";
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            QueueSender qSender = session.createSender(this.q);
            TestUtil.logTrace((String)("got a q sender for: " + qSender.getQueue().getQueueName()));
            TextMessage msg = session.createTextMessage();
            msg.setText(myMessage);
            msg.setStringProperty("MessageType", typeOfMessage);
            qSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("@askMDBToSendAMessage: Error!", e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            TestUtil.logTrace((String)"@checkOnResponse");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            status = this.recvMessageInternal(session, prop);
            TestUtil.logMsg((String)("Close the session" + status));
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in checkOnResponse:", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return status;
    }

    private boolean recvMessageInternal(QueueSession session, String prop) throws JMSException {
        boolean retcode = false;
        TestUtil.logTrace((String)"@recvMessageInternal");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 50; ++i) {
            TestUtil.logTrace((String)("@recvMessageInternal trying to receive the message: " + i));
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec.getStringProperty("MessageType").equals(prop)) {
                TestUtil.logTrace((String)("Success: received Msg from Q!  " + msgRec.getStringProperty("MessageType")));
                TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                retcode = true;
            } else {
                TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
                TestUtil.logTrace((String)("Msg from Q:  " + msgRec.getStringProperty("MessageType")));
            }
        } else if (msgRec == null) {
            TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThereSomethingInTheQueue() {
        TestUtil.logTrace((String)"@isThereSomethingInTheQueue");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        boolean ret = false;
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            if (msgs.hasMoreElements()) {
                ret = true;
            }
            qBrowser.close();
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in isThereSomethingInTheQueue:", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTheQueue() {
        TestUtil.logTrace((String)"@cleanTheQueue");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        int numMsgs = 0;
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            TextMessage msgRec = null;
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
            TestUtil.logTrace((String)("Cleaning " + numMsgs + " messages from the Q: " + this.rcvrQueue.getQueueName()));
            block12: for (int n = 0; n < numMsgs; ++n) {
                TestUtil.logTrace((String)("dequeuing msg: " + n + " from the Q: " + this.rcvrQueue.getQueueName()));
                for (int i = 0; i < 10; ++i) {
                    msgRec = (TextMessage)rcvr.receive(this.timeout);
                    if (msgRec != null) {
                        TestUtil.logTrace((String)("dequeued message: " + n));
                        continue block12;
                    }
                    TestUtil.logTrace((String)("Attempt no: " + i + " Trying to dequeue message: " + n));
                }
            }
            qBrowser.close();
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in cleanTheQueue:", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"@setSessionContext");
        this.sessionContext = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"@ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"@ejbActivate");
        try {
            TestUtil.logTrace((String)"look up queue connection factory object");
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            TestUtil.logTrace((String)"looked up the queue");
            this.q = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in activation:", (Throwable)e);
        }
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"@ejbPassivate");
        this.rcvrQueue = null;
        this.qConnect = null;
        this.q = null;
        this.qFactory = null;
    }
}

