/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.common;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.timer.common.TimerImplException;
import com.sun.ts.tests.ejb.ee.timer.helper.CheckedMethod;
import com.sun.ts.tests.ejb.ee.timer.helper.CheckedMethodHome;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EntityContext;
import javax.ejb.SessionContext;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.transaction.UserTransaction;

public class TimerImpl {
    public static final String INFOSTRING = "info";
    public static final String NOMSGRECEIVED = "no valid message received";
    public static final String NOTIMER_FOUND = "no timer found";
    public static final String TIMER_EXISTS = "at least one timer found";
    public static final String ACCESS_OK = "hello from ejbTimeout";
    public static final String CHKMETH_OK = "checked method successfully accessed in ejbTimeout";
    public static final String CHKMETH_FAIL = "checked method access failed in ejbTimeout";
    public static final String RETRY_OK = "ejbTimeout has been successfully retried";
    public static final String RETRY_FAIL = "Retry of ejbTimeout resulted in an exception";
    public static final String ROLLBACK_OK = "Transaction has been successfully rolled back in ejbTimeout";
    public static final String ROLLBACK_FAIL = "Transaction rollback failed in ejbTimeout";
    public static final String SERIALIZE_OK = "Timer handle successfully serialized in ejbTimeout";
    public static final String SERIALIZE_FAIL = "Timer handle serialization failed in ejbTimeout";
    public static final String INVALID_ACTION = "Invalid action specified in ejbTimeout";
    public static final String ALLOW_OK = "allowed methods test successful in ejbTimeout";
    public static final String ALLOW_FAIL = "allowed methods test failed in ejbTimeout";
    public static final long EXPIRATION_TIME = 1000000L;
    public static final long INTERVAL_TIME = 10000L;
    public static final int NOMSG = -1;
    public static final int ACCESS = 1;
    public static final int CHKMETH = 2;
    public static final int RETRY = 3;
    public static final int ROLLBACK = 4;
    public static final int SERIALIZE = 5;
    public static final int ALLOWED = 6;
    public static final int TIMER_SINGLEEVENT = 1;
    public static final int TIMER_INTERVAL = 2;
    public static final int TIMER_DATE = 3;
    public static final int TIMER_DATE_INTERVAL = 4;
    public static final int TESTBEAN_KEY = 1;
    public static final int FLAGSTORE_KEY = 2;
    public static final int SESSION = 1;
    public static final int ENTITY = 2;
    public static final String CHKMETH_BEAN = "java:comp/env/ejb/CheckedMethod";
    public static final String FLAGSTORE_BEAN = "java:comp/env/ejb/FlagStore";

    protected static Timer createSingleEventTimer(long duration, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(duration, info);
        TestUtil.logTrace((String)"created new single-event timer");
        return t;
    }

    protected static Timer createIntervalTimer(long duration, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(duration, 10000L, info);
        TestUtil.logTrace((String)"created new interval timer");
        return t;
    }

    protected static Timer createDateTimer(Date date, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(date, info);
        TestUtil.logTrace((String)"created new date timer");
        return t;
    }

    protected static Timer createDateIntervalTimer(Date date, long duration, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(date, duration, info);
        TestUtil.logTrace((String)"created new date interval timer");
        return t;
    }

    protected static TimerHandle createSingleEventTimerHandle(long duration, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(duration, info);
        TestUtil.logTrace((String)"created new single-event timer");
        return t.getHandle();
    }

    protected static TimerHandle createIntervalTimerHandle(long duration, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(duration, 10000L, info);
        TestUtil.logTrace((String)"created new interval timer");
        return t.getHandle();
    }

    protected static TimerHandle createDateTimerHandle(Date date, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(date, info);
        TestUtil.logTrace((String)"created new date timer");
        return t.getHandle();
    }

    protected static TimerHandle createDateIntervalTimerHandle(Date date, long duration, Serializable info, TimerService ts) throws Exception {
        Timer t = ts.createTimer(date, duration, info);
        TestUtil.logTrace((String)"created new date interval timer");
        return t.getHandle();
    }

    public static Serializable getInfo(TimerHandle handle) throws Exception {
        Timer t = handle.getTimer();
        return t.getInfo();
    }

    public static void cancelTimer(TimerHandle timerHandle) throws Exception {
        Timer t = timerHandle.getTimer();
        t.cancel();
    }

    public static boolean verifyNoTimers(TimerService ts) throws Exception {
        ArrayList al = new ArrayList(ts.getTimers());
        return al.isEmpty();
    }

    public static void cancelAllTimers(TimerService ts) throws Exception {
        try {
            ArrayList al = new ArrayList(ts.getTimers());
            if (!al.isEmpty()) {
                int numTimers = al.size();
                TestUtil.logTrace((String)("Number of timers to be cancelled is " + numTimers));
                for (int i = 0; i < numTimers; ++i) {
                    Timer timer = (Timer)al.get(i);
                    TestUtil.logTrace((String)("Timer info is " + timer.getInfo()));
                    timer.cancel();
                }
            } else {
                TestUtil.logTrace((String)"No timers to cancel");
            }
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelAllTimers", e);
        }
    }

    public static Timer createTimer(int timerType, Serializable info, TimerService ts) throws Exception {
        Timer timer;
        switch (timerType) {
            case 1: {
                TestUtil.logTrace((String)"calling createSingleEventTimer");
                timer = TimerImpl.createSingleEventTimer(TimerImpl.getTimeout(), info, ts);
                break;
            }
            case 2: {
                TestUtil.logTrace((String)"calling createIntervalTimer");
                timer = TimerImpl.createIntervalTimer(TimerImpl.getTimeout(), info, ts);
                break;
            }
            case 3: {
                TestUtil.logTrace((String)"calling createDateTimer");
                timer = TimerImpl.createDateTimer(TimerImpl.getExpirationDate(), info, ts);
                break;
            }
            case 4: {
                TestUtil.logTrace((String)"calling createDateIntervalTimer");
                timer = TimerImpl.createDateIntervalTimer(TimerImpl.getExpirationDate(), TimerImpl.getTimeout(), info, ts);
                break;
            }
            default: {
                throw new TimerImplException("invalid timer type specified");
            }
        }
        return timer;
    }

    public static TimerHandle createTimerHandle(int timerType, Serializable info, TimerService ts) throws Exception {
        TimerHandle handle;
        switch (timerType) {
            case 1: {
                TestUtil.logTrace((String)"calling createSingleEventTimerHandle");
                handle = TimerImpl.createSingleEventTimerHandle(TimerImpl.getTimeout(), info, ts);
                break;
            }
            case 2: {
                TestUtil.logTrace((String)"calling createIntervalTimerHandle");
                handle = TimerImpl.createIntervalTimerHandle(TimerImpl.getTimeout(), info, ts);
                break;
            }
            case 3: {
                TestUtil.logTrace((String)"calling createDateTimerHandle");
                handle = TimerImpl.createDateTimerHandle(TimerImpl.getExpirationDate(), info, ts);
                break;
            }
            case 4: {
                TestUtil.logTrace((String)"calling createDateIntervalTimerHandle");
                handle = TimerImpl.createDateIntervalTimerHandle(TimerImpl.getExpirationDate(), TimerImpl.getTimeout(), info, ts);
                break;
            }
            default: {
                throw new TimerImplException("invalid timer type specified");
            }
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean accessCheckedMethod(TSNamingContext nctx) {
        CheckedMethod beanRef = null;
        TestUtil.logTrace((String)"Creating checked method bean...");
        try {
            CheckedMethodHome beanHome = (CheckedMethodHome)nctx.lookup(CHKMETH_BEAN, CheckedMethodHome.class);
            beanRef = beanHome.create();
            beanRef.initLogging(TestUtil.getProperties());
            TestUtil.logTrace((String)"Attempting to access checked method...");
            boolean bl = beanRef.isAuthz();
            return bl;
        }
        catch (Exception e) {
            TimerImpl.handleException("accessCheckedMethod", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (beanRef != null) {
                try {
                    beanRef.remove();
                }
                catch (Exception e) {
                    TimerImpl.handleException("Exception while removing bean", e);
                }
            }
        }
    }

    public static boolean isSerializable(TimerHandle handle) {
        if (handle == null) {
            TestUtil.logErr((String)"Timer handle is null");
            return false;
        }
        if (!(handle instanceof Serializable)) {
            TestUtil.logErr((String)"Timer handle is not serializable");
            return false;
        }
        return true;
    }

    public static TimerHandle getTimerHandleFromEjbTimeout(TimerService ts, int timeoutInfo) {
        TimerHandle handle;
        try {
            ArrayList al = new ArrayList(ts.getTimers());
            if (al.size() != 1) {
                TestUtil.logErr((String)("Wrong number of timers found: " + al.size()));
                return null;
            }
            Timer timer = (Timer)al.get(0);
            Serializable sz = timer.getInfo();
            if (!(sz instanceof Integer)) {
                TestUtil.logErr((String)"Timer.getInfo() returns non-Integer");
                return null;
            }
            int timerInfo = (Integer)sz;
            TestUtil.logTrace((String)("Value of timer info is " + timerInfo));
            if (timerInfo != timeoutInfo) {
                TestUtil.logErr((String)("Timer info received not equal to timer info passed: " + timerInfo + " vs. " + timeoutInfo));
                return null;
            }
            handle = timer.getHandle();
        }
        catch (Exception e) {
            TimerImpl.handleException("getTimerHandleFromEJBTimeout", e);
            return null;
        }
        return handle;
    }

    public static TimerHandle getDeserializedHandle(TimerHandle handle) {
        TimerHandle deserializedHandle;
        try {
            TestUtil.logTrace((String)"write object output stream to byte array");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(baos);
            os.writeObject(handle);
            TestUtil.logTrace((String)"read object output stream from byte array");
            byte[] b = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            ObjectInputStream is = new ObjectInputStream(bais);
            deserializedHandle = (TimerHandle)is.readObject();
        }
        catch (Exception e) {
            TimerImpl.handleException("getDeserializedHandle", e);
            return null;
        }
        return deserializedHandle;
    }

    public static boolean timersAreIdentical(TimerHandle th1, TimerHandle th2) {
        try {
            Timer timer1 = th1.getTimer();
            if (timer1 == null) {
                TestUtil.logErr((String)"First timer handle references null timer");
                return false;
            }
            Timer timer2 = th2.getTimer();
            if (timer2 == null) {
                TestUtil.logErr((String)"Second timer handle references null timer");
                return false;
            }
            return timer1.equals(timer2);
        }
        catch (Exception e) {
            TimerImpl.handleException("timersAreIdentical", e);
            return false;
        }
    }

    private static Properties setTestList() {
        TestUtil.logTrace((String)"setTestList");
        Properties props = new Properties();
        props.setProperty("JNDI_Access", "true");
        props.setProperty("getEJBHome", "true");
        props.setProperty("getCallerPrincipal", "true");
        props.setProperty("getRollbackOnly", "true");
        props.setProperty("isCallerInRole", "true");
        props.setProperty("setRollbackOnly", "true");
        props.setProperty("getEJBObject", "true");
        props.setProperty("UserTransaction", "true");
        props.setProperty("UserTransaction_Methods_Test1", "true");
        props.setProperty("UserTransaction_Methods_Test2", "true");
        props.setProperty("UserTransaction_Methods_Test3", "true");
        props.setProperty("UserTransaction_Methods_Test4", "true");
        props.setProperty("UserTransaction_Methods_Test5", "true");
        props.setProperty("UserTransaction_Methods_Test6", "true");
        props.setProperty("getEJBLocalHome", "true");
        props.setProperty("getEJBLocalObject", "true");
        props.setProperty("getPrimaryKey", "true");
        props.setProperty("getTimerService", "true");
        props.setProperty("Timer_Service_Methods", "true");
        return props;
    }

    public static Properties doOperationTests(EJBContext ejbctx, TSNamingContext nctx, Timer timer, boolean[] skip, String role, int beanType) {
        Object obj;
        TestUtil.logTrace((String)"doOperationTests");
        Properties props = TimerImpl.setTestList();
        if (!skip[0]) {
            try {
                ejbctx.getEJBHome();
                TestUtil.logTrace((String)"Operations test: getEJBHome() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("getEJBHome", "false");
                TestUtil.logTrace((String)"Operations test: getEJBHome() - not allowed");
            }
            catch (Exception e) {
                props.setProperty("getEJBHome", "unexpected");
                TestUtil.logTrace((String)("Operations test: getEJBHome() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[1]) {
            try {
                Principal principal = ejbctx.getCallerPrincipal();
                TestUtil.logTrace((String)"Operations test: getCallerPrincipal() - allowed");
                if (principal != null) {
                    TestUtil.logTrace((String)"getCallerPrincipal() non-null value test passed");
                    TestUtil.logTrace((String)("returned Principal: " + principal));
                    props.setProperty("getCallerPrincipal", "true");
                } else {
                    TestUtil.logTrace((String)"getCallerPrincipal() non-null value test failed");
                    props.setProperty("getCallerPrincipal", "unexpected");
                }
            }
            catch (IllegalStateException e) {
                props.setProperty("getCallerPrincipal", "false");
                TestUtil.logTrace((String)"Operations test: getCallerPrincipal() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("getCallerPrincipal", "unexpected");
                TestUtil.logTrace((String)("Operations test: getCallerPrincipal() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[2]) {
            try {
                ejbctx.getRollbackOnly();
                TestUtil.logTrace((String)"Operations test: getRollbackOnly() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("getRollbackOnly", "false");
                TestUtil.logTrace((String)"Operations test: getRollbackOnly() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("getRollbackOnly", "unexpected");
                TestUtil.logTrace((String)("Operations test: getRollbackOnly() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[3]) {
            try {
                ejbctx.isCallerInRole(role);
                TestUtil.logTrace((String)"Operations test: isCallerInRole() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("isCallerInRole", "false");
                TestUtil.logTrace((String)"Operations test: isCallerInRole() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("isCallerInRole", "unexpected");
                TestUtil.logTrace((String)("Operations test: isCallerInRole() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[4]) {
            try {
                if (beanType == 1) {
                    obj = ((SessionContext)ejbctx).getEJBObject();
                } else if (beanType == 2) {
                    obj = ((EntityContext)ejbctx).getEJBObject();
                }
                TestUtil.logTrace((String)"Operations test: getEJBObject() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("getEJBObject", "false");
                TestUtil.logTrace((String)"Operations test: getEJBObject() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("getEJBObject", "unexpected");
                TestUtil.logTrace((String)("Operations test: getEJBObject() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[5]) {
            try {
                Context ctx = (Context)nctx.lookup("java:comp/env");
                TestUtil.logTrace((String)"Operations test: JNDI_Access - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("JNDI_Access", "false");
                TestUtil.logTrace((String)"Operations test: JNDI_Access - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("JNDI_Access", "unexpected");
                TestUtil.logTrace((String)("Operations test: JNDI_Access - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[6]) {
            try {
                UserTransaction ut = ejbctx.getUserTransaction();
                TestUtil.logTrace((String)"Operations test: UserTransaction - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("UserTransaction", "false");
                TestUtil.logTrace((String)"Operations test: UserTransaction - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("UserTransaction", "unexpected");
                TestUtil.logTrace((String)("Operations test: UserTransaction - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[7]) {
            try {
                ejbctx.getUserTransaction().begin();
                TestUtil.logTrace((String)"Operations test: UserTransaction.begin - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("UserTransaction_Methods_Test1", "false");
                TestUtil.logTrace((String)"Operations test: UserTransaction.begin - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("UserTransaction_Methods_Test1", "unexpected");
                TestUtil.logTrace((String)("Operations test: UserTransaction.begin - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[8]) {
            try {
                ejbctx.getUserTransaction().commit();
                TestUtil.logTrace((String)"Operations test: UserTransaction.commit() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("UserTransaction_Methods_Test2", "false");
                TestUtil.logTrace((String)"Operations test: UserTransaction.commit() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("UserTransaction_Methods_Test2", "unexpected");
                TestUtil.logTrace((String)("Operations test: UserTransaction.commit - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[9]) {
            try {
                ejbctx.getUserTransaction().getStatus();
                TestUtil.logTrace((String)"Operations test: UserTransaction.getStatus - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("UserTransaction_Methods_Test3", "false");
                TestUtil.logTrace((String)"Operations test: UserTransaction.getStatus - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("UserTransaction_Methods_Test3", "unexpected");
                TestUtil.logTrace((String)("Operations test: UserTransaction.getStatus - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[10]) {
            try {
                ejbctx.getUserTransaction().rollback();
                TestUtil.logTrace((String)"Operations test: UserTransaction.rollback - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("UserTransaction_Methods_Test4", "false");
                TestUtil.logTrace((String)"Operations test: UserTransaction.rollback - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("UserTransaction_Methods_Test4", "unexpected");
                TestUtil.logTrace((String)("Operations test: UserTransaction.rollback - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[11]) {
            try {
                ejbctx.getUserTransaction().setRollbackOnly();
                TestUtil.logTrace((String)"Operations test: UserTransaction.setRollbackOnly - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("UserTransaction_Methods_Test5", "false");
                TestUtil.logTrace((String)"Operations test: UserTransaction.setRollbackOnly - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("UserTransaction_Methods_Test5", "unexpected");
                TestUtil.logTrace((String)("Operations test: UserTransaction.setRollbackOnly - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[12]) {
            try {
                ejbctx.getUserTransaction().setTransactionTimeout(5);
                TestUtil.logTrace((String)"Operations test: UserTransaction.setTransactionTimeout - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("UserTransaction_Methods_Test6", "false");
                TestUtil.logTrace((String)"Operations test: UserTransaction.setTransactionTimeout - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("UserTransaction)_Methods_Test6", "unexpected");
                TestUtil.logTrace((String)("Operations test: UserTransaction.setTransactionTimeout - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[13]) {
            try {
                ejbctx.setRollbackOnly();
                TestUtil.logTrace((String)"Operations test: setRollbackOnly() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("setRollbackOnly", "false");
                TestUtil.logTrace((String)"Operations test: setRollbackOnly() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("setRollbackOnly", "unexpected");
                TestUtil.logTrace((String)("Operations test: setRollbackOnly() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[14]) {
            try {
                ejbctx.getEJBLocalHome();
                TestUtil.logTrace((String)"Operations test: getEJBLocalHome() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("getEJBLocalHome", "false");
                TestUtil.logTrace((String)"Operations test: getEJBLocalHome() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("getEJBLocalHome", "unexpected");
                TestUtil.logTrace((String)("Operations test: getEJBLocalHome() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[15]) {
            try {
                if (beanType == 1) {
                    obj = ((SessionContext)ejbctx).getEJBLocalObject();
                } else if (beanType == 2) {
                    obj = ((EntityContext)ejbctx).getEJBLocalObject();
                }
                TestUtil.logTrace((String)"Operations test: getEJBLocalLocalObject() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("getEJBLocalObject", "false");
                TestUtil.logTrace((String)"Operations test: getEJBLocalObject() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("getEJBLocalObject", "unexpected");
                TestUtil.logTrace((String)("Operations test: getEJBLocalObject() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[16]) {
            try {
                obj = ((EntityContext)ejbctx).getPrimaryKey();
                TestUtil.logTrace((String)"Operations test: getPrimaryKey() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("getPrimaryKey", "false");
                TestUtil.logTrace((String)"Operations test: getPrimaryKey() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("getPrimaryKey", "unexpected");
                TestUtil.logTrace((String)("Operations test: getPrimaryKey() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[17]) {
            try {
                ejbctx.getTimerService();
                TestUtil.logTrace((String)"Operations test: getTimerService() - allowed");
            }
            catch (IllegalStateException e) {
                props.setProperty("getTimerService", "false");
                TestUtil.logTrace((String)"Operations test: getTimerService() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("getTimerService", "unexpected");
                TestUtil.logTrace((String)("Operations test: getTimerService() - not allowed (Unexpected Exception) - " + e));
            }
        }
        if (!skip[18]) {
            try {
                TimerHandle th = timer.getHandle();
                TestUtil.logTrace((String)"Got timer handle");
                if (th != null) {
                    Timer t = th.getTimer();
                    TestUtil.logTrace((String)"Got timer");
                    long tRemaining = t.getTimeRemaining();
                    TestUtil.logTrace((String)("Time remaining is " + tRemaining));
                    Date tNextTimeout = t.getNextTimeout();
                    TestUtil.logTrace((String)("Next timeout is " + tNextTimeout));
                    Integer tInfo = (Integer)t.getInfo();
                    TestUtil.logTrace((String)("Timer info is " + tInfo.toString()));
                    TestUtil.logTrace((String)"Operations test: Timer_Methods() - allowed");
                } else {
                    TestUtil.logTrace((String)"Could not obtain valid timer handle");
                    props.setProperty("Timer_Methods", "false");
                }
            }
            catch (IllegalStateException e) {
                props.setProperty("Timer_Methods", "false");
                TestUtil.logTrace((String)"Operations test: Timer_Methods() - not allowed");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                props.setProperty("Timer_Methods", "unexpected");
                TestUtil.logTrace((String)("Operations test: Timer_Methods() - not allowed (Unexpected Exception) - " + e));
            }
        }
        return props;
    }

    public static boolean checkOperationsTestResults(Properties p, String[] expected, boolean[] skip) {
        TestUtil.logTrace((String)"checkOperationsTestResults");
        TestUtil.logTrace((String)"-----------------------------------------------------");
        boolean pass = true;
        if (p == null) {
            TestUtil.logErr((String)"ERROR: Property object not found");
            return false;
        }
        TestUtil.list((Properties)p);
        if (!skip[0] && !p.getProperty("getEJBHome").equals(expected[0])) {
            TestUtil.logErr((String)"getEJBHome operations test failed");
            pass = false;
        }
        if (!skip[1] && !p.getProperty("getCallerPrincipal").equals(expected[1])) {
            TestUtil.logErr((String)"getCallerPrincipal operations test failed");
            pass = false;
        }
        if (!skip[2] && !p.getProperty("getRollbackOnly").equals(expected[2])) {
            TestUtil.logErr((String)"getRollbackOnly operations test failed");
            pass = false;
        }
        if (!skip[3] && !p.getProperty("isCallerInRole").equals(expected[3])) {
            TestUtil.logErr((String)"isCallerInRole operations test failed");
            pass = false;
        }
        if (!skip[4] && !p.getProperty("getEJBObject").equals(expected[4])) {
            TestUtil.logErr((String)"getEJBObject operations test failed");
            pass = false;
        }
        if (!skip[5] && !p.getProperty("JNDI_Access").equals(expected[5])) {
            TestUtil.logErr((String)"JNDI_Access operations test failed");
            pass = false;
        }
        if (!skip[6] && !p.getProperty("UserTransaction").equals(expected[6])) {
            TestUtil.logErr((String)"UserTransaction operations test failed");
            pass = false;
        }
        if (!skip[7] && !p.getProperty("UserTransaction_Methods_Test1").equals(expected[7])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test1 operations test failed");
            pass = false;
        }
        if (!skip[8] && !p.getProperty("UserTransaction_Methods_Test2").equals(expected[8])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test2 operations test failed");
            pass = false;
        }
        if (!skip[9] && !p.getProperty("UserTransaction_Methods_Test3").equals(expected[9])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test3 operations test failed");
            pass = false;
        }
        if (!skip[10] && !p.getProperty("UserTransaction_Methods_Test4").equals(expected[10])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test4 operations test failed");
            pass = false;
        }
        if (!skip[11] && !p.getProperty("UserTransaction_Methods_Test5").equals(expected[11])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test5 operations test failed");
            pass = false;
        }
        if (!skip[12] && !p.getProperty("UserTransaction_Methods_Test6").equals(expected[12])) {
            TestUtil.logErr((String)"UserTransaction_Methods_Test6 operations test failed");
            pass = false;
        }
        if (!skip[13] && !p.getProperty("setRollbackOnly").equals(expected[13])) {
            TestUtil.logErr((String)"setRollbackOnly operations test failed");
            pass = false;
        }
        if (!skip[14] && !p.getProperty("getEJBLocalHome").equals(expected[14])) {
            TestUtil.logErr((String)"getEJBLocalHome operations test failed");
            pass = false;
        }
        if (!skip[15] && !p.getProperty("getEJBLocalObject").equals(expected[15])) {
            TestUtil.logErr((String)"getEJBLocalObject operations test failed");
            pass = false;
        }
        if (!skip[16] && !p.getProperty("getPrimaryKey").equals(expected[16])) {
            TestUtil.logErr((String)"getPrimaryKey operations test failed");
            pass = false;
        }
        if (!skip[17] && !p.getProperty("getTimerService").equals(expected[17])) {
            TestUtil.logErr((String)"getTimerService operations test failed");
            pass = false;
        }
        if (!skip[18] && !p.getProperty("Timer_Service_Methods").equals(expected[18])) {
            TestUtil.logErr((String)"Timer_Service_Methods operations test failed");
            pass = false;
        }
        if (pass) {
            TestUtil.logTrace((String)"All operation tests passed as expected ...");
        } else {
            TestUtil.logErr((String)"Not All operation tests passed - unexpected ...");
            TestUtil.logTrace((String)"-----------------------------------------------------");
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(Queue queue, QueueConnectionFactory qcFactory, String msg) {
        QueueConnection connection = null;
        try {
            TestUtil.logTrace((String)"getting connection");
            connection = qcFactory.createQueueConnection();
            QueueSession session = connection.createQueueSession(true, 0);
            TestUtil.logTrace((String)"creating sender");
            QueueSender sender = session.createSender(queue);
            connection.start();
            TextMessage message = session.createTextMessage();
            message.setText(msg);
            message.setStringProperty("testName", TestUtil.getProperty((String)"testName"));
            TestUtil.logTrace((String)("Sending message at " + System.currentTimeMillis() + ": " + msg));
            sender.send((Message)message);
        }
        catch (Exception e) {
            TimerImpl.handleException("Error sending message", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    TimerImpl.handleException("Error closing queue connection", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(Queue queue, QueueConnectionFactory qcFactory, long timeout) {
        QueueConnection connection = null;
        try {
            TestUtil.logTrace((String)"getting connection");
            connection = qcFactory.createQueueConnection();
            QueueSession session = connection.createQueueSession(true, 0);
            TestUtil.logTrace((String)"creating receiver");
            QueueReceiver receiver = session.createReceiver(queue);
            connection.start();
            String string = TimerImpl.getMessage(receiver, timeout);
            return string;
        }
        catch (Exception e) {
            TimerImpl.handleException("Error receiving message", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    TimerImpl.handleException("Error closing queue connection", e);
                }
            }
        }
        return NOMSGRECEIVED;
    }

    public static String getMessage(QueueReceiver receiver, long timeout) {
        int retries = 0;
        try {
            do {
                Message m;
                if ((m = receiver.receive(timeout)) == null) {
                    TestUtil.logTrace((String)"no message received");
                    return NOMSGRECEIVED;
                }
                if (m instanceof TextMessage) {
                    TextMessage msg = (TextMessage)m;
                    String message = msg.getText();
                    TestUtil.logTrace((String)("Receiving message at " + System.currentTimeMillis() + ": " + message));
                    String mTestName = msg.getStringProperty("testName");
                    String testName = TestUtil.getProperty((String)"testName");
                    if (testName.equals(mTestName)) {
                        TestUtil.logTrace((String)"test name property of message is correct: accepting");
                        return message;
                    }
                    TestUtil.logErr((String)("message from " + mTestName + " received - ignoring"));
                    ++retries;
                    continue;
                }
                TestUtil.logErr((String)"non-text message received!");
                ++retries;
            } while (retries < 5);
            TestUtil.logTrace((String)("No valid message received after " + retries + " attempts"));
        }
        catch (Exception e) {
            TimerImpl.handleException("Error receiving message", e);
        }
        return NOMSGRECEIVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushQueue(Queue queue, QueueConnectionFactory qcFactory) {
        QueueConnection connection = null;
        String smsg = "end of queue";
        String rmsg = null;
        int priority = 0;
        int numMsgs = 0;
        int numMsgsFlushed = 0;
        try {
            TestUtil.logTrace((String)"Flushing queue: creating connection, session");
            connection = qcFactory.createQueueConnection();
            QueueSession session = connection.createQueueSession(false, 1);
            connection.start();
            TestUtil.logTrace((String)"Browsing queue for unsent messages");
            QueueBrowser qBrowser = session.createBrowser(queue);
            Enumeration msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            qBrowser.close();
            if (numMsgs == 0) {
                TestUtil.logTrace((String)"No Messages to flush - returning");
                return;
            }
            QueueSender sender = session.createSender(queue);
            QueueReceiver receiver = session.createReceiver(queue);
            TextMessage message = session.createTextMessage();
            message.setText(smsg);
            message.setStringProperty("testName", TestUtil.getProperty((String)"testName"));
            sender.send((Message)message, 2, priority, 0L);
            TestUtil.logTrace((String)("message sent: " + message.getText()));
            do {
                Message rmessage;
                if ((rmessage = receiver.receive()) instanceof TextMessage) {
                    rmsg = ((TextMessage)rmessage).getText();
                    TestUtil.logTrace((String)("Message received is " + rmsg));
                } else {
                    TestUtil.logTrace((String)"Non-text message received");
                }
                TestUtil.logTrace((String)("numMsgsFlushed is " + ++numMsgsFlushed));
            } while (!smsg.equals(rmsg));
            TestUtil.logTrace((String)("flushed " + numMsgsFlushed + " messages"));
        }
        catch (Exception e) {
            TimerImpl.handleException("Error cleaning message queue", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    TimerImpl.handleException("Error closing queue connection", e);
                }
            }
        }
    }

    public static void handleException(String msg, Exception e) {
        TestUtil.logErr((String)(msg + ": " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
    }

    protected static long getTimeout() throws TimerImplException {
        long timeout = 0L;
        try {
            timeout = Long.parseLong(TestUtil.getProperty((String)"ejb_timeout"));
        }
        catch (Exception e) {
            TimerImpl.handleException("getTimeout", e);
        }
        if (timeout <= 0L) {
            throw new TimerImplException("Invalid timeout value: " + timeout);
        }
        return timeout;
    }

    protected static Date getExpirationDate() {
        return new Date(System.currentTimeMillis() + 1000000L);
    }
}

