/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry.BusinessQueryManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");
    RegistryService rs2 = null;
    BusinessLifeCycleManager blm2 = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    private boolean findClassificationSchemeByName(String schemeName, String testName) {
        block4: {
            try {
                ArrayList<String> findQualifiers = new ArrayList<String>();
                findQualifiers.add("sortByNameDesc");
                BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
                ClassificationScheme scheme = bqm.findClassificationSchemeByName(findQualifiers, schemeName);
                if (scheme != null) {
                    this.debug.add("name is: " + scheme.getName().getValue());
                    if (!scheme.getName().getValue().equals(schemeName)) {
                        return false;
                    }
                    break block4;
                }
                this.debug.add("Error: null returned!!\n");
                return false;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessQueryManager_findServiceCaseSensitiveMatchTest() throws EETest.Fault {
        String testName = "businessQueryManager_findServiceCaseSensitiveMatchTest";
        boolean pass = false;
        String[] serviceName = new String[]{"businessQueryManager_findCaseSensitiveMatchTest_SellsApples", "businessQueryManager_findCaseSensitiveMatchTest_SELLSAPPLES"};
        String exactMatch = "businessQueryManager_findCaseSensitiveMatchTest_SellsApples";
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Object serviceKey = null;
        Key orgKey2 = null;
        String orgName = "TS Default Organization";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org = (Organization)bqm.getRegistryObject(orgKey2.getId(), "Organization");
            Service service = null;
            Collection services = new ArrayList<Service>();
            for (int i = 0; i < serviceName.length; ++i) {
                service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName[i]));
                org.addService(service);
                services.add(service);
            }
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            ArrayList<Organization> theOrgs = new ArrayList<Organization>();
            theOrgs.add(org);
            br = this.blm.saveOrganizations(theOrgs);
            ArrayList<String> findQualifiers = new ArrayList<String>();
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(exactMatch);
            findQualifiers.add("caseSensitiveMatch");
            this.debug.add(" ====================>   CASE_SENSITIVE_MATCH <==============   \n");
            br = bqm.findServices(orgKey2, findQualifiers, namePatterns, null, null);
            if (br.getExceptions() != null) {
                this.debug.add(" did not complete - findServices error");
            }
            services.clear();
            services = br.getCollection();
            this.debug.add("Count of services returned: " + services.size() + "\n");
            for (Service s : services) {
                this.debug.add("UUID:  returned " + s.getKey().getId() + "\n");
                this.debug.add("service name returned: " + s.getName().getValue(this.tsLocale) + "\n");
                if (!s.getName().getValue(this.tsLocale).equals(exactMatch) || services.size() != 1) continue;
                pass = true;
            }
            try {
                if (serviceKeys != null) {
                    this.blm.deleteServices(serviceKeys);
                }
                if (orgKeys != null) {
                    this.blm.deleteOrganizations(orgKeys);
                }
                if (this.debug != null) {
                    TestUtil.logTrace((String)this.debug.toString());
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)("Caught exception: " + fe.getMessage()));
                fe.printStackTrace();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (serviceKeys != null) {
                    this.blm.deleteServices(serviceKeys);
                }
                if (orgKeys != null) {
                    this.blm.deleteOrganizations(orgKeys);
                }
                if (this.debug != null) {
                    TestUtil.logTrace((String)this.debug.toString());
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)("Caught exception: " + fe.getMessage()));
                fe.printStackTrace();
            }
        }
        if (pass) return;
        throw new EETest.Fault(testName + " failed ");
    }

    public void businessQueryManager_findExactNameMatchTest() throws EETest.Fault {
        String testName = "businessQueryManager_findExactNameMatchTest";
        String exactMatch = "PhoneType";
        String namePattern = "%Type";
        boolean pass = false;
        try {
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("exactNameMatch");
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(exactMatch);
            this.debug.add(" ====================>   EXACT_NAME_MATCH <==============   \n");
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            BulkResponse br = bqm.findClassificationSchemes(findQualifiers, namePatterns, null, null);
            if (br.getExceptions() != null) {
                this.debug.add(" did not complete - findClassificationSchemes error");
            }
            Collection schemes = br.getCollection();
            this.debug.add("Count of schemes returned: " + schemes.size() + "\n");
            for (ClassificationScheme scheme : schemes) {
                this.debug.add("UUID:  returned " + scheme.getKey().getId() + "\n");
                this.debug.add("scheme name returned: " + scheme.getName().getValue() + "\n");
                if (!scheme.getName().getValue().equals(exactMatch)) continue;
                pass = true;
            }
            namePatterns.clear();
            namePatterns.add(namePattern);
            findQualifiers.clear();
            findQualifiers.add("caseSensitiveMatch");
            this.debug.add(" ====================>   CASE_SENSITIVE_MATCH <==============   \n");
            this.getSchemes(namePatterns, findQualifiers);
            findQualifiers.clear();
            findQualifiers.add("sortByNameAsc");
            this.debug.add(" ====================>   SORT_BY_NAME_ASC <==============   \n");
            this.getSchemes(namePatterns, findQualifiers);
            findQualifiers.clear();
            findQualifiers.add("sortByNameDesc");
            this.debug.add(" ====================>   SORT_BY_NAME_DESC <==============   \n");
            this.getSchemes(namePatterns, findQualifiers);
            findQualifiers.clear();
            findQualifiers.add("sortByDateAsc");
            this.debug.add(" ====================>   SORT_BY_DATE_ASC <==============   \n");
            this.getSchemes(namePatterns, findQualifiers);
            findQualifiers.clear();
            findQualifiers.add("sortByDateDesc");
            this.debug.add(" ====================>   SORT_BY_DATE_DESC <==============   \n");
            this.getSchemes(namePatterns, findQualifiers);
            if (!pass) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void getSchemes(Collection namePatterns, Collection findQualifiers) {
        boolean status = false;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            BulkResponse br = bqm.findClassificationSchemes(findQualifiers, namePatterns, null, null);
            if (br.getExceptions() != null) {
                this.debug.add(" did not complete - findClassificationSchemes error");
            }
            Collection schemes = br.getCollection();
            this.debug.add("Count of schemes returned: " + schemes.size() + "\n");
            for (ClassificationScheme scheme : schemes) {
                this.debug.add("UUID:  returned " + scheme.getKey().getId() + "\n");
                this.debug.add("scheme name returned: " + scheme.getName().getValue() + "\n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void businessQueryManager_findClassificationSchemeByNameNullTest() throws EETest.Fault {
        String testName = "businessQueryManager_findClassificationSchemeByNameNullTest";
        ArrayList<String> findQualifiers = new ArrayList<String>();
        findQualifiers.add("exactNameMatch");
        String bogusName = "bogusDummyNameNoMatchHereReturnNullPlease";
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ArrayList names = new ArrayList();
            ClassificationScheme cs = bqm.findClassificationSchemeByName(findQualifiers, bogusName);
            if (cs != null) {
                this.debug.add("Error - Expected null to be returned for name bogusDummyNameNoMatchHereReturnNullPlease\n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Good - Null returned for no match as expected\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void businessQueryManager_findClassificationSchemeByNameMultipleTest() throws EETest.Fault {
        String testName = "businessQueryManager_findClassificationSchemeByNameMultipleTest";
        ArrayList findQualifiers = new ArrayList();
        String multiMatchName = "%";
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ClassificationScheme cs = bqm.findClassificationSchemeByName(null, multiMatchName);
            this.debug.add("[CLIENT] Scheme name returned is: " + cs.getName().getValue() + "\n");
            this.debug.add("Error: findClassificationSchemeByName multiple match should have thrown an InvalidRequestException \n");
            throw new EETest.Fault(testName + " did not return an InvalidRequestException as expected ");
        }
        catch (InvalidRequestException ir) {
            TestUtil.printStackTrace((Throwable)ir);
            this.debug.add("Good - InvalidRequestException thrown expected \n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessQueryManager_findAssociationsTest() throws EETest.Fault {
        String testName = "businessQueryManager_findAssociationsTest";
        String orgTarget = "Org Target";
        String orgSource = "Org Source";
        String type = "RelatedTo";
        BulkResponse br = null;
        Key savekey2222 = null;
        Key assockey = null;
        String objectType = "Organization";
        BusinessQueryManager bqm2 = null;
        Collection<Key> associationKeys = null;
        Collection sourceKeys = null;
        Collection targetKeys = null;
        String targetId = null;
        String sourceId = null;
        boolean pass = false;
        try {
            Concept atype;
            Organization o;
            Association a1;
            this.secondConnection();
            bqm2 = this.rs2.getBusinessQueryManager();
            Organization target = this.blm2.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSource));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(source);
            br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            sourceKeys = br.getCollection();
            for (Key savekey2222 : sourceKeys) {
            }
            sourceId = savekey2222.getId();
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Organization pubSource = (Organization)bqm.getRegistryObject(sourceId, objectType);
            this.debug.add("Verify the pub source retrieved from registry \n");
            this.debug.add("pubSource retrieved: " + pubSource.getName().getValue(this.tsLocale) + "\n");
            orgs.clear();
            orgs.add(target);
            br = this.blm2.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            targetKeys = br.getCollection();
            for (Key savekey2222 : targetKeys) {
            }
            targetId = savekey2222.getId();
            Organization pubTarget = (Organization)bqm2.getRegistryObject(targetId, objectType);
            this.debug.add("Verify the pub target retrieved from registry \n");
            this.debug.add("pubTarget retrieved: " + pubTarget.getName().getValue(this.tsLocale) + "\n");
            Concept associationType = this.getAssociationConcept(type);
            if (associationType == null) {
                throw new EETest.Fault(testName + " getAssociationConcept returned null associationType");
            }
            Association a = this.blm2.createAssociation((RegistryObject)pubTarget, associationType);
            a.setSourceObject((RegistryObject)pubSource);
            this.debug.add("users confirm the association");
            this.blm.confirmAssociation(a);
            this.blm2.confirmAssociation(a);
            Collection associations = new ArrayList<Association>();
            associations.add(a);
            br = this.blm2.saveAssociations(associations, false);
            if (!JAXR_Util.checkBulkResponse("saveAssociations", br, this.debug)) {
                this.debug.add("Error:    saveAssociations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            associationKeys = br.getCollection();
            Iterator iter = associationKeys.iterator();
            Key assocKey = (Key)iter.next();
            this.debug.add("Just got this key from saveAssociations - " + assocKey.getId());
            BulkResponse targetBResp = bqm.findCallerAssociations(null, new Boolean(true), new Boolean(true), null);
            if (targetBResp.getExceptions() == null) {
                Collection targetResult = targetBResp.getCollection();
                this.debug.add("Associations returned from findCallerAssociations is " + targetResult.size() + "\n");
                if (targetResult.size() > 0) {
                    iter = targetResult.iterator();
                    a1 = null;
                    while (iter.hasNext()) {
                        this.debug.add("From Caller Associations \n");
                        a = (Association)iter.next();
                        if (!a.getKey().getId().equals(assocKey.getId())) continue;
                        a1 = a;
                        break;
                    }
                    if (a1 == null) {
                        new EETest.Fault(testName + " did not complete - association is null! ");
                    }
                    o = (Organization)a1.getSourceObject();
                    this.debug.add("Source object " + o.getName().getValue(this.tsLocale) + "\n");
                    o = (Organization)a1.getTargetObject();
                    this.debug.add("Target object " + o.getName().getValue(this.tsLocale) + "\n");
                    atype = a1.getAssociationType();
                    this.debug.add("type is " + atype.getName().getValue() + "\n");
                    this.debug.add("==================================\n");
                }
            }
            br = null;
            ArrayList<String> associationTypes = new ArrayList<String>();
            associationTypes.add(type);
            br = bqm.findAssociations(null, sourceId, targetId, null);
            if (!JAXR_Util.checkBulkResponse("findAssociations", br, this.debug)) {
                this.debug.add("Error:    findAssociations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            associations = null;
            associations = br.getCollection();
            if (associations.size() > 0) {
                iter = associations.iterator();
                a1 = null;
                while (iter.hasNext()) {
                    this.debug.add("From findAssociations \n");
                    a = (Association)iter.next();
                    if (!a.getKey().getId().equals(assocKey.getId())) continue;
                    a1 = a;
                    break;
                }
                if (a1 == null) {
                    new EETest.Fault(testName + " did not complete - association is null! ");
                }
                assockey = a1.getKey();
                o = (Organization)a1.getSourceObject();
                this.debug.add("Source object " + o.getName().getValue(this.tsLocale) + "\n");
                if (o.getName().getValue(this.tsLocale).equals(orgSource)) {
                    this.debug.add("Good - found association with findAssociation \n");
                    pass = true;
                }
                o = (Organization)a1.getTargetObject();
                this.debug.add("Target object " + o.getName().getValue(this.tsLocale) + "\n");
                atype = a1.getAssociationType();
                this.debug.add("type is " + atype.getName().getValue(this.tsLocale) + "\n");
                this.debug.add("==================================\n");
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (assockey != null) {
                        associationKeys = new ArrayList<Key>();
                        associationKeys.add(assockey);
                        this.debug.add(" Cleanup: Remove association\n");
                        this.blm2.deleteAssociations(associationKeys);
                    }
                    this.debug.add(" Cleanup: Remove source organization\n");
                    this.blm.deleteOrganizations(sourceKeys);
                    this.debug.add(" Cleanup: Remove target organization\n");
                    this.blm2.deleteOrganizations(targetKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete registry object\n");
                }
                throw throwable;
            }
        }
        try {
            if (assockey != null) {
                associationKeys = new ArrayList();
                associationKeys.add(assockey);
                this.debug.add(" Cleanup: Remove association\n");
                this.blm2.deleteAssociations(associationKeys);
            }
            this.debug.add(" Cleanup: Remove source organization\n");
            this.blm.deleteOrganizations(sourceKeys);
            this.debug.add(" Cleanup: Remove target organization\n");
            this.blm2.deleteOrganizations(targetKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete registry object\n");
            return;
        }
    }

    public void businessQueryManager_findConceptByPathTest() throws EETest.Fault {
        String testName = "businessQueryManager_findConceptByPathTest";
        boolean pass = true;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Concept serviceConcept = bqm.findConceptByPath("/ObjectType/Service");
            if (serviceConcept.getValue().equals("Service")) {
                this.debug.add("findConceptByPath returned correct concept\n");
            } else {
                this.debug.add("findConceptByPath did not return expected Service concept \n");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    private Concept getAssociationConcept(String associationType) {
        ArrayList<String> atypes = new ArrayList<String>();
        atypes.add("AssociationType");
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Collection associationTypes = bqm.findClassificationSchemes(null, atypes, null, null).getCollection();
            for (ClassificationScheme cs : associationTypes) {
                Collection types = cs.getChildrenConcepts();
                Iterator iter1 = types.iterator();
                Concept concept = null;
                while (iter1.hasNext()) {
                    concept = (Concept)iter1.next();
                    if (!concept.getName().getValue(this.tsLocale).equals(associationType)) continue;
                    return concept;
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.debug.add("getAssociationConcept caught an error!\n");
            return null;
        }
        return null;
    }

    private void secondConnection() throws EETest.Fault {
        Connection srcConnection = null;
        try {
            srcConnection = this.factory.createConnection();
            Set<PasswordAuthentication> credentials = null;
            switch (this.jaxrSecurityCredentialType) {
                case 0: {
                    credentials = new HashSet();
                    PasswordAuthentication passwdAuth = new PasswordAuthentication(this.jaxrUser2, this.jaxrPassword2.toCharArray());
                    credentials.add(passwdAuth);
                    break;
                }
                case 1: {
                    credentials = super.getDigitalCertificateCredentials(this.jaxrAlias2, this.jaxrAlias2Password);
                    break;
                }
                default: {
                    throw new EETest.Fault("second connection failed: jaxrSecurityCredentialType is invalid");
                }
            }
            srcConnection.setCredentials(credentials);
            this.rs2 = srcConnection.getRegistryService();
            this.blm2 = this.rs2.getBusinessLifeCycleManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception in secondConnection method", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessQueryManager_findServiceNameASCTest() throws EETest.Fault {
        String testName = "businessQueryManager_findServiceNameASCTest";
        boolean pass = true;
        String[] serviceName = new String[]{"businessQueryManager_findServiceNameASCTest_Apples", "businessQueryManager_findServiceNameASCTest_Bananas", "businessQueryManager_findServiceNameASCTest_Cherries"};
        String namePattern = "businessQueryManager_findServiceNameASCTest%";
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Object serviceKey = null;
        Key orgKey2 = null;
        String orgName = "TS Default Organization";
        try {
            Organization org22 = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org22);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org22 = (Organization)bqm.getRegistryObject(orgKey2.getId(), "Organization");
            Service service = null;
            Collection services = new ArrayList<Service>();
            for (int i = 0; i < serviceName.length; ++i) {
                service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName[i]));
                org22.addService(service);
                services.add(service);
            }
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            ArrayList<Organization> theOrgs = new ArrayList<Organization>();
            theOrgs.add(org22);
            br = this.blm.saveOrganizations(theOrgs);
            ArrayList<String> findQualifiers = new ArrayList<String>();
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(namePattern);
            findQualifiers.add("sortByNameAsc");
            this.debug.add(" ====================>   SORT_BY_NAME_ASC  <==============   \n");
            br = bqm.findServices(orgKey2, findQualifiers, namePatterns, null, null);
            if (br.getExceptions() != null) {
                this.debug.add(" did not complete - findServices error");
            }
            services.clear();
            services = br.getCollection();
            this.debug.add("Count of services returned: " + services.size() + "\n");
            this.debug.add("Number of services expected: " + serviceName.length + "\n");
            if (services.size() != serviceName.length) {
                pass = false;
            }
            Iterator iter = services.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Service s = (Service)iter.next();
                this.debug.add("UUID:  returned " + s.getKey().getId() + "\n");
                this.debug.add("service name returned: " + s.getName().getValue(this.tsLocale) + "\n");
                if (!s.getName().getValue(this.tsLocale).equals(serviceName[i])) {
                    pass = false;
                }
                ++i;
            }
            try {
                if (serviceKeys != null) {
                    this.blm.deleteServices(serviceKeys);
                }
                if (orgKeys != null) {
                    this.blm.deleteOrganizations(orgKeys);
                }
                if (this.debug != null) {
                    TestUtil.logTrace((String)this.debug.toString());
                }
            }
            catch (Exception org22) {}
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (serviceKeys != null) {
                    this.blm.deleteServices(serviceKeys);
                }
                if (orgKeys != null) {
                    this.blm.deleteOrganizations(orgKeys);
                }
                if (this.debug != null) {
                    TestUtil.logTrace((String)this.debug.toString());
                }
            }
            catch (Exception exception) {}
        }
        if (pass) return;
        throw new EETest.Fault(testName + " failed ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessQueryManager_findServiceNameDESCTest() throws EETest.Fault {
        String testName = "businessQueryManager_findServiceNameDESCTest";
        boolean pass = true;
        String[] serviceName = new String[]{"businessQueryManager_findServiceNameDESCTest_Apples", "businessQueryManager_findServiceNameDESCTest_Bananas", "businessQueryManager_findServiceNameDESCTest_Cherries"};
        String namePattern = "businessQueryManager_findServiceNameDESCTest%";
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Object serviceKey = null;
        Key orgKey2 = null;
        String orgName = "TS Default Organization";
        try {
            Organization org22 = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org22);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org22 = (Organization)bqm.getRegistryObject(orgKey2.getId(), "Organization");
            Service service = null;
            Collection services = new ArrayList<Service>();
            for (int i = 0; i < serviceName.length; ++i) {
                service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName[i]));
                org22.addService(service);
                services.add(service);
            }
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            ArrayList<Organization> theOrgs = new ArrayList<Organization>();
            theOrgs.add(org22);
            br = this.blm.saveOrganizations(theOrgs);
            ArrayList<String> findQualifiers = new ArrayList<String>();
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(namePattern);
            findQualifiers.add("sortByNameDesc");
            this.debug.add(" ====================>   SORT_BY_NAME_DESC  <==============   \n");
            br = bqm.findServices(orgKey2, findQualifiers, namePatterns, null, null);
            if (br.getExceptions() != null) {
                this.debug.add(" did not complete - findServices error");
            }
            services.clear();
            services = br.getCollection();
            this.debug.add("Count of services returned: " + services.size() + "\n");
            this.debug.add("Number of services expected: " + serviceName.length + "\n");
            if (services.size() != serviceName.length) {
                pass = false;
            }
            Iterator iter = services.iterator();
            int i = serviceName.length - 1;
            while (iter.hasNext()) {
                Service s = (Service)iter.next();
                this.debug.add("UUID:  returned " + s.getKey().getId() + "\n");
                this.debug.add("service name returned: " + s.getName().getValue(this.tsLocale) + "\n");
                if (!s.getName().getValue(this.tsLocale).equals(serviceName[i])) {
                    pass = false;
                }
                --i;
            }
            try {
                if (serviceKeys != null) {
                    this.blm.deleteServices(serviceKeys);
                }
                if (orgKeys != null) {
                    this.blm.deleteOrganizations(orgKeys);
                }
                if (this.debug != null) {
                    TestUtil.logTrace((String)this.debug.toString());
                }
            }
            catch (Exception org22) {}
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (serviceKeys != null) {
                    this.blm.deleteServices(serviceKeys);
                }
                if (orgKeys != null) {
                    this.blm.deleteOrganizations(orgKeys);
                }
                if (this.debug != null) {
                    TestUtil.logTrace((String)this.debug.toString());
                }
            }
            catch (Exception exception) {}
        }
        if (pass) return;
        throw new EETest.Fault(testName + " failed ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessQueryManager_nonPrivilegedUserTest() throws EETest.Fault {
        String testName = "businessQueryManager_nonPrivilegedUserTest";
        boolean pass = false;
        Service service = null;
        String[] serviceName = new String[]{"businessQueryManager_nonPrivilegedUserTest-testService1", "businessQueryManager_nonPrivilegedUserTest-testService2", "businessQueryManager_nonPrivilegedUserTest-testService3"};
        String[] retS = new String[]{null, null, null};
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Key orgKey2222 = null;
        String orgName = "TS Default Organization";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2222 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org = (Organization)bqm.getRegistryObject(orgKey2222.getId(), "Organization");
            ArrayList<Service> services = new ArrayList<Service>();
            for (int i = 0; i < serviceName.length; ++i) {
                service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName[i]));
                org.addService(service);
                services.add(service);
            }
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            ArrayList<Organization> theOrgs = new ArrayList<Organization>();
            theOrgs.add(org);
            br = this.blm.saveOrganizations(theOrgs);
            Connection srcConnection = this.factory.createConnection();
            RegistryService rs2 = srcConnection.getRegistryService();
            BusinessQueryManager bqm2 = rs2.getBusinessQueryManager();
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("caseSensitiveMatch");
            findQualifiers.add("sortByNameDesc");
            findQualifiers.add("sortByDateDesc");
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add("%nonPrivilegedUserTest-testService%");
            br = bqm2.findServices(orgKey2222, findQualifiers, namePatterns, null, null);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:   findOrganization   failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            Collection ss = br.getCollection();
            Iterator iter = ss.iterator();
            if (ss.size() != serviceName.length) {
                throw new EETest.Fault(testName + " failed to return expected service count ");
            }
            this.debug.add("Expected number of services returned");
            int i = 0;
            while (iter.hasNext()) {
                Service s = (Service)iter.next();
                this.debug.add(" Found service: : " + s.getName().getValue(this.tsLocale) + "\n");
                retS[i] = s.getName().getValue(this.tsLocale);
                ++i;
            }
            int match = 0;
            int n = 2;
            for (i = 0; i < serviceName.length; ++i) {
                this.debug.add("Now verify descending order returned\n");
                if (!retS[i].equals(serviceName[n--])) continue;
                this.debug.add("match on " + retS[i] + "\n");
                ++match;
            }
            if (match != serviceName.length) {
                throw new EETest.Fault(testName + " failed to return expected sort order of services. ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (serviceKeys != null) {
                        this.blm.deleteServices(serviceKeys);
                        this.debug.add("==>>   Cleanup: delete service\n");
                    }
                    if (orgKeys == null) throw throwable;
                    this.debug.add("==>>  Cleanup: delete organization\n");
                    this.blm.deleteOrganizations(orgKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete organization \n");
                }
                throw throwable;
            }
        }
        try {
            if (serviceKeys != null) {
                this.blm.deleteServices(serviceKeys);
                this.debug.add("==>>   Cleanup: delete service\n");
            }
            if (orgKeys == null) return;
            this.debug.add("==>>  Cleanup: delete organization\n");
            this.blm.deleteOrganizations(orgKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete organization \n");
            return;
        }
    }

    public void businessQueryManager_findRegistryPackagesTest() throws EETest.Fault {
        String testName = "businessQueryManager_findRegistryPackagesTest";
        int failcount = 0;
        int providerlevel = 0;
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            String rpName = "RegistryPackage_" + testName;
            RegistryPackage rp = this.blm.createRegistryPackage(this.blm.createInternationalString(this.tsLocale, rpName));
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + "failed to throw expected UnsupportedCapabilityException.");
            }
            Key rpKey = rp.getKey();
            this.debug.add("RegistryPackage key is: " + rpKey.getId() + "\n");
            String orgName = "Organization_" + testName;
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            String serviceName = "Service_" + testName;
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            Key serviceKey = service.getKey();
            Key orgKey = org.getKey();
            this.debug.add("Service key is: " + serviceKey.getId() + "\n");
            this.debug.add("orgKey is: " + orgKey.getId() + "\n");
            ArrayList<Object> robs = new ArrayList<Object>();
            robs.add(service);
            robs.add(org);
            rp.addRegistryObjects(robs);
            robs.add(rp);
            ArrayList<RegistryPackage> rps = new ArrayList<RegistryPackage>();
            rps.add(rp);
            BulkResponse br = this.blm.saveObjects(robs);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveObjects failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            Collection mySavedObjectKeys = br.getCollection();
            this.debug.add("got back " + mySavedObjectKeys.size() + " objects from save objects\n");
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("exactNameMatch");
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(rpName);
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            br = bqm.findRegistryPackages(findQualifiers, namePatterns, null, null);
            if (!JAXR_Util.checkBulkResponse("findRegistryPackages", br, this.debug)) {
                this.debug.add("Error:    findRegistryPackages failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            Collection myRegPkg = br.getCollection();
            Iterator iter = myRegPkg.iterator();
            this.debug.add("got back " + myRegPkg.size() + " objects from save findRegistryPackages\n");
            while (iter.hasNext()) {
                Object obj = iter.next();
                this.debug.add("what is it? " + obj.getClass().getName() + "\n");
                if (!(obj instanceof RegistryPackage)) continue;
                rp = (RegistryPackage)obj;
                if (rp.getKey().getId().equals(rpKey.getId())) {
                    this.debug.add("Good - findRegistryPackages returned the correct package\n");
                    continue;
                }
                this.debug.add("Not Good - findRegistryPackages did not returned the correct package\n");
                ++failcount;
            }
            Set ros = rp.getRegistryObjects();
            this.debug.add("Number of registry objects in package is " + ros.size() + "\n");
            iter = ros.iterator();
            Service myService = null;
            Organization myOrg = null;
            boolean count = false;
            while (iter.hasNext()) {
                Object o = iter.next();
                this.debug.add("what is it? " + o.getClass().getName() + "\n");
                if (o instanceof Service) {
                    this.debug.add("getRegistryObjects() returned a service\n");
                    Service s = (Service)o;
                    if (s.getKey().getId().equals(serviceKey.getId())) {
                        this.debug.add("Found my service ! \n");
                        myService = s;
                    }
                }
                if (!(o instanceof Organization)) continue;
                this.debug.add("getRegistryObjects() returned an organization \n");
                Organization orgn = (Organization)o;
                if (!orgn.getKey().getId().equals(orgKey.getId())) continue;
                myOrg = orgn;
                this.debug.add("Found my org! \n");
            }
            if (myService == null) {
                ++failcount;
                this.debug.add("Error -  could not find the service in the registry package \n");
            }
            if (myOrg == null) {
                ++failcount;
                this.debug.add("Error -  could not find the organization in the registry package \n");
            }
            ArrayList<Key> keys = new ArrayList<Key>();
            keys.add(rpKey);
            keys.add(serviceKey);
            keys.add(orgKey);
            br = this.blm.deleteObjects(keys);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    deleteObjects failed \n");
            }
            if (failcount > 0) {
                throw new EETest.Fault(testName + " failed - ");
            }
        }
        catch (UnsupportedCapabilityException uce) {
            if (providerlevel != 0) {
                TestUtil.logErr((String)("Cleanup error: " + uce.toString()));
                TestUtil.printStackTrace((Throwable)uce);
                throw new EETest.Fault(testName + " failed - unexpected UnsupportedCapabilityException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

