/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.standalone.war;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Client
extends EETest {
    public static final String urlLookup = "java:comp/env/url/myURL";
    public static final String jspPropName = "standalone_war";
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            TestUtil.logTrace((String)"[Client] Getting Naming Context...");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:" + e, e);
        }
    }

    public void testStandaloneWar() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"[Client] looking up java:comp/env/url/myURL");
            URL myUrl = (URL)this.nctx.lookup(urlLookup);
            TestUtil.logTrace((String)"[Client] get a new URL connection...");
            URLConnection urlConnection = myUrl.openConnection();
            Properties jspProps = TestUtil.getResponseProperties((URLConnection)urlConnection);
            String value = jspProps.getProperty(jspPropName);
            boolean bl = pass = null != value && value.equals("true");
            if (!pass) {
                throw new EETest.Fault("Standalone war test failed: standalone_war = " + (null == value ? "null" : value) + ", expected 'true'!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Stand-alone test failed: " + e);
            throw new EETest.Fault("Stand-alone test failed: ", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

