/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry.QueryManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void queryManager_getRegistryObject() throws EETest.Fault {
        String testName = "queryManager_getRegistryObject";
        String objectType = "Organization";
        Key savekey2 = null;
        Collection orgKeys = null;
        BusinessQueryManager bqm = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            Organization org = (Organization)this.blm.createObject("Organization");
            org.setName(this.blm.createInternationalString(this.tsLocale, "TS Default Organization"));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            for (Key savekey2 : orgKeys) {
            }
            String id = savekey2.getId();
            Organization retOrg = (Organization)bqm.getRegistryObject(id, objectType);
            if (retOrg == null) {
                throw new EETest.Fault(testName + " failed - retOrg is null!");
            }
            this.debug.add("Verify that the organization returned by getCollection matches \n");
            this.debug.add("name of returned org: " + retOrg.getName().getValue(this.tsLocale) + "\n");
            this.debug.add("name of save org: TS Default Organization\n");
            if (!retOrg.getName().getValue(this.tsLocale).equals("TS Default Organization")) {
                throw new EETest.Fault(testName + " failed - did not expected organization ");
            }
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
            }
            catch (Throwable throwable) {
                super.cleanUpRegistry(orgKeys, "Organization");
                throw throwable;
            }
        }
    }

    public void queryManager_getRegistryObjects() throws EETest.Fault {
        String testName = "queryManager_getRegistryObjects";
        Key savekey2 = null;
        boolean pass = false;
        BusinessQueryManager bqm = null;
        Collection orgKeys = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            Organization org = (Organization)this.blm.createObject("Organization");
            org.setName(this.blm.createInternationalString(this.tsLocale, "TS Default Organization"));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            for (Key savekey2 : orgKeys) {
            }
            String myKeyId = savekey2.getId();
            this.debug.add("Saved Organization key id is: " + myKeyId + "\n");
            br = bqm.getRegistryObjects();
            Collection myObjects = br.getCollection();
            Iterator iter = myObjects.iterator();
            RegistryObject ro = null;
            this.debug.add("Number of objects returned: " + myObjects.size() + "\n");
            while (iter.hasNext()) {
                ro = (RegistryObject)iter.next();
                this.debug.add("Object to string is " + ro.toString() + "\n");
                this.debug.add("Object keyId is " + ro.getKey().getId() + "\n");
                if (!ro.getKey().getId().equals(myKeyId)) continue;
                pass = true;
                break;
            }
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
            }
            catch (Throwable throwable) {
                super.cleanUpRegistry(orgKeys, "Organization");
                throw throwable;
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void queryManager_getRegistryObjectsSpecifiedType() throws EETest.Fault {
        String testName = "queryManager_getRegistryObjectsSpecifiedType";
        Key orgkey2 = null;
        BusinessQueryManager bqm = null;
        String myServiceName = "TS default Service";
        Collection orgKeys = null;
        boolean pass = false;
        try {
            bqm = this.rs.getBusinessQueryManager();
            this.debug.add("Create a service and an organization \n");
            Service service = this.blm.createService(myServiceName);
            ArrayList<Service> myServices = new ArrayList<Service>();
            Organization org = (Organization)this.blm.createObject("Organization");
            org.setName(this.blm.createInternationalString(this.tsLocale, "TS Default Organization"));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            this.debug.add("Save the organization and get the key id from getCollection\n");
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            for (Key orgkey2 : orgKeys) {
            }
            String orgKeyId = orgkey2.getId();
            this.debug.add("Saved Organization key id is: " + orgKeyId + "\n");
            this.debug.add("Call getRegistryObjects to get all owned objects\n");
            br = bqm.getRegistryObjects();
            this.debug.add("Find the saved organization and add the service to it \n");
            Collection ros = br.getCollection();
            Organization o = null;
            Iterator iter = ros.iterator();
            String regKeyId = null;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof Organization) || !(o = (Organization)obj).getKey().getId().equals(orgKeyId)) continue;
                this.debug.add("Found the organization\n");
                regKeyId = o.getKey().getId();
                o.addService(service);
                myServices.add(service);
                break;
            }
            if (o == null) {
                this.debug.add("Error: failed to get the Organization with getRegistryObjects \n");
                throw new EETest.Fault(testName + " failed");
            }
            this.debug.add("save the service to the registry \n");
            br = this.blm.saveServices(myServices);
            Key servicekey2 = null;
            Collection serviceKeys = br.getCollection();
            this.debug.add("The number of service keys returned from getCollection is: " + serviceKeys.size() + "\n");
            for (Key servicekey2 : serviceKeys) {
            }
            this.debug.add("Save the service key returned from saveServices\n");
            String serviceKeyId = servicekey2.getId();
            this.debug.add("Saved Service key id is: " + serviceKeyId + "\n");
            this.debug.add("request service objects with getRegistryObjects(LifeCycleManager.SERVICE) \n");
            br = bqm.getRegistryObjects("Service");
            Collection myObjects = br.getCollection();
            this.debug.add("Count of objects returned from service request is: " + myObjects.size() + "\n");
            if (myObjects.size() == 0) {
                throw new EETest.Fault(testName + " failed - nothing returned from getRegistryObjects");
            }
            iter = myObjects.iterator();
            RegistryObject ro = null;
            while (iter.hasNext()) {
                ro = (RegistryObject)iter.next();
                if (ro instanceof Service) {
                    this.debug.add(" ro is a Service \n");
                    if (!ro.getKey().getId().equals(serviceKeyId)) continue;
                    this.debug.add("Got back my service - Good! \n");
                    pass = true;
                    continue;
                }
                if (ro instanceof Service) continue;
                this.debug.add(" returned ro not a service! " + ro.toString() + "\n");
                throw new EETest.Fault(testName + " failed");
            }
            this.debug.add("cleanup at test end \n");
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
            }
            catch (Throwable throwable) {
                this.debug.add("cleanup at test end \n");
                super.cleanUpRegistry(orgKeys, "Organization");
                throw throwable;
            }
        }
        super.cleanUpRegistry(orgKeys, "Organization");
        if (!pass) {
            new EETest.Fault(testName + " failed - did not find service.");
        }
    }

    /*
     * Loose catch block
     */
    public void queryManager_getRegistryObjectStringId() throws EETest.Fault {
        block12: {
            String testName = "queryManager_getRegistryObjectStringId";
            String objectType = "Organization";
            Key savekey2222222222 = null;
            Collection orgKeys = null;
            BusinessQueryManager bqm = null;
            int providerlevel = 0;
            try {
                bqm = this.rs.getBusinessQueryManager();
                providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                Organization org = (Organization)this.blm.createObject("Organization");
                String orgName = testName + "_testOrganization";
                org.setName(this.blm.createInternationalString(this.tsLocale, orgName));
                ArrayList<Organization> orgs = new ArrayList<Organization>();
                orgs.add(org);
                BulkResponse br = this.blm.saveOrganizations(orgs);
                orgKeys = br.getCollection();
                for (Key savekey2222222222 : orgKeys) {
                }
                String id = savekey2222222222.getId();
                Organization retOrg = (Organization)bqm.getRegistryObject(id);
                if (providerlevel == 0) {
                    throw new EETest.Fault(testName + " failed - level 0 providers must throw UnsupportedCapabilityException");
                }
                if (retOrg == null) {
                    throw new EETest.Fault(testName + " failed - retOrg is null!");
                }
                this.debug.add("Verify that the organization returned by getCollection matches \n");
                this.debug.add("name of returned org: " + retOrg.getName().getValue(this.tsLocale) + "\n");
                this.debug.add("name of save org: " + orgName + "\n");
                if (!retOrg.getName().getValue(this.tsLocale).equals(orgName)) {
                    throw new EETest.Fault(testName + " failed - did not expected organization ");
                }
                super.cleanUpRegistry(orgKeys, "Organization");
            }
            catch (UnsupportedCapabilityException uc) {
                if (providerlevel == 0) {
                    this.debug.add(" Call to getRegistryObject(id) threw UnsupportedCapabilityException as expected\n");
                    break block12;
                }
                throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                super.cleanUpRegistry(orgKeys, "Organization");
            }
        }
    }

    /*
     * Loose catch block
     */
    public void queryManager_getRegistryObjectsLevel1() throws EETest.Fault {
        block22: {
            String testName = "queryManager_getRegistryObjectsLevel1";
            Key savekey2222222222 = null;
            int passCount = 0;
            BusinessQueryManager bqm = null;
            Collection orgKeys = null;
            Collection servicekeys = null;
            int providerlevel = 0;
            bqm = this.rs.getBusinessQueryManager();
            Organization org = (Organization)this.blm.createObject("Organization");
            String orgName = testName + "_testOrganization";
            org.setName(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            for (Key savekey2222222222 : orgKeys) {
            }
            String myKeyId = savekey2222222222.getId();
            this.debug.add("Saved Organization key id is: " + myKeyId + "\n");
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            br = bqm.getRegistryObjects(orgKeys);
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + " failed - level 0 providers must throw UnsupportedCapabilityException");
            }
            Collection myObjects = br.getCollection();
            Iterator iter = myObjects.iterator();
            RegistryObject ro = null;
            this.debug.add("Number of objects returned: " + myObjects.size() + "\n");
            while (iter.hasNext()) {
                ro = (RegistryObject)iter.next();
                this.debug.add("Object to string is " + ro.toString() + "\n");
                this.debug.add("Object keyId is " + ro.getKey().getId() + "\n");
                if (!ro.getKey().getId().equals(myKeyId)) continue;
                this.debug.add("good - retrieved my organization \n");
                ++passCount;
                break;
            }
            String serviceName = testName + "_testService";
            Service service = this.blm.createService(serviceName);
            ArrayList<Service> services = new ArrayList<Service>();
            services.add(service);
            Key serviceKey = service.getKey();
            br = this.blm.saveObjects(services);
            servicekeys = br.getCollection();
            ArrayList regKeys = new ArrayList();
            regKeys.addAll(orgKeys);
            regKeys.addAll(servicekeys);
            br = bqm.getRegistryObjects(regKeys);
            myObjects.clear();
            myObjects = br.getCollection();
            iter = myObjects.iterator();
            ro = null;
            this.debug.add("Number of objects returned: " + myObjects.size() + "\n");
            while (iter.hasNext()) {
                ro = (RegistryObject)iter.next();
                this.debug.add("Object to string is " + ro.toString() + "\n");
                this.debug.add("Object keyId is " + ro.getKey().getId() + "\n");
                if (ro.getKey().getId().equals(myKeyId)) {
                    this.debug.add("good - retrieved my organization \n");
                    ++passCount;
                }
                if (!ro.getKey().getId().equals(serviceKey.getId())) continue;
                this.debug.add("good - retrieved my service \n");
                ++passCount;
            }
            if (passCount != 3) {
                throw new EETest.Fault(testName + " failed");
            }
            this.debug.add("finally - delete organization \n");
            super.cleanUpRegistry(orgKeys, "Organization");
            try {
                if (servicekeys != null) {
                    this.debug.add("finally - delete service \n");
                    this.blm.deleteObjects(servicekeys, "Service");
                }
                break block22;
            }
            catch (JAXRException je) {
                this.debug.add(testName + " unexpected error during cleanup was caught \n");
            }
            break block22;
            catch (UnsupportedCapabilityException uc) {
                if (providerlevel == 0) {
                    this.debug.add(" Call to getRegistryObject(id) threw UnsupportedCapabilityException as expected\n");
                    break block22;
                }
                throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.debug.add("finally - delete organization \n");
                super.cleanUpRegistry(orgKeys, "Organization");
                try {
                    if (servicekeys != null) {
                        this.debug.add("finally - delete service \n");
                        this.blm.deleteObjects(servicekeys, "Service");
                    }
                }
                catch (JAXRException je) {
                    this.debug.add(testName + " unexpected error during cleanup was caught \n");
                }
            }
        }
    }
}

