/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.dateformat;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.AnnotatedAccessorsDateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.AnnotatedFieldDateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.AnnotatedTypeDateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.AnnotatedTypeFieldOverrideDateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.DateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.customized.CustomizedPackageDateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.customized.CustomizedPackageTypeOverrideDateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.dateformat.model.customized.CustomizedPackageTypeOverrideFieldOverrideDateContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.annotation.JsonbDateFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class DateFormatCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        DateFormatCustomizationTest t = new DateFormatCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testDateFormatConfig() throws EETest.Fault {
        String toMatch;
        Date instance;
        String format = "E DD MMM yyyy HH:mm:ss z";
        Locale locale = Locale.GERMAN;
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat(format, locale));
        String jsonString = jsonb.toJson((Object)new DateContainer(instance = new Date(0L)){
            final /* synthetic */ Date val$instance;
            {
                this.val$instance = date;
                this.setInstance(this.val$instance);
            }
        });
        if (!jsonString.matches(toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format, locale, instance))) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly customize date format during marshalling using JsonbConfig.withDateFormat.");
        }
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        DateContainer unmarshalledObject = (DateContainer)jsonb.fromJson(json, DateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly customize date format during unmarshalling using JsonbConfig.withDateFormat.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatPackage() throws EETest.Fault {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new CustomizedPackageDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnPackage(CustomizedPackageDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on package.");
        }
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 CET\" }", DateFormatCustomizationTest.getDay("19700001", Locale.ITALY));
        CustomizedPackageDateContainer unmarshalledObject = (CustomizedPackageDateContainer)this.jsonb.fromJson(json, CustomizedPackageDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalledObject").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on package.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatType() throws EETest.Fault {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedTypeDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotation(AnnotatedTypeDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on type.");
        }
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        AnnotatedTypeDateContainer unmarshalledObject = (AnnotatedTypeDateContainer)this.jsonb.fromJson(json, AnnotatedTypeDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on type.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatField() throws EETest.Fault {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedFieldDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(AnnotatedFieldDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on field.");
        }
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        AnnotatedFieldDateContainer unmarshalledObject = (AnnotatedFieldDateContainer)this.jsonb.fromJson(json, AnnotatedFieldDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on field.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatAccessors() throws EETest.Fault {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedAccessorsDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnMethod(AnnotatedAccessorsDateContainer.class, JsonbDateFormat.class, "getInstance", new Class[0]);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on getter.");
        }
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 MEZ\" }", DateFormatCustomizationTest.getDay("19700001", Locale.GERMAN));
        AnnotatedAccessorsDateContainer unmarshalledObject = (AnnotatedAccessorsDateContainer)this.jsonb.fromJson(json, AnnotatedAccessorsDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on setter.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatConfigPackageOverride() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat("E DD MMM yyyy HH:mm:ss z", Locale.GERMAN));
        final Date instance = new Date(0L);
        String jsonString = jsonb.toJson((Object)new CustomizedPackageDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnPackage(CustomizedPackageDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbConfig.withDateFormat during marshalling by annotating package with JsonbDateFormat.");
        }
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 CET\" }", DateFormatCustomizationTest.getDay("19700001", Locale.ITALY));
        CustomizedPackageDateContainer unmarshalledObject = (CustomizedPackageDateContainer)jsonb.fromJson(json, CustomizedPackageDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbConfig.withDateFormat during unmarshalling by annotating package with JsonbDateFormat.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatPackageTypeOverride() throws EETest.Fault {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new CustomizedPackageTypeOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotation(CustomizedPackageTypeOverrideDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbDateFormat annotation on package during marshalling using JsonbDateFormat annotation on type.");
        }
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideDateContainer)this.jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbDateFormat annotation on package during unmarshalling using JsonbDateFormat annotation on type.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatTypeFieldOverride() throws EETest.Fault {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new AnnotatedTypeFieldOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(AnnotatedTypeFieldOverrideDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly customize date format during marshalling using JsonbDateFormat annotation on type.");
        }
        String json = String.format("{ \"instance\" : \"%s 1970 01:00:00 CET\" }", DateFormatCustomizationTest.getDay("19700001", Locale.ITALY));
        AnnotatedTypeFieldOverrideDateContainer unmarshalledObject = (AnnotatedTypeFieldOverrideDateContainer)this.jsonb.fromJson(json, AnnotatedTypeFieldOverrideDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly customize date format during unmarshalling using JsonbDateFormat annotation on type.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatConfigPackageOverrideTypeOverride() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat("E DD MMM yyyy HH:mm:ss z", Locale.CANADA));
        final Date instance = new Date(0L);
        String jsonString = jsonb.toJson((Object)new CustomizedPackageTypeOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotation(CustomizedPackageTypeOverrideDateContainer.class, JsonbDateFormat.class);
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbConfig.withDateFormat and package annotating with JsonbDateFormat during marshalling by annotating type with JsonbDateFormat.");
        }
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideDateContainer)jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbConfig.withDateFormat and package annotating with JsonbDateFormat during unmarshalling by annotating type with JsonbDateFormat.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatPackageTypeOverrideFieldOverride() throws EETest.Fault {
        final Date instance = new Date(0L);
        String jsonString = this.jsonb.toJson((Object)new CustomizedPackageTypeOverrideFieldOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(CustomizedPackageTypeOverrideFieldOverrideDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbDateFormat annotation on package and type during marshalling using JsonbDateFormat annotation on field.");
        }
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideFieldOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideFieldOverrideDateContainer)this.jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideFieldOverrideDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbDateFormat annotation on package and type during unmarshalling using JsonbDateFormat annotation on field.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDateFormatConfigPackageOverrideTypeOverrideFieldOverride() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withDateFormat("E DD MMM yyyy HH:mm:ss z", Locale.GERMAN));
        final Date instance = new Date(0L);
        JsonbDateFormat format = DateFormatCustomizationTest.getAnnotationOnField(CustomizedPackageTypeOverrideFieldOverrideDateContainer.class, JsonbDateFormat.class, "instance");
        Locale locale = new Locale.Builder().setLanguage(format.locale()).build();
        String toMatch = this.completeByFormat("\\{\\s*\"instance\"\\s*:\\s*", "\\s*\\}", format.value(), locale, instance);
        String jsonString = jsonb.toJson((Object)new CustomizedPackageTypeOverrideFieldOverrideDateContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches(toMatch)) {
            System.out.append("jsonString").println(jsonString);
            System.out.append("does not match").println(toMatch);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbConfig.withDateFormat and package and type annotating with JsonbDateFormat during marshalling by annotating field with JsonbDateFormat.");
        }
        toMatch = this.completeByFormat("{ \"instance\" : ", " }", format.value(), locale, instance);
        CustomizedPackageTypeOverrideFieldOverrideDateContainer unmarshalledObject = (CustomizedPackageTypeOverrideFieldOverrideDateContainer)jsonb.fromJson(toMatch, CustomizedPackageTypeOverrideFieldOverrideDateContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            System.out.append("unmarshalled Object").println(unmarshalledObject.getInstance());
            System.out.append("does not match").println(instance);
            throw new EETest.Fault("Failed to correctly override date format customization using JsonbConfig.withDateFormat and package and type annotating with JsonbDateFormat during unmarshalling by annotating field with JsonbDateFormat.");
        }
        return Status.passed((String)"OK");
    }

    private String completeByFormat(String prefix, String suffix, String mask, Locale locale, Date value) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append('\"').append(this.format(mask, locale, value)).append('\"').append(suffix);
        return sb.toString();
    }

    private String format(String mask, Locale locale, Date value) {
        DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendPattern(mask).toFormatter(locale);
        return dtf.format(ZonedDateTime.ofInstant(value.toInstant(), ZoneId.of("UTC")));
    }

    private static <T extends Annotation> T getAnnotation(Class<?> clz, Class<T> annotation) throws EETest.Fault {
        return DateFormatCustomizationTest.getAnnotationOnElement(clz, annotation);
    }

    private static <T extends Annotation> T getAnnotationOnMethod(Class<?> clz, Class<T> annotation, String methodName, Class<?> ... params) throws EETest.Fault {
        try {
            Method m = clz.getDeclaredMethod(methodName, params);
            return DateFormatCustomizationTest.getAnnotationOnElement(m, annotation);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new EETest.Fault(e);
        }
    }

    private static <T extends Annotation> T getAnnotationOnField(Class<?> clz, Class<T> annotation, String fieldName) throws EETest.Fault {
        try {
            Field f = clz.getDeclaredField(fieldName);
            return DateFormatCustomizationTest.getAnnotationOnElement(f, annotation);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new EETest.Fault(e);
        }
    }

    private static <T extends Annotation> T getAnnotationOnPackage(Class<?> clz, Class<T> annotation) throws EETest.Fault {
        try {
            Package p = clz.getPackage();
            return DateFormatCustomizationTest.getAnnotationOnElement(p, annotation);
        }
        catch (SecurityException e) {
            throw new EETest.Fault(e);
        }
    }

    private static <T extends Annotation> T getAnnotationOnElement(AnnotatedElement e, Class<T> annotation) throws EETest.Fault {
        Annotation[] a = e.getAnnotationsByType(annotation);
        if (a == null || a.length == 0) {
            throw new EETest.Fault("No " + annotation.getName() + " annotation on " + e.toString());
        }
        if (a.length != 1) {
            throw new EETest.Fault("Too many " + annotation.getName() + " annotation on " + e.toString());
        }
        return (T)a[0];
    }

    private static String getDay(String yyyymmdd, Locale locale) {
        Calendar c = Calendar.getInstance(locale);
        c.set(1, Integer.parseInt(yyyymmdd.substring(0, 4)));
        c.set(2, Integer.parseInt(yyyymmdd.substring(4, 6)));
        c.set(5, Integer.parseInt(yyyymmdd.substring(6, 8)));
        SimpleDateFormat sdf = new SimpleDateFormat("EEE' 'dd' 'MMM", locale);
        return sdf.format(c.getTime());
    }
}

