/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmscontexttopictests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmscontexttopictests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient JmsTool tool2 = null;
    private transient ConnectionFactory cf = null;
    private transient ConnectionFactory cf2 = null;
    private transient Topic topic = null;
    private transient Destination destination = null;
    private transient Topic topic2 = null;
    private transient Destination destination2 = null;
    private transient JMSContext context = null;
    private transient JMSContext context2 = null;
    private transient JMSProducer producer = null;
    private transient JMSProducer producer2 = null;
    private transient JMSConsumer consumer = null;
    private transient JMSConsumer consumer2 = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    String vehicle;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList connections = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            TestUtil.logTrace((String)("JMSVersion=" + tmp2));
            if (!tmp2.equals("3.0")) {
                TestUtil.logErr((String)("Error: incorrect JMSVersion=" + tmp2));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            TestUtil.logTrace((String)("JMSMajorVersion=" + tmp3));
            if (tmp3 != 3) {
                TestUtil.logErr((String)("Error: incorrect JMSMajorVersion=" + tmp3));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            TestUtil.logTrace((String)("JMSMinorVersion=" + tmp4));
            if (tmp4 != 0) {
                TestUtil.logErr((String)("Error: incorrect JMSMinorVersion=" + tmp4));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            TestUtil.logTrace((String)("JMSProviderName=" + tmp));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            TestUtil.logTrace((String)("JMSProviderVersion=" + tmp));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            TestUtil.logTrace((String)("ProviderMajorVersion=" + tmp5));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            TestUtil.logTrace((String)("ProviderMinorVersion=" + tmp6));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        this.logTrace("Results: " + status[index]);
        return retcode;
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            String lookupDurableTopicFactory = "DURABLE_SUB_CONNECTION_FACTORY";
            String lookupNormalTopicFactory = "MyTopicConnectionFactory";
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.vehicle = p.getProperty("vehicle");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.connections = new ArrayList(5);
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T and normal topic connection factory");
            this.tool = new JmsTool(14, this.user, this.password, lookupNormalTopicFactory, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producer = this.context.createProducer();
            this.consumer = this.context.createConsumer((Destination)this.topic);
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T and durable topic connection factory");
            this.tool2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.tool2.getDefaultConnection().close();
            this.cf2 = this.tool2.getConnectionFactory();
            this.destination2 = this.tool2.getDefaultDestination();
            this.topic2 = (Topic)this.destination2;
            this.context2 = this.cf2.createContext(this.user, this.password, 1);
            this.producer2 = this.context2.createProducer();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.context2 != null) {
                this.context2.close();
                this.context2 = null;
            }
            this.producer2 = null;
            this.producer = null;
            TestUtil.logMsg((String)"Close JMSConsumer Objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            if (this.tool != null) {
                this.tool.closeAllResources();
                this.tool = null;
            }
            if (this.tool2 != null) {
                this.tool2.closeAllResources();
                this.tool2 = null;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
    }

    private void cleanupSubscription(JMSConsumer consumer, JMSContext context, String subName) {
        if (consumer != null) {
            try {
                TestUtil.logTrace((String)("Closing durable consumer: " + consumer));
                consumer.close();
                consumer = null;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception during JMSConsumer.close: ", (Throwable)e);
            }
        }
        if (context != null) {
            try {
                TestUtil.logTrace((String)("Unsubscribing \"" + subName + "\""));
                context.unsubscribe(subName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception during JMSContext.unsubscribe: ", (Throwable)e);
            }
        }
    }

    public void createTemporayTopicTest() throws EETest.Fault {
        boolean pass = true;
        JMSConsumer consumer = null;
        try {
            String sendMessage = "a text message";
            TestUtil.logMsg((String)"Creating TemporaryTopic");
            TemporaryTopic tempTopic = this.context.createTemporaryTopic();
            TestUtil.logMsg((String)"Create JMSConsumer for TemporaryTopic.");
            consumer = this.context.createConsumer((Destination)tempTopic);
            TestUtil.logMsg((String)"Send message to temporary topic");
            this.producer.send((Destination)tempTopic, sendMessage);
            TestUtil.logMsg((String)"Receive message from temporaty topic");
            String recvMessage = (String)consumer.receiveBody(String.class, this.timeout);
            TestUtil.logMsg((String)"Checking received message");
            if (recvMessage == null) {
                throw new EETest.Fault("Did not receive Message");
            }
            TestUtil.logMsg((String)"Verify correct message received.");
            if (!recvMessage.equals(sendMessage)) {
                TestUtil.logErr((String)("unexpected message: received " + recvMessage + " , expected " + sendMessage));
                pass = false;
            } else {
                TestUtil.logMsg((String)("received correct message: " + recvMessage + " as expected"));
            }
            TestUtil.logMsg((String)"Attempting to delete temporary topic with an open consumer should not be allowed");
            try {
                tempTopic.delete();
                pass = false;
                TestUtil.logErr((String)"TemporaryTopic.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                TestUtil.logTrace((String)"Received expected JMSException: ");
            }
            TestUtil.logMsg((String)"Now close the open consumer");
            try {
                consumer.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception closing JMSConsumer: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Attempting to delete temporary topic with no open consumer should be allowed");
            try {
                tempTopic.delete();
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("createTemporayTopicTest");
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createTemporayTopicTest failed");
        }
    }

    public void getMetaDataTest() throws EETest.Fault {
        boolean pass = true;
        ConnectionMetaData data = null;
        try {
            data = this.context.getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getMetaDataTest failed");
        }
    }

    public void getSessionModeTest() throws EETest.Fault {
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password);
            int expSessionMode = 1;
            TestUtil.logMsg((String)("Calling getSessionMode and expect " + expSessionMode + " to be returned"));
            int actSessionMode = context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                TestUtil.logErr((String)("getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("getSessionModeTest");
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception exception) {}
        }
        int[] expSessionMode = new int[]{0, 1, 2, 3};
        for (int i = 0; i < expSessionMode.length; ++i) {
            if (!(!this.vehicle.equals("ejb") && !this.vehicle.equals("jsp") && !this.vehicle.equals("servlet") || expSessionMode[i] != 0 && expSessionMode[i] != 2)) continue;
            try {
                TestUtil.logMsg((String)("Creating context with session mode (" + expSessionMode[i] + ")"));
                context = this.cf.createContext(this.user, this.password, expSessionMode[i]);
                TestUtil.logMsg((String)("Calling getSessionMode and expect " + expSessionMode[i] + " to be returned"));
                int actSessionMode = context.getSessionMode();
                if (actSessionMode == expSessionMode[i]) continue;
                TestUtil.logErr((String)("getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode[i]));
                pass = false;
                continue;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getSessionModeTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("getSessionModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTransactedTest() throws EETest.Fault {
        boolean actTransacted;
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password, 1);
            boolean expTransacted = false;
            TestUtil.logMsg((String)("Calling getTransacted and expect " + expTransacted + " to be returned"));
            actTransacted = context.getTransacted();
            if (actTransacted != expTransacted) {
                TestUtil.logErr((String)("getTransacted() returned " + actTransacted + ", expected " + expTransacted));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                context = this.cf.createContext(this.user, this.password, 0);
                boolean expTransacted = true;
                TestUtil.logMsg((String)("Calling getTransacted and expect " + expTransacted + " to be returned"));
                actTransacted = context.getTransacted();
                if (actTransacted != expTransacted) {
                    TestUtil.logErr((String)("getTransacted() returned " + actTransacted + ", expected " + expTransacted));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("getTransactedTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("getTransactedTest failed");
        }
    }

    public void setGetAutoStartTest() throws EETest.Fault {
        boolean actAutoStart;
        boolean expAutoStart;
        boolean pass = true;
        try {
            expAutoStart = true;
            TestUtil.logMsg((String)("Calling getAutoStart and expect " + expAutoStart + " to be returned"));
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                TestUtil.logErr((String)("getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        try {
            expAutoStart = false;
            TestUtil.logMsg((String)("Calling setAutoStart(" + expAutoStart + ")"));
            this.context.setAutoStart(expAutoStart);
            TestUtil.logMsg((String)("Calling getAutoStart and expect " + expAutoStart + " to be returned"));
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                TestUtil.logErr((String)("getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("setGetAutoStartTest");
        }
        if (!pass) {
            throw new EETest.Fault("setGetAutoStartTest failed");
        }
    }

    public void createConsumerTest() throws EETest.Fault {
        boolean pass = true;
        JMSConsumer consumerSelect = null;
        try {
            int i;
            TextMessage tempMsg = null;
            Object msgs = null;
            TestUtil.logMsg((String)"Create selective JMSConsumer with selector [\"lastMessage=TRUE\"]");
            consumerSelect = this.context.createConsumer(this.destination, "lastMessage=TRUE");
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                if (i == 3) {
                    TestUtil.logMsg((String)"Set boolean property lastMessage=true");
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    TestUtil.logMsg((String)"Set boolean property lastMessage=false");
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive last message with selective JMSConsumer and boolean property lastMessage=true");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                TestUtil.logErr((String)"Message 3 missing from Topic");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + 3 + "]"));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Try receiving one more message (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("JMSConsumer received message " + tempMsg.getText() + " (Expected None)"));
                TestUtil.logErr((String)"JMSConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Received no more messages (CORRECT)");
            }
            consumerSelect.close();
            consumerSelect = null;
            TestUtil.logMsg((String)"Receive rest of messages with normal JMSConsumer");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Topic"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            TestUtil.logMsg((String)"Try receiving one more message (should get none)");
            if (tempMsg != null) {
                TestUtil.logErr((String)("JMSConsumer received message " + tempMsg.getText() + " (Expected None)"));
                TestUtil.logErr((String)"JMSConsumer should have returned just 2 messages");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Received no more messages (CORRECT)");
            }
            TestUtil.logMsg((String)"Create selective JMSConsumer with selector [\"lastMessage=TRUE\"] and noLocal=false");
            consumerSelect = this.context.createConsumer((Destination)this.topic, "lastMessage=TRUE", false);
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                if (i == 3) {
                    TestUtil.logMsg((String)"Set boolean property lastMessage=true");
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    TestUtil.logMsg((String)"Set boolean property lastMessage=false");
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive last message with selective JMSConsumer and boolean property lastMessage=true");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                TestUtil.logErr((String)"Message 3 missing from Topic");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + 3 + "]"));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Received expected message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Try receiving one more message (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("JMSConsumer received message " + tempMsg.getText() + " (Expected None)"));
                TestUtil.logErr((String)"JMSConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Received no more messages (CORRECT)");
            }
            consumerSelect.close();
            consumerSelect = null;
            TestUtil.logMsg((String)"Create selective JMSConsumer with selector [\"lastMessage=TRUE\"] and noLocal=true");
            consumerSelect = this.context.createConsumer((Destination)this.topic, "lastMessage=TRUE", true);
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Try receiving a message with selective JMSConsumer (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                TestUtil.logMsg((String)"Received no message (CORRECT)");
            } else {
                TestUtil.logErr((String)("JMSConsumer received message " + tempMsg.getText() + " (Expected None)"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("createConsumerTest");
        }
        finally {
            try {
                if (consumerSelect != null) {
                    consumerSelect.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createConsumerTest failed");
        }
    }

    public void createDurableConsumerTest1() throws EETest.Fault {
        boolean pass = true;
        String message1 = "Where are you!";
        String message2 = "Who are you!";
        String durableSubscriptionName = "createDurableConsumerTest1";
        try {
            TextMessage expTextMessage = null;
            TestUtil.logMsg((String)"Create a Durable Subscription and a MessageConsumer for it");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Send TextMessage message1 to Topic");
            expTextMessage = this.context2.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message1 sent");
            TestUtil.logMsg((String)"Receive TextMessage message1");
            TextMessage actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage message1");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Close durable MessageConsumer");
            this.consumer2.close();
            TestUtil.logMsg((String)"Send TextMessage message2 to Topic");
            expTextMessage = this.context2.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message2 sent");
            TestUtil.logMsg((String)"Recreate a Durable Subscription and a MessageConsumer for it");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Receive TextMessage message2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage message2");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("createDurableConsumerTest1", e);
        }
        finally {
            try {
                this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
                this.producer2 = null;
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createDurableConsumerTest1 failed");
        }
    }

    public void createDurableConsumerTest2() throws EETest.Fault {
        TextMessage tempMsg;
        boolean pass = true;
        String message = "Where are you!";
        String durableSubscriptionName = "createDurableConsumerTest2";
        try {
            TestUtil.logMsg((String)"Create a Durable Subscription and a MessageConsumer with message selector, noLocal=false");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE", false);
            TestUtil.logMsg((String)"Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer2.send(this.destination2, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage");
            TestUtil.logMsg((String)"This is noLacal=false case so expect to get just last message");
            TextMessage expTextMessage = this.context2.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("createDurableConsumerTest2", e);
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            TestUtil.logMsg((String)"Create a Durable Subscription and a MessageConsumer with message selector, noLocal=true");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE", true);
            TestUtil.logMsg((String)"Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context2.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer2.send(this.destination2, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Message was delivered when noLocal=true");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createDurableConsumerTest2", e);
        }
        finally {
            try {
                this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("createDurableConsumerTest2 failed");
        }
    }

    public void createSharedDurableConsumerTest1() throws EETest.Fault {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTest1";
        try {
            this.consumer.close();
            TextMessage expTextMessage = null;
            TestUtil.logMsg((String)"Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Create 2nd JMSConsumer for it");
            this.consumer2 = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Send TextMessage message1 to Topic");
            expTextMessage = this.context2.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message1 sent");
            TestUtil.logMsg((String)"Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Close 1st shared durable JMSConsumer");
            this.consumer.close();
            TestUtil.logMsg((String)"Send TextMessage message2 to Topic");
            expTextMessage = this.context2.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message2 sent");
            TestUtil.logMsg((String)"Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Now there should be no more messages to receive from topic");
            TestUtil.logMsg((String)"Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Try and receive a message from comsumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Consumer1 didn't receive a message (PASS)");
            }
            TestUtil.logMsg((String)"Try and receive a message from comsumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer2 received a message (FAIL)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Consumer2 didn't receive a message (PASS)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedDurableConsumerTest1", e);
        }
        finally {
            try {
                this.producer2 = null;
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedDurableConsumerTest1 failed");
        }
    }

    public void createSharedDurableConsumerTest2() throws EETest.Fault {
        boolean pass = true;
        String durableSubscriptionName = "createSharedDurableConsumerTest2";
        try {
            this.consumer.close();
            TestUtil.logMsg((String)"Create shared Durable Subscription and 1st JMSConsumer with message selector");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Create 2nd JMSConsumer with message selector");
            this.consumer2 = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer2.send(this.destination2, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.context2.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedDurableConsumerTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedDurableConsumerTest2 failed");
        }
    }

    public void createSharedDurableConsumerTest3() throws EETest.Fault {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTest3";
        try {
            this.consumer.close();
            TextMessage expTextMessage = null;
            TestUtil.logMsg((String)"Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Create 2nd JMSConsumer for it");
            this.consumer2 = this.context.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Send TextMessage message1 to Topic");
            expTextMessage = this.context.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest3");
            this.producer2.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message1 sent");
            TestUtil.logMsg((String)"Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Close 1st shared durable JMSConsumer");
            this.consumer.close();
            TestUtil.logMsg((String)"Send TextMessage message2 to Topic");
            expTextMessage = this.context.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest3");
            this.producer2.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"TextMessage message2 sent");
            TestUtil.logMsg((String)"Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Now there should be no more messages to receive from topic");
            TestUtil.logMsg((String)"Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            TestUtil.logMsg((String)"Try and receive a message from comsumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Consumer1 didn't receive a message (PASS)");
            }
            TestUtil.logMsg((String)"Try and receive a message from comsumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logErr((String)"Consumer2 received a message (FAIL)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Consumer2 didn't receive a message (PASS)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedDurableConsumerTest3", e);
        }
        finally {
            try {
                this.producer2 = null;
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.context, durableSubscriptionName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedDurableConsumerTest3 failed");
        }
    }

    public void createSharedConsumerTest1() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTest1";
        try {
            TextMessage expTextMessage = null;
            TestUtil.logMsg((String)"Create a shared non-durable Subscription and a JMSConsumer for it");
            this.consumer.close();
            this.consumer = this.context.createSharedConsumer(this.topic, sharedSubscriptionName);
            TestUtil.logMsg((String)"Create a second JMSConsumer for the Subscription");
            this.consumer2 = this.context.createSharedConsumer(this.topic, sharedSubscriptionName);
            TestUtil.logMsg((String)"Send message to Topic");
            expTextMessage = this.context.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Message sent");
            TestUtil.logMsg((String)"Receive TextMessage from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
            TestUtil.logMsg((String)"Send another message to Topic");
            expTextMessage = this.context.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Message sent");
            TestUtil.logMsg((String)"Receive TextMessage from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedConsumerTest1", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Ignoring exception closing consumers: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedConsumerTest1 failed");
        }
    }

    public void createSharedConsumerTest2() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTest2";
        try {
            TestUtil.logMsg((String)"Create a shared non-durable Subscription and a JMSConsumer for it");
            this.consumer.close();
            this.consumer = this.context.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Create a second JMSConsumer for the Subscription");
            this.consumer2 = this.context.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.context.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
            TestUtil.logMsg((String)"Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Receive TextMessage from consumer2");
            expTextMessage = this.context.createTextMessage("Message 3");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new EETest.Fault("Did receive TextMessage - unexpected.");
            }
            TestUtil.logMsg((String)"Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            e.printStackTrace();
            throw new EETest.Fault("createSharedConsumerTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Ignoring exception closing consumers: " + e));
            }
        }
        if (!pass) {
            throw new EETest.Fault("createSharedConsumerTest2 failed");
        }
    }

    public void multipleCloseContextTest() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"Call close on JMSContext created in setup.");
            this.context.close();
            TestUtil.logTrace((String)"Call close on a JMSContext a second time");
            this.context.close();
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("multipleCloseContextTest");
        }
    }

    public void simpleDurableConsumerTest() throws EETest.Fault {
        block10: {
            String durableSubscriptionName = "simpleDurableConsumerTest";
            try {
                TextMessage messageSent = null;
                TextMessage messageReceived = null;
                TestUtil.logMsg((String)"Create DurableConsumer with subscriber name");
                this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName);
                TestUtil.logMsg((String)"Creating and sending 1 message");
                messageSent = this.context2.createTextMessage("just a test");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", durableSubscriptionName);
                this.producer.send(this.destination, (Message)messageSent);
                TestUtil.logMsg((String)"Receiving message");
                messageReceived = (TextMessage)this.consumer2.receive(this.timeout);
                if (messageReceived.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
                    TestUtil.logMsg((String)"Received correct message");
                    break block10;
                }
                throw new Exception("didn't get the right message");
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("simpleDurableConsumerTest");
            }
            finally {
                try {
                    this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void inactiveDurableConsumerTopicRecTest() throws EETest.Fault {
        block11: {
            String durableSubscriptionName = "inactiveDurableConsumerTopicRecTest";
            try {
                TextMessage messageSent = null;
                TextMessage messageSent2 = null;
                TextMessage messageReceived = null;
                TestUtil.logMsg((String)"Create a Durable Subscription and a JMSConsumer for it");
                this.consumer2 = this.context2.createDurableConsumer(this.topic2, durableSubscriptionName);
                TestUtil.logTrace((String)"Creating and sending 1 message");
                messageSent = this.context2.createTextMessage("just a test");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", durableSubscriptionName);
                this.producer2.send(this.destination2, (Message)messageSent);
                TestUtil.logTrace((String)"Receiving message");
                messageReceived = (TextMessage)this.consumer2.receive(this.timeout);
                if (!messageReceived.getText().equals(messageSent.getText())) {
                    throw new EETest.Fault("didn't get the right message");
                }
                TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
                TestUtil.logMsg((String)"Received correct message");
                this.consumer2.close();
                TestUtil.logTrace((String)"Creating and sending another message");
                messageSent2 = this.context2.createTextMessage("test that messages are durable");
                messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", durableSubscriptionName);
                this.producer2.send(this.destination2, (Message)messageSent2);
                TestUtil.logMsg((String)"Create a Durable Subscription and a JMSConsumer for it");
                this.consumer2 = this.context2.createDurableConsumer(this.topic2, durableSubscriptionName);
                messageReceived = (TextMessage)this.consumer2.receive(this.timeout);
                if (messageReceived.getText().equals(messageSent2.getText())) {
                    TestUtil.logTrace((String)("Message text: \"" + messageReceived.getText() + "\""));
                    TestUtil.logTrace((String)"Received correct message");
                    break block11;
                }
                throw new EETest.Fault("Received incorrect message.");
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("inactiveDurableConsumerTopicRecTest");
            }
            finally {
                try {
                    this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableConsumerTopicNoLocalTest() throws EETest.Fault {
        JMSConsumer tConNoLocal = null;
        String subscriptionName = "DurableConsumerTopicNoLocalTestSubscription";
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            int i;
            int num = 10;
            Message messageSent = null;
            Message messageReceived = null;
            TestUtil.logMsg((String)"Create normal Consumer");
            this.consumer2 = this.context2.createConsumer((Destination)this.topic);
            TestUtil.logMsg((String)"Create DurableConsumer with no_local=true");
            tConNoLocal = this.context2.createDurableConsumer(this.topic, subscriptionName, "", true);
            TestUtil.logMsg((String)("Sending " + num + " messages to topic"));
            messageSent = this.context2.createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerTopicNoLocalTest");
            for (i = 0; i < num; ++i) {
                this.producer2.send(this.destination2, messageSent);
            }
            TestUtil.logMsg((String)"Attempting to receive messages from normal consumer");
            for (i = 0; i < num; ++i) {
                messageReceived = this.consumer2.receive(this.timeout);
                if (messageReceived == null) {
                    throw new EETest.Fault("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) throw new EETest.Fault("Received incorrect message lastMessage=true");
                TestUtil.logMsg((String)"Received correct message lastMessage=false");
            }
            TestUtil.logMsg((String)"Attempting to receive messages from (no_local=true) consumer");
            messageReceived = tConNoLocal.receive(this.timeout);
            if (messageReceived != null) throw new EETest.Fault("Received unexpected message (incorrect)");
            TestUtil.logMsg((String)"Did not receive message (correct)");
            TestUtil.logMsg((String)("Sending " + num + " messages to topic"));
            for (i = 0; i < num; ++i) {
                this.producer2.send(this.destination2, messageSent);
            }
            TestUtil.logMsg((String)"Close DurableConsumer with no_local=true");
            tConNoLocal.close();
            TestUtil.logMsg((String)"Create DurableConsumer with no_local=false");
            tConNoLocal = this.context2.createDurableConsumer(this.topic, subscriptionName, "", false);
            messageReceived = tConNoLocal.receive(this.timeout);
            if (messageReceived != null) throw new EETest.Fault("No_local=false consumer received message (unexpected)");
            TestUtil.logMsg((String)"No_local=false consumer did not receive any message (expected)");
            TestUtil.logMsg((String)("Sending " + num + " messages to topic"));
            messageSent = this.context2.createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerTopicNoLocalTest");
            for (i = 0; i < num; ++i) {
                this.producer2.send(this.destination2, messageSent);
            }
            TestUtil.logMsg((String)"Attempting to receive messages from (no_local=false) consumer");
            for (i = 0; i < num; ++i) {
                messageReceived = tConNoLocal.receive(this.timeout);
                if (messageReceived == null) {
                    throw new EETest.Fault("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) throw new EETest.Fault("Received incorrect message lastMessage=true");
                TestUtil.logMsg((String)"Received correct message lastMessage=false");
            }
            messageReceived = tConNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new EETest.Fault("Received unexpected final message");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logMsg((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("durableConsumerTopicNoLocalTest2");
            }
            catch (Throwable throwable) {
                try {
                    if (this.consumer2 != null) {
                        this.consumer2.close();
                    }
                    this.cleanupSubscription(tConNoLocal, this.context2, subscriptionName);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (this.consumer2 != null) {
                this.consumer2.close();
            }
            this.cleanupSubscription(tConNoLocal, this.context2, subscriptionName);
            return;
        }
        catch (Exception num) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableConsumerChangeSelectorTest() throws EETest.Fault {
        JMSConsumer durableCon = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent2332 = null;
            TextMessage messageReceived = null;
            TestUtil.logMsg((String)"Create DurableConsumer with MessageSelector=TEST='test' and no_local=false");
            durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest", "TEST = 'test'", false);
            TestUtil.logMsg((String)"Send and receive the message");
            messageSent2332 = this.context2.createTextMessage();
            messageSent2332.setStringProperty("TEST", "test");
            messageSent2332.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest");
            messageSent2332.setText("For default topic ");
            this.producer2.send(this.destination2, (Message)messageSent2332);
            TestUtil.logMsg((String)"Receiving message");
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent2332.getText())) throw new EETest.Fault("didn't get the right message");
            TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received correct message");
            durableCon.close();
            TestUtil.logMsg((String)"Create DurableConsumer with new MessageSelector=TEST='new one' and no_local=false");
            durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest", "TEST = 'new one'", false);
            messageSent2332.setBooleanProperty("lastMessage", false);
            this.producer2.send(this.destination2, (Message)messageSent2332);
            messageSent2332 = this.context2.createTextMessage();
            messageSent2332.setStringProperty("TEST", "new one");
            messageSent2332.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest");
            messageSent2332.setText("For new topic");
            messageSent2332.setBooleanProperty("lastMessage", true);
            this.producer2.send(this.destination2, (Message)messageSent2332);
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (messageReceived == null) throw new EETest.Fault("didn't get any message");
            if (!messageReceived.getText().equals(messageSent2332.getText())) throw new EETest.Fault("didn't get the right message");
            if (!messageReceived.getBooleanProperty("lastMessage")) throw new EETest.Fault("didn't get the right message");
            TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received correct message");
        }
        catch (Exception e) {
            try {
                TestUtil.logMsg((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("durableConsumerChangeSelectorTest");
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest");
            return;
        }
        catch (Exception messageSent2332) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableConsumerChangeSelectorTest2() throws EETest.Fault {
        JMSConsumer durableCon = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent3332 = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            TestUtil.logMsg((String)"Create durable subscription with MessageSelector=\"TEST='test'\",");
            TestUtil.logMsg((String)("TopicName=" + this.topic.getTopicName() + " and SubscriptionName=durableConsumerChangeSelectorTest2"));
            durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest2", "TEST = 'test'", false);
            TestUtil.logMsg((String)"Create/Send first message with string property \"TEST = 'test'\"");
            messageSent3332 = this.context2.createTextMessage();
            messageSent3332.setStringProperty("TEST", "test");
            messageSent3332.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest2");
            messageSent3332.setText("Message #1 with string property TEST='test'");
            this.producer2.send(this.destination, (Message)messageSent3332);
            TestUtil.logMsg((String)"Create/Send second message with string property \"TEST = 'test again'\"");
            messageSent2 = this.context2.createTextMessage();
            messageSent2.setStringProperty("TEST", "test again");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest2");
            messageSent2.setText("Message #2 with string property TEST='test again'");
            this.producer2.send(this.destination, (Message)messageSent2);
            TestUtil.logMsg((String)"Try receiving first message (should get message)");
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logMsg((String)"Did not receive any message (incorrect)");
                throw new EETest.Fault("didn't receive any message");
            }
            if (!messageReceived.getText().equals(messageSent3332.getText())) {
                TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
                throw new EETest.Fault("didn't get the right message");
            }
            TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received correct first message");
            TestUtil.logMsg((String)"Try receiving second message (should not get message)");
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logMsg((String)"Did not receive second message (correct)");
                TestUtil.logMsg((String)"Close durable subscription");
                durableCon.close();
                TestUtil.logMsg((String)"Create new durable subscription with MessageSelector=\"TEST='test again'\",");
                TestUtil.logMsg((String)("TopicName=" + this.topic.getTopicName() + " and SubscriptionName=durableConsumerChangeSelectorTest2"));
                durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest2", "TEST = 'test again'", false);
                messageReceived = (TextMessage)durableCon.receive(this.timeout);
                if (messageReceived != null) {
                    TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
                    throw new EETest.Fault("received unexpected message");
                }
            } else {
                if (messageReceived.getText().equals(messageSent2.getText())) {
                    TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
                    throw new EETest.Fault("received second message (unexpected)");
                }
                TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
                throw new EETest.Fault("received unexpected message");
            }
            TestUtil.logMsg((String)"Did not receive any messages (correct)");
        }
        catch (Exception e) {
            try {
                TestUtil.logMsg((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("durableConsumerChangeSelectorTest2");
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest2");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest2");
            return;
        }
        catch (Exception messageSent3332) {
            return;
        }
    }

    public void verifyClientIDOnAdminConfiguredIDTest() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Get client id from an administratively configured client id");
            String cid = this.context2.getClientID();
            if (cid == null) {
                TestUtil.logErr((String)"getClientID returned null (expected cts)");
                pass = false;
            } else if (!cid.equals("cts")) {
                TestUtil.logErr((String)("getClientID() returned " + cid + ", expected cts"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"getClientID returned cts (Correct)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected: " + e));
            throw new EETest.Fault("verifyClientIDOnAdminConfiguredIDTest");
        }
        if (!pass) {
            throw new EETest.Fault("verifyClientIDOnAdminConfiguredIDTest failed");
        }
    }

    public void invalidDestinationRuntimeExceptionTests() throws EETest.Fault {
        boolean pass = true;
        Destination invalidDestination = null;
        Topic invalidTopic = null;
        String message = "Where are you!";
        byte[] bytesMsgSend = message.getBytes();
        HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
        mapMsgSend.put("StringValue", "sendAndRecvTest7");
        mapMsgSend.put("BooleanValue", true);
        mapMsgSend.put("IntValue", 10);
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, Message) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)expTextMessage);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, message);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Serializable) for InvalidDestinationRuntimeException");
            TestUtil.logMsg((String)"Send ObjectMessage");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage om = this.context.createObjectMessage();
            StringBuffer sb = new StringBuffer(message);
            om.setObject((Serializable)sb);
            om.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, Serializable) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)om);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, byte[]) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, byte[]) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, bytesMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Map) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling send(Destination, Map) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, mapMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createDurableConsumer(Topic, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String) -> expect InvalidDestinationRuntimeException");
                this.context.createDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createDurableConsumer(Topic, String, String, boolean) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidDestinationRuntimeException");
                this.context.createDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createSharedDurableConsumer(Topic, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createSharedDurableConsumer(Topic, String) -> expect InvalidDestinationRuntimeException");
                this.context.createSharedDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createSharedDurableConsumer(Topic, String, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createSharedDurableConsumer(Topic, String, String) -> expect InvalidDestinationRuntimeException");
                this.context.createSharedDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.unsubscribe(String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.unsubscribe(String) -> expect InvalidDestinationRuntimeException");
                this.context.unsubscribe("InvalidSubscriptionName");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createSharedConsumer(Topic, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createSharedConsumer(Topic, String) for InvalidDestinationRuntimeException");
                this.context.createSharedConsumer(invalidTopic, "InvalidDestinationRuntimeException");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createSharedConsumer(Topic, String, String) for InvalidDestinationRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createSharedConsumer(Topic, String, String) for InvalidDestinationRuntimeException");
                this.context.createSharedConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("invalidDestinationRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidDestinationRuntimeExceptionTests failed");
        }
    }

    public void invalidSelectorRuntimeExceptionTests() throws EETest.Fault {
        boolean pass = true;
        String invalidMessageSelector = "=TEST 'test'";
        try {
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer((Destination)this.topic, invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer((Destination)this.topic, invalidMessageSelector, false);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createDurableConsumer(Topic, String, String, boolean) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidSelectorRuntimeException");
                this.context2.createDurableConsumer(this.topic, "InvalidSelectorRuntimeException", invalidMessageSelector, false);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createSharedDurableConsumer(Topic, String, String) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createSharedDurableConsumer(Topic, String, String) -> expect InvalidSelectorRuntimeException");
                this.context.createSharedDurableConsumer(this.topic, "InvalidSelectorRuntimeException", invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException, received " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Testing JMSContext.createSharedConsumer(Topic, String, String) for InvalidSelectorRuntimeException");
            try {
                TestUtil.logMsg((String)"Calling JMSContext.createSharedConsumer(Topic, String, String) for InvalidSelectorRuntimeException");
                this.context.createSharedConsumer(this.topic, "InvalidSelectorRuntimeException", invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                TestUtil.logMsg((String)"Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidSelectorRuntimeException, received " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("invalidSelectorRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidSelectorRuntimeExceptionTests failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jMSRuntimeExceptionTests() throws EETest.Fault {
        Topic mytopic;
        boolean pass = true;
        String message = "Where are you!";
        if (this.vehicle.equals("ejb") || this.vehicle.equals("jsp") || this.vehicle.equals("servlet")) {
            try {
                TestUtil.logMsg((String)"Calling createContext must throw JMSRuntimeException for EJB/WEB container");
                this.context.createContext(1);
                TestUtil.logErr((String)"Didn't throw JMSRuntimeException");
                pass = false;
            }
            catch (JMSRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSRuntimeException, received " + e));
                pass = false;
            }
        }
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TestUtil.logMsg((String)"Try and set an invalid priority of -1");
            this.producer.setPriority(-1);
            TestUtil.logErr((String)"Didn't throw JMSRuntimeException");
            pass = false;
        }
        catch (JMSRuntimeException e) {
            TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Expected JMSRuntimeException, received " + e));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Try and set an delivery mode to live of -1");
            this.producer.setDeliveryMode(-1);
            TestUtil.logErr((String)"Didn't throw JMSRuntimeException");
            pass = false;
        }
        catch (JMSRuntimeException e) {
            TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Expected JMSRuntimeException, received " + e));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Create shared consumer");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedConsumer(Topic, String)");
            this.consumer = this.context2.createSharedConsumer(this.topic, "dummySubSCJMSRuntime");
            TestUtil.logMsg((String)"Create second shared consumer with same name but different topic");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedConsumer(Topic, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createSharedConsumer(mytopic, "dummySubSCJMSRuntime");
            TestUtil.logMsg((String)"Verify that JMSRuntimeException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            TestUtil.logMsg((String)"Got expected JMSRuntimeException from JMSContext.createSharedConsumer(Topic, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception ex) {}
        }
        try {
            TestUtil.logMsg((String)"Create shared consumer");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedConsumer(Topic, String, String)");
            this.consumer = this.context2.createSharedConsumer(this.topic, "dummySubSCJMSRuntime", "TEST = 'test'");
            TestUtil.logMsg((String)"Create second shared consumer with same name but different topic");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedConsumer(Topic, String, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createSharedConsumer(mytopic, "dummySubSCJMSRuntime", "TEST = 'test'");
            TestUtil.logMsg((String)"Verify that JMSRuntimeException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            TestUtil.logMsg((String)"Got expected JMSRuntimeException from JMSContext.createSharedConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception ex) {}
        }
        try {
            TestUtil.logMsg((String)"Create shared durable subscription");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedDurableConsumer(Topic, String, String)");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, "dummySubSJMSRuntime", "TEST = 'test'");
            TestUtil.logMsg((String)"Create second shared durable subscription with same name but different other args");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedDurableConsumer(Topic, String, String)");
            this.consumer2 = this.context2.createSharedDurableConsumer(this.topic, "dummySubSJMSRuntime", "TEST = 'test2'");
            TestUtil.logMsg((String)"Verify that JMSRuntimeException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            TestUtil.logMsg((String)"Got expected JMSRuntimeException from JMSContext.createSharedDurableConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubSJMSRuntime");
            }
            catch (Exception ex) {}
        }
        try {
            TestUtil.logMsg((String)"Create durable subscription");
            TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String)");
            this.consumer = this.context2.createDurableConsumer(this.topic, "dummySubDJMSRuntime");
            TestUtil.logMsg((String)"Create second durable subscription with same name but different topic");
            TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createDurableConsumer(mytopic, "dummySubDJMSRuntime");
            TestUtil.logMsg((String)"Verify that JMSRuntimeException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            TestUtil.logMsg((String)"Got expected JMSRuntimeException from JMSContext.createDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubDJMSRuntime");
            }
            catch (Exception ex) {}
        }
        try {
            TestUtil.logMsg((String)"Create shared durable subscription");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedDurableConsumer(Topic, String)");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, "dummySubSDJMSRuntime");
            TestUtil.logMsg((String)"Create second shared durable subscription with same name but different topic");
            TestUtil.logMsg((String)"Calling JMSContext.createSharedDurableConsumer(Topic, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createSharedDurableConsumer(mytopic, "dummySubSDJMSRuntime");
            TestUtil.logMsg((String)"Verify that JMSRuntimeException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            TestUtil.logMsg((String)"Got expected JMSRuntimeException from JMSContext.createSharedDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubSDJMSRuntime");
            }
            catch (Exception ex) {}
        }
        try {
            TestUtil.logMsg((String)"Create durable subscription");
            TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer = this.context2.createDurableConsumer(this.topic, "dummySubDJMSRuntime", "TEST = 'test'", true);
            TestUtil.logMsg((String)"Create second durable subscription with same name but different other args");
            TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, "dummySubDJMSRuntime", "TEST = 'test2'", false);
            TestUtil.logMsg((String)"Verify that JMSRuntimeException is thrown");
            pass = false;
            TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            TestUtil.logMsg((String)"Got expected JMSRuntimeException from JMSContext.createDurableConsumer(Topic, String, String, boolean)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubDJMSRuntime");
            }
            catch (Exception ex) {}
        }
        if (!pass) {
            throw new EETest.Fault("jMSRuntimeExceptionTests failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void illegalStateRuntimeExceptionTest() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
            TestUtil.logTrace((String)"Sending message to the Topic");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            try {
                TestUtil.logTrace((String)"JMSContext.commit() on non-transacted session must throw IllegalStateRuntimeException");
                this.context.commit();
                pass = false;
                TestUtil.logErr((String)"Error: JMSContext.commit() didn't throw expected IllegalStateRuntimeException");
            }
            catch (IllegalStateRuntimeException e) {
                this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.commit()");
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception: " + e);
                pass = false;
            }
            TestUtil.logMsg((String)"Creating TextMessage");
            expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
            TestUtil.logTrace((String)"Sending message to the Topic");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            try {
                TestUtil.logTrace((String)"JMSContext.rollback() on non-transacted session must throw IllegalStateRuntimeException");
                this.context.rollback();
                pass = false;
                TestUtil.logErr((String)"Error: JMSContext.rollback() didn't throw expected IllegalStateRuntimeException");
            }
            catch (IllegalStateRuntimeException e) {
                this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.rollback()");
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception: " + e);
                pass = false;
            }
            TestUtil.logMsg((String)"Creating TextMessage");
            expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
            TestUtil.logTrace((String)"Sending message to the Topic");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
                JMSContext contextTX = this.cf.createContext(this.user, this.password, 0);
                JMSProducer producerTX = contextTX.createProducer();
                TestUtil.logMsg((String)"Creating TextMessage");
                expTextMessage = contextTX.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                TestUtil.logMsg((String)"Sending message to the Queue");
                TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
                producerTX.send(this.destination, (Message)expTextMessage);
                try {
                    TestUtil.logMsg((String)"JMSContext.recover() on a transacted session must throw IllegalStateRuntimeException");
                    contextTX.recover();
                    pass = false;
                    TestUtil.logErr((String)"Error: JMSContext.recover() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.recover()");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
                contextTX.close();
                try {
                    TestUtil.logMsg((String)"Create JMSContext with CLIENT_ACKNOWLEDGE");
                    JMSContext msgcontext = this.cf.createContext(this.user, this.password, 2);
                    TestUtil.logMsg((String)"Close JMSContext");
                    msgcontext.close();
                    TestUtil.logMsg((String)"Call JMSContext.acknowledge() on a closed session which is illegal");
                    msgcontext.acknowledge();
                    TestUtil.logErr((String)"Didn't throw IllegalStateRuntimeException");
                    pass = false;
                }
                catch (IllegalStateRuntimeException e) {
                    this.logMsg("Got expected IllegalStateRuntimeException from JMSContext.acknowledge()");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught expected exception" + e));
                    pass = false;
                }
            }
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception contextTX) {
                // empty catch block
            }
            try {
                this.consumer = null;
                TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String)");
                TestUtil.logMsg((String)"Create Durable Consumer with client id unset (expect IllegalStateRuntimeException)");
                this.consumer = this.context.createDurableConsumer(this.topic, "dummySubDIllegalState1");
                TestUtil.logErr((String)"No exception occurred - expected IllegalStateRuntimeException");
                pass = false;
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Got expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.cleanupSubscription(this.consumer, this.context, "dummySubDIllegalState1");
                    }
                }
                catch (Exception e) {}
            }
            try {
                this.consumer = null;
                TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
                TestUtil.logMsg((String)"Create Durable Consumer with client id unset, nolocal=false (expect IllegalStateRuntimeException)");
                this.consumer = this.context.createDurableConsumer(this.topic, "dummySubDIllegalState2", "lastMessage = TRUE", false);
                TestUtil.logErr((String)"No exception occurred - expected IllegalStateRuntimeException");
                pass = false;
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Got expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception" + e));
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.cleanupSubscription(this.consumer, this.context, "dummySubDIllegalState2");
                    }
                }
                catch (Exception e) {}
            }
            try {
                this.consumer = null;
                TestUtil.logMsg((String)"Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
                TestUtil.logMsg((String)"Create Durable Consumer with client id unset, nolocal=true (expect IllegalStateRuntimeException)");
                this.consumer = this.context.createDurableConsumer(this.topic, "dummySubDIllegalState2", "lastMessage = TRUE", true);
                TestUtil.logErr((String)"No exception occurred - expected IllegalStateRuntimeException");
                pass = false;
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Got expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception" + e));
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.cleanupSubscription(this.consumer, this.context, "dummySubDIllegalState2");
                    }
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("illegalStateRuntimeExceptionTest");
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateRuntimeExceptionTest");
        }
    }
}

