/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.persist.oneXmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.persist.oneXmany.A;
import com.sun.ts.tests.jpa.core.entitytest.persist.oneXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("1", "b1", 1);
            B b2 = new B("2", "b2", 1);
            B b3 = new B("3", "b3", 1);
            B b4 = new B("4", "b4", 1);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Test failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest3() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("1", "b1", 3);
            B b2 = new B("2", "b2", 3);
            B b3 = new B("3", "b3", 3);
            B b4 = new B("4", "b4", 3);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            this.getEntityTransaction().begin();
            A aRef = new A("3", "bean3", 3, v1);
            this.getEntityManager().persist((Object)aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                TestUtil.logTrace((String)"Remove aRef ");
                this.getEntityManager().remove((Object)this.findA("3"));
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"Persist a removed entity ");
                A newA = this.findA("3");
                if (null == newA) {
                    newA = new A("3", "bean3", 3, v1);
                    this.getEntityManager().persist((Object)newA);
                    pass = this.getInstanceStatus(newA) && this.findA("3") != null;
                } else {
                    TestUtil.logTrace((String)"entity A not removed");
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 5);
            B b2 = new B("2", "b2", 5);
            B b3 = new B("3", "b3", 5);
            B b4 = new B("4", "b4", 5);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("5", "bean5", 5, v1);
            this.getEntityManager().persist((Object)a1);
            A a2 = this.findA("5");
            Collection newCol = a2.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    TestUtil.logTrace((String)"Remove instance a1");
                    this.getEntityManager().remove((Object)a1);
                    this.getEntityManager().flush();
                    if (null != this.findB("1") && null != this.findB("2") && null != this.findB("3") && null != this.findB("4")) {
                        pass = true;
                    }
                }
                catch (Exception fe) {
                    TestUtil.logErr((String)"Unexpected exception caught trying to remove entity instance :", (Throwable)fe);
                }
            } else {
                TestUtil.logTrace((String)"collection not persisted, cannot proceed with test");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 6);
            B b2 = new B("2", "b2", 6);
            B b3 = new B("3", "b3", 6);
            B b4 = new B("4", "b4", 6);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("6", "bean6", 6, v1);
            this.getEntityManager().persist((Object)a1);
            A a2 = this.findA("6");
            Collection newCol = a2.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                pass = this.getInstanceStatus(a1);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 7);
            B b2 = new B("2", "b2", 7);
            B b3 = new B("3", "b3", 7);
            B b4 = new B("4", "b4", 7);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("7", "bean7", 7, v1);
            this.getEntityManager().persist((Object)a1);
            Collection newCol = a1.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.size() != 0 && this.getEntityManager().contains((Object)b1) && this.getEntityManager().contains((Object)b2) && this.getEntityManager().contains((Object)b3) && this.getEntityManager().contains((Object)b4)) {
                pass = this.getInstanceStatus(a1);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest7() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "b8", 8);
            B bRef = new B("8", "bean8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            pass = this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1);
            this.getEntityManager().clear();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest7 failed");
        }
    }

    public void persist1XMTest7IllegalStateException() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "b8", 8);
            B bRef = new B("8", "bean8", 8, a1);
            TestUtil.logTrace((String)"before persist");
            this.getEntityManager().persist((Object)bRef);
            TestUtil.logTrace((String)"before flush");
            this.getEntityManager().flush();
            TestUtil.logErr((String)"IllegalStateException was not thrown");
            pass = false;
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)("Received expected Exception :" + ise));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest7IllegalStateException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest8() throws EETest.Fault {
        boolean pass = true;
        try {
            B b1 = new B("1", "b1", 9);
            B b2 = new B("2", "b2", 9);
            B b3 = new B("3", "b3", 9);
            B b4 = new B("4", "b4", 9);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A a1 = new A("9", "bean9", 9, v1);
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (pass) {
            throw new EETest.Fault("persist1XMTest8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("10", "b10", 10);
            B bRef = new B("10", "bean10", 10, a1);
            pass = !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create A and B Entity Objects");
            B b11 = new B("19", "b19", 19);
            B b12 = new B("20", "b29", 29);
            Vector<B> v1 = new Vector<B>();
            v1.add(b11);
            v1.add(b12);
            A aRef = new A("11", "bean11", 11, v1);
            this.getEntityManager().persist((Object)aRef);
            B newB = new B("21", "b39", 39);
            B newB1 = new B("22", "b49", 49);
            TestUtil.logTrace((String)"Getting B info from entity object A");
            Collection bInfo = aRef.getBInfoFromA();
            bInfo.add(newB);
            bInfo.add(newB1);
            A newA = this.findA("11");
            newA.setBCol(bInfo);
            this.getEntityManager().flush();
            bInfo = aRef.getBInfoFromA();
            TestUtil.logTrace((String)"dumping B info ...");
            this.dumpCollectionDataB(bInfo);
            if (bInfo.size() != 0 && bInfo.contains(b11) && bInfo.contains(b12) && bInfo.contains(newB) && bInfo.contains(newB1)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest11() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("12", "b12", 12);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("12", "bean12", 12);
            this.getEntityManager().persist((Object)aRef);
            if (this.getEntityManager().contains((Object)aRef)) {
                A aRef1 = this.findA("12");
                aRef1.setBCol(v1);
                this.getEntityManager().persist((Object)aRef1);
                pass = this.getEntityManager().contains((Object)b1);
                TestUtil.logTrace((String)"try to find B");
                B b2 = this.findB("12");
                if (null != b2) {
                    TestUtil.logTrace((String)"b2 is not null");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest12() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("13", "b13", 13);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("13", "bean13", 13, v1);
            this.getEntityManager().persist((Object)aRef);
            A a2 = this.findA("13");
            if (null != a2 && this.getEntityManager().contains((Object)a2)) {
                Collection result = a2.getBInfoFromA();
                this.dumpCollectionDataB(result);
                pass = true;
            } else {
                TestUtil.logErr((String)"Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest12 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest13() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            this.getEntityTransaction().begin();
            B b1 = new B("14", "b14", 14);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("14", "bean14", 14, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)b1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest13 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest14() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("15", "a15", 15);
            B bRef = new B("15", "bean15", 15, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Exception Caught as Expected:" + e.getMessage()));
            pass = true;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest14 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1XMTest15() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("16", "a16", 16);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("16", "bean16", 16, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            B b2 = this.findB("16");
            A newA = b2.getA1();
            newA.setAName("newA");
            this.getEntityManager().flush();
            if (b2.isA() && newA.getAName().equals("newA")) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persist1XMTest15 failed");
        }
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        TestUtil.logTrace((String)"Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataB(Collection c) {
        TestUtil.logTrace((String)"collection Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            TestUtil.logTrace((String)("- Element #" + elem++));
            TestUtil.logTrace((String)("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue()));
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

