/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ArrayIndexCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;

@Named(value="skipWriter")
public class SkipWriter
implements ItemWriter {
    private static final Logger logger = Logger.getLogger(SkipWriter.class.getName());
    private int[] writerDataArray = new int[30];
    private int idx = 0;
    int chunkWriteIteration = 0;
    @Inject
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @Inject
    @BatchProperty(name="writerecord.fail")
    String writeRecordFailNumberString = null;
    int arraysize;
    int[] failnum;
    int[] writePoints;

    public void open(Serializable cpd) throws Exception {
        logger.fine("openWriter");
        ArrayIndexCheckpointData checkpointData = (ArrayIndexCheckpointData)cpd;
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        if (this.writeRecordFailNumberString != null) {
            String[] writeFailPointsStrArr = this.writeRecordFailNumberString.split(",");
            this.failnum = new int[writeFailPointsStrArr.length];
            for (int i = 0; i < writeFailPointsStrArr.length; ++i) {
                this.failnum[i] = Integer.parseInt(writeFailPointsStrArr[i]);
            }
        } else {
            this.failnum = new int[1];
            this.failnum[0] = -1;
        }
        if (checkpointData == null) {
            this.idx = 0;
            logger.fine("WRITE: chkpt data = null, so idx = " + this.idx);
        } else {
            this.idx = checkpointData.getCurrentIndex();
            logger.fine("WRITE: chkpt data was valid, so idx = " + this.idx);
            logger.fine("WRITE: chunkWriteIteration = " + this.chunkWriteIteration);
        }
        for (int i = 0; i < this.arraysize; ++i) {
            this.writerDataArray[i] = 0;
        }
    }

    public void close() throws Exception {
        for (int i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    public void writeItems(List<Object> myData) throws Exception {
        int i;
        logger.fine("writeMyData receives chunk size=" + myData.size());
        logger.fine("WRITE: before writing, idx = " + this.idx);
        logger.fine("WRITE: before writing, chunkWriteIteration = " + this.chunkWriteIteration);
        if (this.writeRecordFailNumberString != null) {
            if (this.chunkWriteIteration == 2) {
                ++this.chunkWriteIteration;
                throw new MyParentException("fail on purpose on write iteration = 2");
            }
            if (this.chunkWriteIteration == 5) {
                ++this.chunkWriteIteration;
                throw new MyParentException("fail on purpose on write iteration = 5");
            }
            if (this.chunkWriteIteration == 8) {
                ++this.chunkWriteIteration;
                throw new MyParentException("fail on purpose on write iteration = 8");
            }
            ++this.chunkWriteIteration;
        } else {
            ++this.chunkWriteIteration;
        }
        for (i = 0; i < myData.size(); ++i) {
            this.writerDataArray[this.idx] = ((ReadRecord)myData.get(i)).getCount();
            ++this.idx;
        }
        for (i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
        logger.fine("WRITE: idx = " + this.idx + " and i = " + i);
        logger.fine("WRITE: chunkWriteIteration= " + this.chunkWriteIteration);
    }

    public ArrayIndexCheckpointData checkpointInfo() throws Exception {
        ArrayIndexCheckpointData _chkptData = new ArrayIndexCheckpointData();
        _chkptData.setCurrentIndex(this.idx);
        return _chkptData;
    }
}

