/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.cm.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeEJBLite;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeUtil;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.RWTxBeanBase;
import jakarta.persistence.EntityManager;
import jakarta.transaction.UserTransaction;

public class RWTestBeanBase0 {
    protected CoffeeEJBLite[] postConstructCoffees = new CoffeeEJBLite[2];
    protected EntityManager em;
    protected UserTransaction ut;
    protected RWTxBeanBase txBean;

    public void setEm(EntityManager em) {
        this.em = em;
    }

    public void setUt(UserTransaction ut) {
        this.ut = ut;
    }

    public void setTxBean(RWTxBeanBase b) {
        this.txBean = b;
    }

    public String mandatory(boolean flush) {
        int id = 1;
        String brandName = "mandatory";
        float price = id;
        float targetPrice = price + 100.0f;
        CoffeeEJBLite coffee = new CoffeeEJBLite(id, brandName, price);
        CoffeeUtil.deleteCoffeeInNewUserTransaction(coffee.getId(), this.em, this.ut);
        String result = "";
        try {
            this.ut.begin();
            this.txBean.mandatory(coffee, flush);
            coffee = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee price ", Float.valueOf(targetPrice), Float.valueOf(coffee.getPrice()));
            this.ut.rollback();
            CoffeeEJBLite coffeeFound = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee from em.find()", null, coffeeFound);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String required(boolean flush) {
        int id = 2;
        String brandName = "required";
        float price = id;
        float targetPrice = price + 100.0f;
        CoffeeEJBLite coffee = new CoffeeEJBLite(id, brandName, price);
        CoffeeUtil.deleteCoffeeInNewUserTransaction(coffee.getId(), this.em, this.ut);
        String result = "";
        try {
            this.ut.begin();
            this.txBean.required(coffee, flush);
            coffee = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee price ", Float.valueOf(targetPrice), Float.valueOf(coffee.getPrice()));
            this.ut.rollback();
            CoffeeEJBLite coffeeFound = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee from em.find()", null, coffeeFound);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String requiredNoExistingTransaction(boolean flush) {
        int id = 21;
        String brandName = "requiredNoExisting";
        float price = id;
        float targetPrice = price + 100.0f;
        CoffeeEJBLite coffee = new CoffeeEJBLite(id, brandName, price);
        CoffeeUtil.deleteCoffeeInNewUserTransaction(coffee.getId(), this.em, this.ut);
        this.txBean.requiredNoExistingTransaction(coffee, flush);
        coffee = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
        return Helper.assertEquals("Check coffee price ", Float.valueOf(targetPrice), Float.valueOf(coffee.getPrice()));
    }

    public String supports(boolean flush) {
        int id = 3;
        String brandName = "supports";
        float price = id;
        float targetPrice = price + 100.0f;
        CoffeeEJBLite coffee = new CoffeeEJBLite(id, brandName, price);
        CoffeeUtil.deleteCoffeeInNewUserTransaction(coffee.getId(), this.em, this.ut);
        String result = "";
        try {
            this.ut.begin();
            this.txBean.supports(coffee, flush);
            coffee = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee price ", Float.valueOf(targetPrice), Float.valueOf(coffee.getPrice()));
            this.ut.rollback();
            CoffeeEJBLite coffeeFound = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee from em.find()", null, coffeeFound);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String requiresNew(boolean flush) {
        int id = 4;
        String brandName = "requiresNew";
        float price = id;
        float targetPrice = price + 100.0f;
        CoffeeEJBLite coffee = new CoffeeEJBLite(id, brandName, price);
        CoffeeUtil.deleteCoffeeInNewUserTransaction(coffee.getId(), this.em, this.ut);
        String result = "";
        try {
            this.ut.begin();
            this.txBean.requiresNew(coffee, flush);
            coffee = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee price ", Float.valueOf(targetPrice), Float.valueOf(coffee.getPrice()));
            this.ut.rollback();
            CoffeeEJBLite coffeeFound = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)id);
            result = result + Helper.assertEquals("Check coffee id from em.find()", id, coffeeFound.getId());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void postConstructTransaction(StringBuilder sb) {
        for (CoffeeEJBLite postConstructCoffee : this.postConstructCoffees) {
            CoffeeEJBLite c = (CoffeeEJBLite)this.em.find(CoffeeEJBLite.class, (Object)postConstructCoffee.getId());
            int expected = postConstructCoffee.getId();
            int actual = c.getId();
            Helper.assertEquals("Finding postConstructCoffee ", expected, actual, sb);
        }
        this.txBean.postConstructTransaction(sb);
    }
}

