/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest.TestBean2;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest.TestBean2Home;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.sessioncontexttest.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testName = "SessionContextTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String txNotSupported = "java:comp/env/ejb/TxNotSupported";
    private static final String txSupports = "java:comp/env/ejb/TxSupports";
    private static final String txRequired = "java:comp/env/ejb/TxRequired";
    private static final String txRequiresNew = "java:comp/env/ejb/TxRequiresNew";
    private static final String txMandatory = "java:comp/env/ejb/TxMandatory";
    private static final String txNever = "java:comp/env/ejb/TxNever";
    private static final String testProps = "sessioncontexttest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private Properties props = null;
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private TestBean2 bean2Ref = null;
    private TestBean2Home bean2Home = null;
    private TSNamingContext nctx = null;
    private static final String user = "user";
    private static final String password = "password";
    private String user_value;
    private String password_value;
    private String role1_value = "Employee";
    private String role2_value = "Manager";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        this.user_value = this.props.getProperty(user);
        this.password_value = this.props.getProperty(password);
        this.logMsg("user_value=" + this.user_value);
        this.logMsg("password_value=" + this.password_value);
        this.logMsg("role1_value=" + this.role1_value);
        this.logMsg("role2_value=" + this.role2_value);
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Obtain login context and login as: " + this.user_value);
            TSLoginContext lc = new TSLoginContext();
            lc.login(this.user_value, this.password_value);
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.getEJBObjectTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.getEJBHomeTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.getEnvironmentTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.getCallerPrincipalTest(this.user_value);
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.isCallerInRoleTest(this.role1_value);
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test5b() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.isCallerInRoleTest(this.role2_value);
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test5b failed", e);
        }
        if (pass) {
            throw new EETest.Fault("test5b failed");
        }
    }

    public void test6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.setRollbackOnlyTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test6 failed");
        }
    }

    public void test6b() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxRequired");
            TestBean2Home beanHome2 = (TestBean2Home)this.nctx.lookup(txRequired, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            TestBean2 beanRef2 = beanHome2.create(this.props);
            pass = beanRef2.setRollbackOnlyTest();
            beanRef2.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test6b failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test6b failed");
        }
    }

    public void test7() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            pass = this.beanRef.getRollbackOnlyTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test7 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test7 failed");
        }
    }

    public void test7b() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxRequired");
            TestBean2Home beanHome2 = (TestBean2Home)this.nctx.lookup(txRequired, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            TestBean2 beanRef2 = beanHome2.create(this.props);
            pass = beanRef2.getRollbackOnlyTest();
            beanRef2.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test7b failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test7b failed");
        }
    }

    public void test8() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            this.logMsg("TX_BEAN_MANAGED bean can obtain UserTransaction interface");
            pass = this.beanRef.getUserTransactionTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test8 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test8 failed");
        }
    }

    public void test9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxNotSupported");
            this.bean2Home = (TestBean2Home)this.nctx.lookup(txNotSupported, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            this.bean2Ref = this.bean2Home.create(this.props);
            this.logMsg("NotSupported bean cannot obtain UserTransaction interface");
            pass = this.bean2Ref.getUserTransactionTest();
            this.bean2Ref.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test9 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test9 failed");
        }
    }

    public void test10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxSupports");
            this.bean2Home = (TestBean2Home)this.nctx.lookup(txSupports, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            this.bean2Ref = this.bean2Home.create(this.props);
            this.logMsg("Supports bean cannot obtain UserTransaction interface");
            pass = this.bean2Ref.getUserTransactionTest();
            this.bean2Ref.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test10 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test10 failed");
        }
    }

    public void test11() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxRequired");
            this.bean2Home = (TestBean2Home)this.nctx.lookup(txRequired, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            this.bean2Ref = this.bean2Home.create(this.props);
            this.logMsg("Required bean cannot obtain UserTransaction interface");
            pass = this.bean2Ref.getUserTransactionTest();
            this.bean2Ref.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test11 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test11 failed");
        }
    }

    public void test12() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxRequiresNew");
            this.bean2Home = (TestBean2Home)this.nctx.lookup(txRequiresNew, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            this.bean2Ref = this.bean2Home.create(this.props);
            this.logMsg("RequiresNew bean cannot obtain UserTransaction interface");
            pass = this.bean2Ref.getUserTransactionTest();
            this.bean2Ref.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test12 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test12 failed");
        }
    }

    public void test13() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            this.beanRef.beginTransaction();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxMandatory");
            this.bean2Home = (TestBean2Home)this.nctx.lookup(txMandatory, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            this.bean2Ref = this.bean2Home.create(this.props);
            this.logMsg("Mandatory bean cannot obtain UserTransaction interface");
            pass = this.beanRef.getUserTransactionTest(this.bean2Ref);
            this.beanRef.commitTransaction();
            this.bean2Ref.remove();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test13 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test13 failed");
        }
    }

    public void test14() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TxNever");
            this.bean2Home = (TestBean2Home)this.nctx.lookup(txNever, TestBean2Home.class);
            this.logMsg("Create EJB instance");
            this.bean2Ref = this.bean2Home.create(this.props);
            this.logMsg("TX_NEVER bean can obtain UserTransaction interface");
            pass = this.bean2Ref.getUserTransactionTest();
            this.bean2Ref.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test14 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test14 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

