/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgHdrQ;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class MsgBeanMsgTestHdrQ
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TextMessage messageSent = null;
    private StreamMessage messageSentStreamMessage = null;
    private BytesMessage messageSentBytesMessage = null;
    private MapMessage messageSentMapMessage = null;
    private ObjectMessage messageSentObjectMessage = null;

    public MsgBeanMsgTestHdrQ() {
        TestUtil.logTrace((String)"@MsgBeanMsgTestHdrQ()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgHdrQ  - @MsgBeanMsgTestHdrQ-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                TestUtil.logTrace((String)"queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        try {
            this.p = new Properties();
            JmsUtil.initHarnessProps(msg, this.p);
            TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgHdrQ @onMessage!" + msg));
            TestUtil.logTrace((String)("onMessage will run TestCase: " + msg.getStringProperty("TestCase")));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                throw new Exception("Null QueueConnection created");
            }
            this.qConnection.start();
            this.qSession = this.qConnection.createQueueSession(true, 0);
            Vector<Object> mVec = new Vector<Object>();
            this.messageSent = this.qSession.createTextMessage();
            mVec.addElement(this.messageSent);
            this.messageSentStreamMessage = this.qSession.createStreamMessage();
            mVec.addElement(this.messageSentStreamMessage);
            this.messageSentBytesMessage = this.qSession.createBytesMessage();
            mVec.addElement(this.messageSentBytesMessage);
            this.messageSentMapMessage = this.qSession.createMapMessage();
            mVec.addElement(this.messageSentMapMessage);
            this.messageSentObjectMessage = this.qSession.createObjectMessage();
            mVec.addElement(this.messageSentObjectMessage);
            Enumeration vNum = mVec.elements();
            while (vNum.hasMoreElements()) {
                JmsUtil.addPropsToMessage((Message)vNum.nextElement(), this.p);
            }
            if (msg.getStringProperty("TestCase").equals("msgHdrTimeStampQTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgHdrTimeStampQTest - create the message");
                this.msgHdrTimeStampQTest();
            } else if (msg.getStringProperty("TestCase").equals("dummy")) {
                TestUtil.logTrace((String)"@onMessage - ignore this!");
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQTextTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQTextTestCreate!");
                this.msgHdrCorlIdQTextTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQTextTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQTextTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQBytesTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQBytesTestCreate!");
                this.msgHdrCorlIdQBytesTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQBytesTest")) {
                TestUtil.logTrace((String)"@onMessage -msgHdrCorlIdQBytesTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQMapTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQMapTestCreate!");
                this.msgHdrCorlIdQMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQMapTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQMapTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQStreamTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQStreamTestCreate!");
                this.msgHdrCorlIdQStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQStreamTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQStreamTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQObjectTestCreate")) {
                TestUtil.logTrace((String)"@onMessage -msgHdrCorlIdQObjectTestCreate!");
                this.msgHdrCorlIdQObjectTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQObjectTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdQObjectTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrReplyToQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrReplyToQTestCreate!");
                this.msgHdrReplyToQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrReplyToQTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrReplyToQTest!");
                this.msgHdrReplyToQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSTypeQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSTypeQTestCreate!");
                this.msgHdrJMSTypeQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSTypeQTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSTypeQTest!");
                this.msgHdrJMSTypeQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSPriorityQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSPriorityQTestCreate!");
                this.msgHdrJMSPriorityQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSPriorityQTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSPriorityQTest!");
                this.msgHdrJMSPriorityQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSExpirationQueueTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSExpirationQueueTestCreate!");
                this.msgHdrJMSExpirationQueueTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSExpirationQueueTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSExpirationQueueTest!");
                this.msgHdrJMSExpirationQueueTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDestinationQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDestinationQTestCreate!");
                this.msgHdrJMSDestinationQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDestinationQTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDestinationQTest!");
                this.msgHdrJMSDestinationQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDeliveryModeQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDeliveryModeQTestCreate!");
                this.msgHdrJMSDeliveryModeQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDeliveryModeQTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDeliveryModeQTest!");
                this.msgHdrJMSDeliveryModeQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrIDQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrIDQTestCreate!");
                this.msgHdrIDQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrIDQTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrIDQTest!");
                this.msgHdrIDQTest(msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
                TestUtil.logTrace((String)("Do not have a method for this testcase: " + msg.getStringProperty("TestCase")));
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrTimeStampQTest() {
        boolean pass = true;
        byte bValue = 127;
        Object id = null;
        String testCase = "msgHdrTimeStampQTest";
        try {
            TestUtil.logTrace((String)"Send ObjectMessage to Queue.");
            this.messageSentObjectMessage.setObject((Serializable)((Object)"msgHdrTimeStampQTest for Object Message"));
            this.messageSentObjectMessage.setStringProperty("TestCase", "dummy");
            long timeBeforeSend = System.currentTimeMillis();
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentObjectMessage);
            long timeAfterSend = System.currentTimeMillis();
            TestUtil.logTrace((String)" getJMSTimestamp");
            TestUtil.logTrace((String)(" " + this.messageSentObjectMessage.getJMSTimestamp()));
            TestUtil.logTrace((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logTrace((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= this.messageSentObjectMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentObjectMessage.getJMSTimestamp()) {
                TestUtil.logTrace((String)"Object Message TimeStamp pass");
            } else {
                TestUtil.logMsg((String)"Error: invalid timestamp from ObjectMessage");
                pass = false;
            }
            TestUtil.logTrace((String)"Send MapMessage to Queue.");
            this.messageSentMapMessage.setStringProperty("TestCase", "dummy");
            this.messageSentMapMessage.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSentMapMessage);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logTrace((String)" getJMSTimestamp");
            TestUtil.logTrace((String)(" " + this.messageSentMapMessage.getJMSTimestamp()));
            TestUtil.logTrace((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logTrace((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= this.messageSentMapMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentMapMessage.getJMSTimestamp()) {
                TestUtil.logTrace((String)"MapMessage TimeStamp pass");
            } else {
                TestUtil.logMsg((String)"Error: invalid timestamp from MapMessage");
                pass = false;
            }
            TestUtil.logTrace((String)"Send BytesMessage to Queue.");
            this.messageSentBytesMessage.setStringProperty("TestCase", "dummy");
            this.messageSentBytesMessage.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSentBytesMessage);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logTrace((String)" getJMSTimestamp");
            TestUtil.logTrace((String)(" " + this.messageSentBytesMessage.getJMSTimestamp()));
            TestUtil.logTrace((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logTrace((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= this.messageSentBytesMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentBytesMessage.getJMSTimestamp()) {
                TestUtil.logTrace((String)"BytesMessage TimeStamp pass");
            } else {
                TestUtil.logMsg((String)"Error: invalid timestamp from BytesMessage");
                pass = false;
            }
            TestUtil.logTrace((String)"sending a Stream message");
            this.messageSentStreamMessage.setStringProperty("TestCase", "dummy");
            this.messageSentStreamMessage.writeString("Testing...");
            TestUtil.logTrace((String)"Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSentStreamMessage);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logTrace((String)" getJMSTimestamp");
            TestUtil.logTrace((String)(" " + this.messageSentStreamMessage.getJMSTimestamp()));
            TestUtil.logTrace((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logTrace((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= this.messageSentStreamMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentStreamMessage.getJMSTimestamp()) {
                TestUtil.logTrace((String)"StreamMessage TimeStamp pass");
            } else {
                TestUtil.logMsg((String)"Error: invalid timestamp from StreamMessage");
                pass = false;
            }
            this.messageSent.setText("sending a Text message");
            this.messageSent.setStringProperty("TestCase", "dummy");
            TestUtil.logTrace((String)"sending a Text message");
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSent);
            timeAfterSend = System.currentTimeMillis();
            TestUtil.logTrace((String)" getJMSTimestamp");
            TestUtil.logTrace((String)(" " + this.messageSent.getJMSTimestamp()));
            TestUtil.logTrace((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logTrace((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= this.messageSent.getJMSTimestamp() && timeAfterSend >= this.messageSent.getJMSTimestamp()) {
                TestUtil.logTrace((String)"TextMessage TimeStamp pass");
            } else {
                TestUtil.logMsg((String)"Error: invalid timestamp from TextMessage");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void msgHdrCorlIdQTextTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrCorlIdQTextTest");
            TestUtil.logTrace((String)"Send Text Message to Queue.");
            this.messageSent.setJMSCorrelationID(jmsCorrelationID);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQStreamTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            this.messageSentStreamMessage.setStringProperty("TestCase", "msgHdrCorlIdQStreamTest");
            this.messageSentStreamMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentStreamMessage.writeString("Testing...");
            TestUtil.logTrace((String)"Sending Stream message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentStreamMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQBytesTestCreate() {
        byte bValue = 127;
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)"Send BytesMessage to Queue.");
            this.messageSentBytesMessage.setStringProperty("TestCase", "msgHdrCorlIdQBytesTest");
            this.messageSentBytesMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentBytesMessage.writeByte(bValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentBytesMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQMapTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)"Send MapMessage to Queue.");
            this.messageSentMapMessage.setStringProperty("TestCase", "msgHdrCorlIdQMapTest");
            this.messageSentMapMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentMapMessage.setString("aString", "value");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQObjectTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)"Send ObjectMessage to Queue.");
            this.messageSentObjectMessage.setObject((Serializable)((Object)"msgHdrIDQObjectTest for Object Message"));
            this.messageSentObjectMessage.setStringProperty("TestCase", "msgHdrCorlIdQObjectTest");
            this.messageSentObjectMessage.setJMSCorrelationID(jmsCorrelationID);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentObjectMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrCorlIdQTest(Message messageReceived) {
        boolean pass = true;
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)("jmsCorrelationID:  " + messageReceived.getJMSCorrelationID()));
            if (messageReceived.getJMSCorrelationID() == null) {
                pass = false;
                TestUtil.logMsg((String)"Text Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceived.getJMSCorrelationID().equals(jmsCorrelationID)) {
                TestUtil.logTrace((String)"pass");
            } else {
                pass = false;
                TestUtil.logMsg((String)"Text Message Error: JMSCorrelationID is incorrect");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                this.sendTestResults(messageReceived.getStringProperty("TestCase"), pass);
            }
            catch (Exception j) {
                TestUtil.printStackTrace((Throwable)j);
            }
        }
    }

    public void msgHdrReplyToQTestCreate() {
        Object replyQueue = null;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrReplyToQTest");
            this.messageSent.setJMSReplyTo((Destination)this.queue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrReplyToQTest(Message messageReceived) {
        boolean pass = true;
        Queue replyQueue = null;
        String testCase = "msgHdrReplyToQTest";
        try {
            replyQueue = (Queue)messageReceived.getJMSReplyTo();
            TestUtil.logTrace((String)("Queue name is " + replyQueue.getQueueName()));
            if (replyQueue.getQueueName().equals(this.queue.getQueueName())) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"ReplyTo Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSTypeQTestCreate() {
        boolean pass = true;
        int bValue = 127;
        String type = "TESTMSG";
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSTypeQTest");
            TestUtil.logTrace((String)"JMSType test - Send a Text message");
            this.messageSent.setJMSType(type);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSTypeQTest(Message messageReceived) {
        boolean pass = true;
        String type = "TESTMSG";
        String testCase = "msgHdrJMSTypeQTest";
        try {
            TestUtil.logTrace((String)("JMSType is " + messageReceived.getJMSType()));
            if (messageReceived.getJMSType().equals(type)) {
                TestUtil.logTrace((String)"Pass");
            } else {
                TestUtil.logMsg((String)"Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSPriorityQTestCreate() {
        boolean pass = true;
        int bValue = 127;
        int priority = 2;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSPriorityQTest");
            TestUtil.logTrace((String)"JMSPriority test - Send a Text message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.setPriority(priority);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSPriorityQTest(Message messageReceived) {
        boolean pass = true;
        int priority = 2;
        String testCase = "msgHdrJMSPriorityQTest";
        try {
            TestUtil.logTrace((String)("JMSPriority is " + messageReceived.getJMSPriority()));
            if (messageReceived.getJMSPriority() == priority) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"JMSPriority test Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSExpirationQueueTestCreate() {
        boolean pass = true;
        long forever = 0L;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSExpirationQueueTest");
            TestUtil.logTrace((String)"JMSExpiration test - Send a Text message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.setTimeToLive(forever);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSExpirationQueueTest(Message messageReceived) {
        boolean pass = true;
        long forever = 0L;
        String testCase = "msgHdrJMSExpirationQueueTest";
        try {
            TestUtil.logTrace((String)("JMSExpiration is " + messageReceived.getJMSExpiration()));
            if (messageReceived.getJMSExpiration() == forever) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSDestinationQTestCreate() {
        Object replyDestination = null;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSDestinationQTest");
            TestUtil.logTrace((String)"send msg for JMSDestination test.");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSDestinationQTest(Message messageReceived) {
        boolean pass = true;
        Queue replyDestination = null;
        String testCase = "msgHdrJMSDestinationQTest";
        try {
            TestUtil.logTrace((String)("JMSDestination:  " + messageReceived.getJMSDestination()));
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                TestUtil.logTrace((String)("Queue name is " + replyDestination.getQueueName()));
            }
            if (replyDestination == null) {
                pass = false;
                TestUtil.logMsg((String)"Text Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getQueueName().equals(this.queue.getQueueName())) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception thrown in msgHdrJMSDestinationQTest:", (Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSDeliveryModeQTestCreate() {
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSDeliveryModeQTest");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSDeliveryModeQTest(Message messageReceived) {
        boolean pass = true;
        String testCase = "msgHdrJMSDeliveryModeQTest";
        try {
            TestUtil.logTrace((String)("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode()));
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                TestUtil.logMsg((String)"Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                TestUtil.logTrace((String)"Pass: Default delivery mode is persistent");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrIDQTestCreate() {
        Object id = null;
        try {
            this.messageSent.setText("sending a Text message");
            this.messageSent.setStringProperty("TestCase", "msgHdrIDQTest");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrIDQTest(Message messageReceived) {
        boolean pass = true;
        String id = null;
        String testCase = "msgHdrIDQTest";
        try {
            TestUtil.logTrace((String)"getJMSMessageID ");
            TestUtil.logTrace((String)(" " + messageReceived.getJMSMessageID()));
            id = messageReceived.getJMSMessageID();
            if (id.startsWith("ID:")) {
                TestUtil.logTrace((String)"Pass: JMSMessageID start with ID:");
            } else {
                TestUtil.logMsg((String)"Error: JMSMessageID does not start with ID:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            System.out.println("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            System.out.println("Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgHdrQ  In MsgBeanMsgTestHdrQ::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgHdrQ  In MsgBeanMsgTestHdrQ::remove()!!");
    }
}

